local function oncurrent(self,current)
	self.inst.shinai_level_current:set(current)
end

local shinai_level=Class(function(self,inst)
	self.inst=inst
	self.current=0
	self.max=9
end,
nil,
{
	current = oncurrent,
})

function shinai_level:DoDelta(num)
	self.current=math.floor(self.current+num)
	
	if self.current>=self.max then
		self.current=self.max
		self.inst.components.talker:Say("满级了,"..self.current.."级")
	else
		self.inst.components.talker:Say(self.current.."级")
	end
	if self.ondelta then self.ondelta(self.inst,self.current) end
end

function shinai_level:OnSave()
	return {
		current=self.current,
	}
end
function shinai_level:OnLoad(data)
	self.current=data and data.current or 0
end
	
return shinai_level