
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/shinai.zip" ),
        Asset( "ANIM", "anim/ghost_shinai_build.zip" ),
		Asset( "ANIM", "anim/shinai2.zip" ),
		Asset( "ATLAS", "images/shinai.xml" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
--"sn_gun","sn_longgun","sn_mp7",
"sn_ggo",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	
	inst.components.shinai_level:DoDelta(0)--激活一下
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "shinai.tex" )
	inst:AddTag("shinai_builder")
	
	----网络变量模板----------------------------------------------------(用于封装一个函数, 以后再封装)
	local nettab = {	--填表即可
		--maxtimepiont = {"net_shortint", 500},
		shinai_level_current = {"net_shortint", 0},
	}
	local t = 
	{
		net_shortint = net_shortint,
		net_tinybyte = net_tinybyte,
		net_smallbyte = net_smallbyte,
		net_byte = net_byte,
		net_shortint = net_shortint,
		net_ushortint = net_ushortint,
		net_int = net_int,
		net_uint = net_uint,
		net_float = net_float,
		net_hash = net_hash,
		net_string = net_string,
		net_entity = net_entity,
		net_bytearray = net_bytearray,
		net_smallbytearray = net_smallbytearray,
	}
	for k,v in pairs(nettab) do
		if type(v) == "table" then
			inst[k] = t[v[1]](inst.GUID, k, k.."dirty")
			inst[k]:set(v[2])
		end
	end
	--------------------------------------------------------------------

	
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(300)
	inst.components.sanity:SetMax(100)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst:AddComponent("shinai_level")
	inst.components.shinai_level.ondelta=function(inst,level)
		inst.components.combat.damagemultiplier = 1+.1*math.clamp(level,0,3)	--伤害倍数
		inst.shinai_dogechance=.1*math.clamp(level-3,3,6)	--闪避几率
		inst.components.locomotor:SetExternalSpeedMultiplier( inst, "shinai_speed_mod", 1+.1*math.clamp(level-6,0,3) )	--移动速度倍数
		if level>=9 then inst.AnimState:SetBuild("shinai2") end
	end
	--闪避
	local old_GetAttacked=inst.components.combat.GetAttacked
	function inst.components.combat:GetAttacked(attacker, damage, weapon, stimuli)
		local chance=self.inst.shinai_dogechance or 0
		if math.random()<chance then
			if self.inst.components.talker then self.inst.components.talker:Say("闪避") end
		else
			return old_GetAttacked(self, attacker, damage, weapon, stimuli)
		end
	end
	inst.components.shinai_level:DoDelta(0)
	--inst:DoTaskInTime(0,function() inst.components.shinai_level:DoDelta(0) end)
	
	--攻击恢复10精神
	--inst:ListenForEvent("onhitother",function(inst,data) inst.components.sanity:DoDelta(10) end)
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("shinai", prefabs, assets, common_postinit, master_postinit, start_inv),
	MakePlacer("catcoonden_placer", "catcoon_den", "catcoon_den", "idle")
