--普通物品构造模板v1.1 by 大猪猪
local prefix="sn_"

local manshape_defs={
	--ggo
	{
		name="ggo",
		anim="idle",
		zg_name="GGO武器箱",
		zg_desc="打开可随机获得一个GGO系列武器（GLOCK18，PGM Ultima Ratio Hecate II，H&K MP7）每种武器获得的几率相等",
		zg_desc_rec="随机GGO系列武器",
		teacher=true,
		onteach=function(inst, learner)
			if learner and learner.components.inventory then 
				local tab={"sn_gun","sn_longgun","sn_mp7"}
				learner.components.inventory:GiveItem(SpawnPrefab(tab[math.random(#tab)])) 
				if learner.components.talker then learner:DoTaskInTime(0,function() learner.components.talker:Say("获得一个GGO系列武器") end) end
			end
		end,
	},
	
	--alo
	{
		name="alo",
		anim="idle",
		zg_name="ALO武器箱",
		zg_desc="打开可随机获得一个ALO系列武器（精灵之弓，精灵圣剑，精灵旋刃）每种武器获得的几率相等",
		zg_desc_rec="随机ALO系列武器",
		teacher=true,
		onteach=function(inst, learner)
			if learner and learner.components.inventory then 
				local tab={"sn_sword","sn_bow","sn_boomerang"}
				learner.components.inventory:GiveItem(SpawnPrefab(tab[math.random(#tab)])) 
				if learner.components.talker then learner:DoTaskInTime(0,function() learner.components.talker:Say("获得一个ALO系列武器") end) end
			end
		end,
	},
	
	--精灵之心
	{
		name="heart",
		zg_name="精灵之心",
		zg_desc="使用恢复自身所有属性五十点，并给诗乃的猫精灵天赋升级",
		zg_desc_rec="精灵之心",
		teacher=true,
		onteach=function(inst, learner)
			if learner then
				if learner.components.health then learner.components.health:DoDelta(50) end
				if learner.components.sanity then learner.components.sanity:DoDelta(50) end
				if learner.components.hunger then learner.components.hunger:DoDelta(50) end
				if learner.prefab=="shinai" and learner.components.shinai_level then 
					learner.components.shinai_level:DoDelta(1) 
					learner:DoTaskInTime(0,function() 
						local current=learner.components.shinai_level.current
						local max=learner.components.shinai_level.max
						if current>=max then
							current=max
							learner.components.talker:Say("满级了,"..current.."级")
						else
							learner.components.talker:Say(current.."级")
						end
					end)
				end
			end
		end,
	},
}

local function MakeManshape(def)
	
	def.assets={
		Asset("ANIM","anim/"..prefix..def.name..".zip"),
		Asset("ATLAS","images/"..prefix..def.name..".xml"),
	}

	local function fn()
		local inst = CreateEntity()

		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddNetwork()
		inst.entity:AddSoundEmitter()

		MakeInventoryPhysics(inst)

		--地上图片
		inst.AnimState:SetBank(def.bank or prefix..def.name)
		inst.AnimState:SetBuild(def.build or prefix..def.name)
		inst.AnimState:PlayAnimation(def.anim or "NewAnimation")

		inst.entity:SetPristine()

		if not TheWorld.ismastersim then
			return inst
		end
		
		inst.zg_name=def.zg_name
		inst.zg_desc=def.zg_desc

		inst:AddComponent("inspectable")

		--物品栏图片
		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname="images/"..prefix..def.name..".xml"
		inst.components.inventoryitem.imagename=prefix..def.name
		
		--开盒子得到东西
		if def.teacher then
			inst:AddComponent("teacher")
			function inst.components.teacher:Teach(target)
				if self.onteach then 
					self.onteach(self.inst, target)
				end
				self.inst:Remove()
			end
			inst.components.teacher.onteach = def.onteach or function() end
		end

		return inst
	end
	return Prefab(prefix..def.name, fn, def.assets)
end




local manshapes = {}
for i, v in ipairs(manshape_defs) do
    table.insert(manshapes, MakeManshape(v))
	STRINGS.NAMES[string.upper(prefix..v.name)]=v.zg_name
	STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(prefix..v.name)]=v.zg_desc
	STRINGS.RECIPE_DESC[string.upper(prefix..v.name)] = v.zg_desc_rec
end
manshape_defs = nil
return unpack(manshapes)