--抛射物构造模板v1.1  by 大猪猪
local prefix="sn_proj_"

local proj_defs =
{
	--手枪的
	{
		name="gun",
		anim="idle",
		speed=50,
		offset=Vector3(1, 1, 0),
		onthrown=function(inst) inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround) end,
	},
	--长枪的
	{
		name="longgun",
		homing="no",
		speed=30,
		offset=Vector3(2, 1, 0),
		onthrown=function(inst) inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround) end,
	},
	--mp7的
	{
		name="mp7",
		homing="no",
		speed=30,
		offset=Vector3(1.5, 1, 0),
		onthrown=function(inst) inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround) end,
	},
	--精灵之弓的
	{
		name="bow",
		homing="no",
		speed=30,
		offset=Vector3(1, 1, 0),
		onthrown=function(inst) inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround) end,
	},
}

local function MakeProj(def)

	def.assets={
		Asset("ANIM","anim/"..prefix..def.name..".zip"),
	}
 
    local function fn()
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddSoundEmitter()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)
		RemovePhysicsColliders(inst)

        inst.AnimState:SetBank(def.bank or prefix..def.name)
        inst.AnimState:SetBuild(def.build or prefix..def.name)
        inst.AnimState:PlayAnimation(def.anim or "NewAnimation", true)
		
		local multcolour=def.multcolour
		if multcolour then
			inst.AnimState:SetMultColour(multcolour[1] or 1,multcolour[2] or 1,multcolour[3] or 1,multcolour[4] or 1)
		end
		
		inst:AddTag("projectile")

        inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end

		inst:AddComponent("projectile")
		inst.components.projectile:SetHoming(def.homing=="no" and false or true)
		inst.components.projectile:SetSpeed(def.speed or 30)
		inst.components.projectile:SetOnHitFn(def.onhit or inst.Remove)
		inst.components.projectile:SetOnMissFn(def.onmiss or def.onhit or inst.Remove)
		inst.components.projectile:SetHitDist(def.hitdist or 1)
		inst.components.projectile:SetLaunchOffset( def.offset or Vector3(0, 0, 0))
		
		inst:ListenForEvent("onthrown", def.onthrown or function() end)

        return inst
    end

    return Prefab(prefix..def.name, fn, def.assets)
end


--返回prefabs
local projs = {}
for i, v in ipairs(proj_defs) do
    table.insert(projs, MakeProj(v))
end
proj_defs = nil
return unpack(projs)