--武器构造模板v1.1 by 大猪猪
local prefix="sn_"

local manshape_defs={
	--手枪
	{
		name="gun",
		isgun=true,
		anim="idle",
		zg_name="GLOCK18",
		zg_desc="发射能量激光攻击",
		damage=100,
		attackrange=8,
		hitrange=12,	
		proj="sn_proj_gun",
		onattack=function(inst,attacker,target)
			if attacker and attacker.components.hunger then
				attacker.components.hunger:DoDelta(-8)
			end
		end,
		zg_atksound="sn_sound/atk/gun",
		failsound="",
		onequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		onunequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		trader=true,
		trader_test=function(inst, item)
			return item.prefab=="gears"
		end,
		trader_accept=function(inst, giver, item)
			if inst.components.finiteuses then inst.components.finiteuses:SetPercent(1) end
		end,
		trader_refuse=function(inst, giver, item)
			if item.prefab~="gears" then if giver.components.talker then giver.components.talker:Say("需要齿轮修理") end end
		end,
	},
	--狙击
	{
		name="longgun",
		isgun=true,
		anim="idle",
		zg_name="PGM Ultima Ratio Hecate II",
		zg_desc="发射幽灵子弹",
		damage=150,
		uses=10,
		attackrange=16,
		hitrange=20,	
		proj="sn_proj_mp7",
		onattack=function(inst,attacker,target)
			if attacker and attacker.components.hunger then
				attacker.components.hunger:DoDelta(-12)
			end
			if math.random()<.1 then
				if target.components.combat then
					target.components.combat:GetAttacked(attacker,150*9)
					SpawnPrefab("impact").Transform:SetPosition(target.Transform:GetWorldPosition())
				end
			end
		end,
		zg_atksound="sn_sound/atk/gun",
		failsound="",
		onequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(1)
		end,
		onunequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		trader=true,
		trader_test=function(inst, item)
			return item.prefab=="gears"
		end,
		trader_accept=function(inst, giver, item)
			if inst.components.finiteuses then inst.components.finiteuses:SetPercent(1) end
		end,
		trader_refuse=function(inst, giver, item)
			if item.prefab~="gears" then if giver.components.talker then giver.components.talker:Say("需要齿轮修理") end end
		end,
	},
	--mp7
	{
		name="mp7",
		isgun=true,
		anim="idle",
		zg_name="H&K MP7",
		zg_desc="拥有一般武器三倍的射速",
		damage=50,
		uses=30,
		attackrange=10,
		hitrange=14,	
		proj="sn_proj_longgun",
		onattack=function(inst,attacker,target)
			if attacker and attacker.components.hunger then
				attacker.components.hunger:DoDelta(-2)
			end
		end,
		zg_atksound="sn_sound/atk/mp7",
		failsound="",
		onequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.1)
		end,
		onunequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		trader=true,
		trader_test=function(inst, item)
			return item.prefab=="gears"
		end,
		trader_accept=function(inst, giver, item)
			if inst.components.finiteuses then inst.components.finiteuses:SetPercent(1) end
		end,
		trader_refuse=function(inst, giver, item)
			if item.prefab~="gears" then if giver.components.talker then giver.components.talker:Say("需要齿轮修理") end end
		end,
	},
	
	--精灵之弓
	{
		name="bow",
		isbow=true,
		zg_name="精灵之弓",
		zg_desc="附带精灵魔力的弓箭",
		damage=30,
		uses=60,
		attackrange=10,
		hitrange=14,	
		proj="sn_proj_bow",
		onattack=function(inst,attacker,target)
			if attacker then
				if attacker.components.hunger then attacker.components.hunger:DoDelta(-4) end
				if attacker.components.sanity then attacker.components.sanity:DoDelta(5) end
				local ran=math.random()
				if ran<.4 then
					
				elseif ran<.7 then	--多一击
					if target.components.combat then target.components.combat:GetAttacked(attacker,30) end
				elseif ran<.9 then	--多二击
					if target.components.combat then target.components.combat:GetAttacked(attacker,60) end
				else 	--多三击
					if target.components.combat then target.components.combat:GetAttacked(attacker,90) end
				end
			end
		end,
		zg_atksound="sn_sound/atk/bow",
		failsound="",
		onequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(1)
		end,
		onunequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		trader=true,
		trader_test=function(inst, item)
			return item.prefab=="sn_heart"
		end,
		trader_accept=function(inst, giver, item)
			if inst.components.finiteuses then inst.components.finiteuses:SetPercent(1) end
		end,
		trader_refuse=function(inst, giver, item)
			if item.prefab~="sn_heart" then if giver.components.talker then giver.components.talker:Say("需要精灵之心轮修理") end end
		end,
	},
	
	--精灵之剑
	{
		name="sword",
		zg_name="精灵圣剑",
		zg_desc="蕴含精灵祝福的圣剑",
		damage=90,
		uses=20,
		onattack=function(inst,attacker,target)
			if attacker then
				if attacker.components.hunger then attacker.components.hunger:DoDelta(-6) end
				if attacker.components.health then attacker.components.health:DoDelta(10) end
			end
		end,
		onequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		onunequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		trader=true,
		trader_test=function(inst, item)
			return item.prefab=="sn_heart"
		end,
		trader_accept=function(inst, giver, item)
			if inst.components.finiteuses then inst.components.finiteuses:SetPercent(1) end
		end,
		trader_refuse=function(inst, giver, item)
			if item.prefab~="sn_heart" then if giver.components.talker then giver.components.talker:Say("需要精灵之心轮修理") end end
		end,
	},
	
	--回旋镖
	{
		name="boomerang",
		scale=2,
		anim="idle",
		zg_name="精灵回旋刃",
		zg_desc="印刻精灵符文的回旋利刃",
		damage=60,
		uses=40,
		attackrange=10,
		hitrange=14,
		isthrow=true,
		onattack=function(inst,attacker,target)
			if attacker then
				if attacker.components.hunger then attacker.components.hunger:DoDelta(-10) end
				--if attacker.components.health then attacker.components.health:DoDelta(10) end
			end
		end,
		onequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		onunequipff=function(inst, owner)
			owner.components.combat:SetAttackPeriod(.5)
		end,
		trader=true,
		trader_test=function(inst, item)
			return item.prefab=="sn_heart"
		end,
		trader_accept=function(inst, giver, item)
			if inst.components.finiteuses then inst.components.finiteuses:SetPercent(1) end
		end,
		trader_refuse=function(inst, giver, item)
			if item.prefab~="sn_heart" then if giver.components.talker then giver.components.talker:Say("需要精灵之心轮修理") end end
		end,
		onthrown=function(inst, owner, target)
			if target ~= owner then
				owner.SoundEmitter:PlaySound("dontstarve/wilson/boomerang_throw")
			end
			inst.AnimState:PlayAnimation("spin_loop", true)
		end,
		onhit=function(inst, owner, target)
			if owner == target or owner:HasTag("playerghost") then
				inst.AnimState:PlayAnimation("idle")
			else
				if owner ~= nil and not (inst.components.finiteuses ~= nil and inst.components.finiteuses:GetUses() < 1) then
					owner.SoundEmitter:PlaySound("dontstarve/wilson/boomerang_return")
					inst.components.projectile:Throw(owner, owner)
				end
			end
		end,
		oncaught=function(inst, catcher)
			if catcher ~= nil and catcher.components.inventory ~= nil and catcher.components.inventory.isopen then
				if inst.components.equippable ~= nil and not catcher.components.inventory:GetEquippedItem(inst.components.equippable.equipslot) then
					catcher.components.inventory:Equip(inst)
				else
					catcher.components.inventory:GiveItem(inst)
				end
				catcher:PushEvent("catch")
			end
		end,
	},
}


local function MakeManshape(def)
	
	def.assets={
		Asset("ANIM","anim/"..prefix..def.name..".zip"),
		Asset("ANIM","anim/"..prefix..def.name.."_s.zip"),
		Asset("ATLAS","images/"..prefix..def.name.."_i.xml"),
	}
	
	local function onequip(inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", prefix..def.name.."_s", prefix..def.name.."_s")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")
		if def.onequipff then def.onequipff(inst, owner) end
	end

	local function onunequip(inst, owner)
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
		if def.onunequipff then def.onunequipff(inst, owner) end
	end

	local function fn()
		local inst = CreateEntity()

		inst.entity:AddTransform()
		
		local s=def.scale or 1
		inst.Transform:SetScale(s,s,s)
		
		inst.entity:AddAnimState()
		inst.entity:AddNetwork()
		inst.entity:AddSoundEmitter()

		MakeInventoryPhysics(inst)
		if def.isthrow then
			RemovePhysicsColliders(inst)
		end

		--地上图片
		inst.AnimState:SetBank(def.bank or prefix..def.name)
		inst.AnimState:SetBuild(def.build or prefix..def.name)
		inst.AnimState:PlayAnimation(def.anim or "NewAnimation")
		
		if def.isgun then
			inst:AddTag(prefix.."gun")
		elseif def.isbow then
			inst:AddTag(prefix.."bow")
		elseif def.isthrow then
			inst:AddTag("projectile")
			inst:AddTag(prefix.."boomerang")
		end

		inst.entity:SetPristine()

		if not TheWorld.ismastersim then
			return inst
		end
		
		inst.zg_name=def.zg_name
		inst.zg_desc=def.zg_desc
		
		inst.zg_atksound=def.zg_atksound
		inst.failsound=def.failsound
		
		--inst.outstate=def.outstate

		inst:AddComponent("weapon")
		inst.components.weapon:SetDamage(def.damage or 100)
		inst.components.weapon:SetRange(def.attackrange or 0, def.hitrange or def.attackrange or 0)
		inst.components.weapon.stimuli=def.stimuli or nil
		inst.components.weapon:SetProjectile(def.proj or nil)
		inst.components.weapon.onattack=def.onattack or function() end
		
		--不在传统的击中的时候消耗耐久以及消失
		if def.isgun or def.isbow then
			function inst.components.weapon:OnAttack(attacker, target, projectile)
				if self.onattack ~= nil then
					self.onattack(self.inst, attacker, target)
				end
			end	
		end
		
		if def.isthrow then
			inst:AddComponent("projectile")
			inst.components.projectile:SetSpeed(def.speed or 10)
			inst.components.projectile:SetCanCatch(true)
			inst.components.projectile:SetOnThrownFn(def.onthrown or function() end)
			inst.components.projectile:SetOnHitFn(def.onhit or function() end)
			inst.components.projectile:SetOnMissFn(def.onmiss or def.onhit or function() end)
			inst.components.projectile:SetOnCaughtFn(def.oncaught or function() end)
		end
		
		if def.trader then
			inst:AddComponent("trader")
			inst.components.trader:SetAcceptTest(def.trader_test or function() end)
			inst.components.trader.onaccept = def.trader_accept or function() end
			inst.components.trader.onrefuse = def.trader_refuse or function() end
		end
			
		inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(def.uses or 20)
		inst.components.finiteuses:SetUses(def.uses or 20)
		--inst.components.finiteuses:SetOnFinished(inst.Remove)

		inst:AddComponent("inspectable")

		--物品栏图片
		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname="images/"..prefix..def.name.."_i.xml"
		inst.components.inventoryitem.imagename=prefix..def.name.."_i"

		--手上图片
		inst:AddComponent("equippable")
		inst.components.equippable:SetOnEquip(onequip)
		inst.components.equippable:SetOnUnequip(onunequip)
		
		--减速效果
		inst.components.equippable.walkspeedmult=def.walkspeedmult or 1

		return inst
	end
	return Prefab(prefix..def.name, fn, def.assets)
end

local manshapes = {}
for i, v in ipairs(manshape_defs) do
    table.insert(manshapes, MakeManshape(v))
	STRINGS.NAMES[string.upper(prefix..v.name)]=v.zg_name
	STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(prefix..v.name)]=v.zg_desc
end
manshape_defs = nil
return unpack(manshapes)