﻿/** 
    @ Name : Careff Javascript Library 
    @ Author : 
    @ Date : 2017-5-1
    @ Email : 
    @ Version : 1.0 
    @ Update : 
    功能： 开始建立自己的JS类库，需要按照功能进行分类；
     */
(function () {
    if (!window.US) {
        window.US = {};
    };
    window.US = {
        NAME: "Us Framework",
        VERSION: '1.0',
        Date: '2017-05-01',
        /** 
             @ Name :1.基础类库名字空间 
             */
        BASIC: {
            $1: function () { //$()函数  
                var elements = new Array();
                for (var i = 0; i <= arguments.length; i++) {
                    var element = arguments[i];
                    //如果是一个字符串那假设它是一个ID  
                    if (typeof element == 'string') {
                        element = document.getElementById(element);
                    }
                    //如果只提供了一个参数,则立即返回这个参数  
                    if (arguments.length == 1) {
                        return element;
                    }
                    //否则，将它添加到数组中  
                    elements.push(element);
                }
                return elements;
            },
            /** 
             @ Name :显示进度条 
             @ Update : 
             功能： 显示时间进度条；
             */
            UsGetProcess: function (process, title) {
                var p = process;
                var imgName = "1";
                if (p < 50) {
                    imgName = "red";
                }
                else if (p < 70) {
                    imgName = "blue";
                }
                else if (p < 99) {
                    imgName = "green";
                }
                else {
                    imgName = "finish";
                }

                if (p > 100) {
                    p = 100;
                }
                if (p < 0) {
                    p = 0;
                }
                var html = '<table background="/upload/bar/' + imgName + '.jpg" width="' + p + '%" title="' + p + '%" height="10" class="tablebar1"><tr><td>' + title + '</td></tr></table>';
                return html;
            },
            /** 
             @ Name :转换字符为Float
             @ Update : 
             功能： 
             */
            UsToolsToFloat: function (src) {
                var ret = parseFloat(src);
                if (isNaN(ret)) {
                    return 0;
                }
                return ret;
            },
            //弹出窗口提示
            UsAlert: function (info)
            {
                UIkit.notify(info, { timeout: 2000, status: 'danger' });
                //alert(info);
            },
            //弹出窗口窗口关闭后返回事件
            UsAlert: function (info, callback) {
                var id = "UsAlert2017";
                var nid = "#" + id;
                var html = '<div id="' + id + '" class="uk-modal"><div class="uk-modal-dialog">';
                html += '<button type="button" class="uk-modal-close uk-close"></button>';
                html += '<div><h2>' + info + '</h2></div></div></div>';

                html = "";
                html += '<div id="' + id + '" class="uk-modal"><div class="uk-modal-dialog"><a class="uk-modal-close uk-close"></a>';
                html += '<div class="uk-modal-header"><h3>' + "系统提示" + '</h3> </div><ul>';
                html += '<li>' + info + '</li>';
                html += '</ul>';
                html += '<div class="uk-modal-footer uk-text-right">';
                html += '<button type="button" class="uk-button uk-modal-close uk-button-primary">关 闭</button>';
                html += '</div></div></div>';

                var $id = $(nid);

                if ($id.length == 0) {
                    $("body").append(html);
                    $id = $(nid);
                }
                var modal = UIkit.modal(nid);
                modal.on({
                    'show.uk.modal': function () {

                    },
                    'hide.uk.modal': function () {
                        $(nid).remove();
                        callback();
                    }
                });
                modal.show();
            },
            ////验证是否是手机号码
            UsIsPhone: function (info)
            {
                var b = true;
                var pattern = /^[1|9|8]\d{10}$/;
                b = pattern.test(info);
                if (!b)
                {
                    US.BASIC.UsAlert("请输入正确的手机号码！");
                }
                return b;
            },
            //验证是否是EMAIL
            UsIsEmail: function (info) {
                var b = true;
                var pattern = /^[a-za-z0-9_-]+@[a-za-z0-9_-]+(\.[a-za-z0-9_-]+)+$/;
                b = pattern.test(info);
                if (!b) {
                    US.BASIC.UsAlert("请输入正确的电子邮箱！");
                }
                return b;
            },
            UsIsEmailNull: function (info) {
                if (info.length > 0)
                {
                    return US.BASIC.UsIsEmail(info);
                }
                return true;
            },
            //验证长度是否小于length
            UsIsLength: function (info, length) {
                var b = true;
                if (info.length < length) {
                    b = false;
                    US.BASIC.UsAlert("长度必须大于或等于" + length + "位");
                }
                return b;
            },
            //验证长度是否小于length，如果小于，按title提示
            UsIsLengthObject: function (obj, length) {
                 
                var b = true;
                var info = obj.val();
                var title = obj.attr("title");
                if (info.length < length) {
                    b = false;
                    US.BASIC.UsAlert(""+title+"长度必须大于或等于" + length + "位");
                }
                return b;
            },
            //验证是否是空
            UsIsIsNullObject: function (obj) {

                var b = true;
                var info = obj.val();
                var title = obj.attr("title");
                if (info.length <1) {
                    b = false;
                    US.BASIC.UsAlert("" + title + "必须填写");
                }
                return b;
            },
            //验证二级域名是否符合规范
            UsSecondDomain: function (info) {
                /// <summary>验证二级域名是否符合规范</summary>  
                /// <param name="info" type="string">二级域名</param>  
                /// <returns type="bool">是否符合规范</returns>  
                var b = true;
                var pattern = /^([a-zA-Z][a-zA-Z0-9]{2,15})|(9\d{10})|(8\d{10})$/;
                b = pattern.test(info);
                if (!b) {
                    US.BASIC.UsAlert("二级域名需要字母开头3-16位，或8,9开头11数字");
                }
                return b;
            }
            ,
            //自动填充Select,d=数据 cid=用户控件，不需要带#,value字段名valuename
            UsToolsDrpSetValue: function (d1, cid, value,name) {
                var ncid = "#" + cid;
                $(ncid).empty();
                //alert(JSON.stringify(d1));
                var d = JSON.parse(d1);
                $.each(d, function (i, item) {
                    $(ncid).append("<option value='" + item.CodeID + "'>" + item.CodeName + "</option>");
                });
            },
            //关闭Loading
            UsCloseLoad: function () {
                $('#loading').fadeOut();
            },
            //关闭Loading
            UsOpenLoad: function () {

                var nid = "#loading";
                var $id = $(nid);

                if ($id.length == 0) {
                    var html = '<div id="loading"><div id="divloading"><img src="/admin/style/default/images/loading.gif" /></div></div>';
                    $("body").append(html);
                    $id = $(nid);
                }

                $('#loading').fadeIn();
            },
            UsGZMsg: '<div align="center"><p style="text-align:center; font-size:20px; line-height:30px;margin-bottom:30px; margin-top:30px;">关注并绑定公众号，您可以随时随地了解工单的处理进展！</p><img src="images/webp1.jpg"></div>',
            UsNoGZMsg: '<div align="center"><p style="text-align:center; font-size:20px; line-height:30px;margin-bottom:30px; margin-top:30px;">您尚未关注公众号，长按图片，识别二维码，一键关注我们！</p><img src="images/webp1.jpg"></div>',
            UsIsFireFox: function () {
                var b = false;
                if (navigator.userAgent.indexOf('Firefox') >= 0) {
                    b = true;
                }
                return b;
            },
            UsPreventDefault: function () {
                if (!US.BASIC.UsIsFireFox()) {
                    event.preventDefault();
                }
            }
        }
        , /** 
             @ Name :2.HTTP请求类库
             */
        HTTP: {
            UsVerson: function () {
                return US.VERSION;
            },
            BaseURL: "/admin/usajax.aspx",
            URLAdd : function(url)
            {
                var timestamp = Date.parse(new Date());
                timestamp = timestamp / 1000;
                if (url.indexOf("?") > 0) {
                    url += "&";
                }
                else {
                    url += "?";
                }
                url += "jsdate=" + timestamp;
                return url;
            },
            UsAjaxJSON: function (url, data, callback) {
              
                url = US.HTTP.URLAdd(url);
                //alert(url);
                US.BASIC.UsOpenLoad();
                $.ajax({
                    type: "POST",
                    url: url,
                    contentType: "application/json; charset=utf-8",
                    data: data,
                    dataType: "json",
                    async: true,
                    success: function (message) {
                        //alert(JSON.stringify(message));
                        callback(message);
                        US.BASIC.UsCloseLoad();
                    },
                    error: function (message) {
                        console.log(message);
                        //toastr.error(JSON.stringify(message));
                        US.BASIC.UsCloseLoad();
                        //alert(JSON.stringify(message));

                    },
                    beforeSend: function (XMLHttpRequest) {
                        this; // 调用本次AJAX请求时传递的options参数
                        //alert("beforeSend");
                    },
                    complete: function (XMLHttpRequest, textStatus) {
                        this; // 调用本次AJAX请求时传递的options参数
                        //alert("complete");
                    }


                });
            },
            UsAjaxHTML: function (url, data, callback) {
                //alert(data);
                url = US.HTTP.URLAdd(url);
                US.BASIC.UsOpenLoad();
                $.ajax({
                    type: "POST",
                    url: url,
                    contentType: "application/html; charset=utf-8",
                    data: data,
                    dataType: "html",
                    async: true,
                    success: function (message) {
                        //alert(JSON.stringify(message));
                        callback(message);
                        US.BASIC.UsCloseLoad();
                    },
                    error: function (message) {
                        console.log(message);
                        //toastr.error(JSON.stringify(message));
                        US.BASIC.UsCloseLoad();
                        //alert(JSON.stringify(message));

                    },
                    beforeSend: function (XMLHttpRequest) {
                        this; // 调用本次AJAX请求时传递的options参数
                        //alert("beforeSend");
                    },
                    complete: function (XMLHttpRequest, textStatus) {
                        this; // 调用本次AJAX请求时传递的options参数
                        //alert("complete");
                    }


                });
            },
        }
        , /** 
             @ Name :3.Cookies操作
             */
        COOKIES: {
            UsVerson: function () {
                return US.VERSION;
            }
        }
        , /** 
             @ Name :4.窗口操作
             */
        DIALOG: {
            UsVerson: function () {
                return US.VERSION;
            }
        }
    };

})();