PrefabFiles = {
	"charlie",
}


Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/charlie.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/charlie.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/charlie.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/charlie.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/charlie_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/charlie_silho.xml" ),

    Asset( "IMAGE", "bigportraits/charlie.tex" ),
    Asset( "ATLAS", "bigportraits/charlie.xml" ),
	
	Asset( "IMAGE", "images/map_icons/charlie.tex" ),
	Asset( "ATLAS", "images/map_icons/charlie.xml" ),
	
	Asset("SOUNDPACKAGE", "sound/charlie.fev"),
    Asset("SOUND", "sound/charlie.fsb"),

}

local require = GLOBAL.require

-- strings! Any "charlie" below would have to be replaced by the prefab name of your character.

-- The character select screen lines
-- note: these are lower-case  character name
GLOBAL.STRINGS.CHARACTER_TITLES.charlie = "The Assistant"
GLOBAL.STRINGS.CHARACTER_NAMES.charlie = "Charlie"  -- Note! This line is especially important as some parts of the game require
                                            -- the character to have a valid name.
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.charlie = "*Looking for the magician.\n*The darkness she fears also strengthens her."
GLOBAL.STRINGS.CHARACTER_QUOTES.charlie = "\"Hello?\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE character name
GLOBAL.STRINGS.CHARACTERS.CHARLIE = require "speech_charlie"

-- Let the game know charlie is a male, for proper pronouns during the end-game sequence.
-- Possible genders here are MALE, FEMALE, or ROBOT
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "charlie")

AddMinimapAtlas("images/map_icons/charlie.xml")

AddModCharacter("charlie")

RemapSoundEvent( "dontstarve/characters/charlie/death_voice", "charlie/characters/charlie/death_voice" )
RemapSoundEvent( "dontstarve/characters/charlie/hurt", "charlie/characters/charlie/hurt" )
RemapSoundEvent( "dontstarve/characters/charlie/talk_LP", "charlie/characters/charlie/talk_LP" )
