/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Interceptors;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.omg.CORBA.INTERNAL;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorList {
    static final int INTERCEPTOR_TYPE_CLIENT = 0;
    static final int INTERCEPTOR_TYPE_SERVER = 1;
    static final int INTERCEPTOR_TYPE_IOR = 2;
    static final int NUM_INTERCEPTOR_TYPES = 3;
    static final Class[] classTypes = new Class[]{ClientRequestInterceptor.class, ServerRequestInterceptor.class, IORInterceptor.class};
    private boolean locked = false;
    private Interceptor[][] interceptors = new Interceptor[3][];

    InterceptorList() {
        this.initInterceptorArrays();
    }

    void destroyAll() {
        int n2 = this.interceptors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.interceptors[i2].length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.interceptors[i2][i3].destroy();
            }
        }
    }

    private void initInterceptorArrays() {
        for (int i2 = 0; i2 < 3; ++i2) {
            Class clazz = classTypes[i2];
            this.interceptors[i2] = (Interceptor[])Array.newInstance(clazz, 0);
        }
    }

    void lock() {
        this.locked = true;
    }

    void sortInterceptors() {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        int n2 = this.interceptors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            int n3 = this.interceptors[i2].length;
            if (n3 > 0) {
                arrayList = new ArrayList();
                arrayList2 = new ArrayList();
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                object = this.interceptors[i2][i3];
                if (object instanceof Comparable) {
                    arrayList.add(object);
                    continue;
                }
                arrayList2.add(object);
            }
            if (n3 <= 0 || arrayList.size() <= 0) continue;
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            object = arrayList2.iterator();
            for (int i4 = 0; i4 < n3; ++i4) {
                if (iterator.hasNext()) {
                    this.interceptors[i2][i4] = (Interceptor)iterator.next();
                    continue;
                }
                if (object.hasNext()) {
                    this.interceptors[i2][i4] = (Interceptor)object.next();
                    continue;
                }
                throw new INTERNAL("InterceptorList.sortInterceptors");
            }
        }
    }

    private void growInterceptorArray(int n2) {
        Class clazz = classTypes[n2];
        int n3 = this.interceptors[n2].length;
        Interceptor[] interceptorArray = (Interceptor[])Array.newInstance(clazz, n3 + 1);
        System.arraycopy(this.interceptors[n2], 0, interceptorArray, 0, n3);
        this.interceptors[n2] = interceptorArray;
    }

    boolean hasInterceptorsOfType(int n2) {
        return this.interceptors[n2].length > 0;
    }

    Interceptor[] getInterceptors(int n2) {
        return this.interceptors[n2];
    }

    void register_interceptor(Interceptor interceptor, int n2) throws DuplicateName {
        if (this.locked) {
            throw new INTERNAL("InterceptorList is locked.");
        }
        String string = interceptor.name();
        boolean bl2 = string.equals("");
        boolean bl3 = false;
        Interceptor[] interceptorArray = this.interceptors[n2];
        if (!bl2) {
            int n3 = interceptorArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Interceptor interceptor2 = interceptorArray[i2];
                if (!interceptor2.name().equals(string)) continue;
                bl3 = true;
                break;
            }
        }
        if (bl3) {
            throw new DuplicateName(string);
        }
        this.growInterceptorArray(n2);
        this.interceptors[n2][this.interceptors[n2].length - 1] = interceptor;
    }
}

