/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.service.ServicesForm;

public class DeleteServiceAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        String select = request.getParameter("select");
        String adminService = null;
        ObjectName oname = null;
        String domain = null;
        try {
            oname = new ObjectName(select);
            domain = oname.getDomain();
            adminService = Lists.getAdminAppService(this.mBServer, domain, request);
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.serviceName.bad", adminService);
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        request.setAttribute("adminAppService", (Object)adminService);
        ServicesForm servicesForm = new ServicesForm();
        if (select != null) {
            String[] services = new String[]{select};
            servicesForm.setServices(services);
        }
        request.setAttribute("servicesForm", (Object)servicesForm);
        ArrayList<String> list = new ArrayList<String>();
        try {
            String pattern = "*:type=Service,*";
            Iterator<ObjectName> items = this.mBServer.queryNames(new ObjectName(pattern), null).iterator();
            while (items.hasNext()) {
                list.add(((Object)items.next()).toString());
            }
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.select"));
            response.sendError(500, resources.getMessage(locale, "users.error.select"));
            return null;
        }
        Collections.sort(list);
        request.setAttribute("servicesList", list);
        return mapping.findForward("Services");
    }
}

