/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.UsersForm;

public final class DeleteUsersAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ObjectName dname;
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List Users Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        UsersForm usersForm = (UsersForm)form;
        String databaseName = usersForm.getDatabaseName();
        String[] users = usersForm.getUsers();
        if (users == null) {
            users = new String[]{};
        }
        try {
            dname = new ObjectName(databaseName);
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new String[1];
            for (int i = 0; i < users.length; ++i) {
                ObjectName oname = new ObjectName(users[i]);
                params[0] = oname.getKeyProperty("username");
                this.mserver.invoke(dname, "removeUser", params, signature);
            }
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"removeUser"), t);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"removeUser"));
            return null;
        }
        try {
            dname = new ObjectName(databaseName);
            this.mserver.invoke(dname, "save", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"save"), t);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"save"));
            return null;
        }
        return mapping.findForward("Users List Setup");
    }
}

