/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.GroupForm;

public final class SaveGroupAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List Roles Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        GroupForm groupForm = (GroupForm)form;
        String databaseName = URLDecoder.decode(groupForm.getDatabaseName());
        String objectName = groupForm.getObjectName();
        if (objectName == null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{groupForm.getGroupname(), groupForm.getDescription()};
            ObjectName oname = null;
            try {
                oname = new ObjectName(databaseName);
                objectName = (String)this.mserver.invoke(oname, "createGroup", params, signature);
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"createGroup"), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"createGroup"));
                return null;
            }
        }
        ObjectName oname = null;
        String attribute = null;
        try {
            oname = new ObjectName(objectName);
            attribute = "description";
            this.mserver.setAttribute(oname, new Attribute(attribute, groupForm.getDescription()));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.set.attribute", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.set.attribute", (Object)attribute));
            return null;
        }
        try {
            oname = new ObjectName(objectName);
            this.mserver.invoke(oname, "removeRoles", new Object[0], new String[0]);
            String[] roles = groupForm.getRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            String[] addsig = new String[]{"java.lang.String"};
            Object[] addpar = new Object[1];
            for (int i = 0; i < roles.length; ++i) {
                addpar[0] = new ObjectName(roles[i]).getKeyProperty("rolename");
                this.mserver.invoke(oname, "addRole", addpar, addsig);
            }
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"addRole"), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"addRole"));
            return null;
        }
        try {
            ObjectName dname = new ObjectName(databaseName);
            this.mserver.invoke(dname, "save", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"save"), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"save"));
            return null;
        }
        return mapping.findForward("Groups List Setup");
    }
}

