/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.valve;

import java.io.IOException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.valve.SingleSignOnValveForm;
import org.apache.webapp.admin.valve.ValveUtil;

public final class SaveSingleSignOnValveAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        SingleSignOnValveForm vform = (SingleSignOnValveForm)form;
        String adminAction = vform.getAdminAction();
        String vObjectName = vform.getObjectName();
        String parent = vform.getParentObjectName();
        String valveType = vform.getValveType();
        if ("Create".equals(adminAction)) {
            try {
                ObjectName pname = new ObjectName(parent);
                ObjectName oname = new ObjectName(pname.getDomain() + ":type=Valve,name=SingleSignOn");
                if (this.mBServer.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("singleSignOnValve", new ActionError("error.singleSignOn.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)adminAction), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)adminAction));
                return null;
            }
            vObjectName = ValveUtil.createValve(parent, valveType, response, request, mapping, (ApplicationServlet)this.getServlet());
        }
        String attribute = null;
        try {
            ObjectName voname = new ObjectName(vObjectName);
            attribute = "debug";
            int debug = 0;
            try {
                debug = Integer.parseInt(vform.getDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(voname, new Attribute("debug", new Integer(debug)));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

