/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.catalina.loader.Reloader;
import org.apache.catalina.loader.StandardClassLoaderMBean;
import org.apache.naming.JndiPermission;
import org.apache.tomcat.util.compat.JdkCompat;

public class StandardClassLoader
extends URLClassLoader
implements Reloader,
StandardClassLoaderMBean {
    private static final JdkCompat jdkCompat = JdkCompat.getJdkCompat();
    protected int debug = 0;
    protected boolean delegate = false;
    protected String[] repositories = new String[0];
    private ArrayList permissionList = new ArrayList();
    private HashMap loaderPC = new HashMap();
    private SecurityManager securityManager = null;
    private boolean policy_refresh = false;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected URLStreamHandlerFactory factory = null;

    public StandardClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
    }

    public StandardClassLoader(URLStreamHandlerFactory factory) {
        super(new URL[0], null, factory);
        this.factory = factory;
    }

    public StandardClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = parent;
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
    }

    public StandardClassLoader(ClassLoader parent, URLStreamHandlerFactory factory) {
        super(new URL[0], parent, factory);
        this.factory = factory;
    }

    public StandardClassLoader(String[] repositories) {
        super(StandardClassLoader.convert(repositories));
        this.parent = this.getParent();
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (repositories != null) {
            for (int i = 0; i < repositories.length; ++i) {
                this.addRepositoryInternal(repositories[i]);
            }
        }
    }

    public StandardClassLoader(String[] repositories, ClassLoader parent) {
        super(StandardClassLoader.convert(repositories), parent);
        this.parent = parent;
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (repositories != null) {
            for (int i = 0; i < repositories.length; ++i) {
                this.addRepositoryInternal(repositories[i]);
            }
        }
    }

    public StandardClassLoader(URL[] repositories, ClassLoader parent) {
        super(repositories, parent);
        this.parent = parent;
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (repositories != null) {
            for (int i = 0; i < repositories.length; ++i) {
                this.addRepositoryInternal(repositories[i].toString());
            }
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    protected void setPermissions(String path) {
        if (this.securityManager != null) {
            if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
                this.permissionList.add(new JndiPermission(path + "*"));
            } else {
                this.permissionList.add(new FilePermission(path + "-", "read"));
            }
        }
    }

    protected void setPermissions(URL url) {
        this.setPermissions(url.toString());
    }

    public void addRepository(String repository) {
        if (this.debug >= 1) {
            this.log("addRepository(" + repository + ")");
        }
        try {
            URLStreamHandler streamHandler = null;
            String protocol = StandardClassLoader.parseProtocol(repository);
            if (this.factory != null) {
                streamHandler = this.factory.createURLStreamHandler(protocol);
            }
            URL url = new URL(null, repository, streamHandler);
            super.addURL(url);
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid repository: " + repository);
            jdkCompat.chainException((Throwable)iae, (Throwable)e);
            throw iae;
        }
        this.addRepositoryInternal(repository);
    }

    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public boolean modified() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardClassLoader\r\n");
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        for (int i = 0; i < this.repositories.length; ++i) {
            sb.append("    ");
            sb.append(this.repositories[i]);
            sb.append("\r\n");
        }
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) throws ClassNotFoundException {
        int i;
        if (this.debug >= 3) {
            this.log("    findClass(" + name + ")");
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (this.debug >= 4) {
                    this.log("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (this.debug >= 4) {
                    this.log("      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (this.debug >= 4) {
                this.log("      super.findClass(" + name + ")");
            }
            try {
                StandardClassLoader se = this;
                synchronized (se) {
                    clazz = this.findLoadedClass(name);
                    if (clazz != null) {
                        return clazz;
                    }
                    clazz = super.findClass(name);
                }
            }
            catch (AccessControlException ace) {
                throw new ClassNotFoundException(name, ace);
            }
            catch (RuntimeException e) {
                if (this.debug >= 4) {
                    this.log("      -->RuntimeException Rethrown", e);
                }
                throw e;
            }
            if (clazz == null) {
                if (this.debug >= 3) {
                    this.log("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (this.debug >= 3) {
                this.log("    --> Passing on ClassNotFoundException", e);
            }
            throw e;
        }
        if (this.debug >= 4) {
            this.log("      Returning class " + clazz);
        }
        if (this.debug >= 4 && clazz != null) {
            this.log("      Loaded by " + clazz.getClassLoader());
        }
        return clazz;
    }

    public URL findResource(String name) {
        if (this.debug >= 3) {
            this.log("    findResource(" + name + ")");
        }
        URL url = super.findResource(name);
        if (this.debug >= 3) {
            if (url != null) {
                this.log("    --> Returning '" + url.toString() + "'");
            } else {
                this.log("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.debug >= 3) {
            this.log("    findResources(" + name + ")");
        }
        return super.findResources(name);
    }

    public URL getResource(String name) {
        ClassLoader loader;
        if (this.debug >= 2) {
            this.log("getResource(" + name + ")");
        }
        URL url = null;
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        URL url;
        if (this.debug >= 2) {
            this.log("getResourceAsStream(" + name + ")");
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from local");
            }
            try {
                return url.openStream();
            }
            catch (IOException e) {
                this.log("url.openStream(" + url.toString() + ")", e);
                return null;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i;
        if (this.debug >= 2) {
            this.log("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (name.startsWith("java.")) {
            ClassLoader loader = this.system;
            clazz = loader.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                this.log(error);
                throw new ClassNotFoundException(error, se);
            }
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (this.debug >= 3) {
                    this.log("  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected final PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl;
        PermissionCollection pc;
        if (!this.policy_refresh) {
            Policy policy = Policy.getPolicy();
            policy.refresh();
            this.policy_refresh = true;
        }
        if ((pc = (PermissionCollection)this.loaderPC.get(codeUrl = codeSource.getLocation().toString())) == null && (pc = super.getPermissions(codeSource)) != null) {
            Iterator perms = this.permissionList.iterator();
            while (perms.hasNext()) {
                Permission p = (Permission)perms.next();
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    protected static String parseProtocol(String spec) {
        if (spec == null) {
            return "";
        }
        int pos = spec.indexOf(58);
        if (pos <= 0) {
            return "";
        }
        return spec.substring(0, pos).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addRepositoryInternal(String repository) {
        block17: {
            URLStreamHandler streamHandler = null;
            String protocol = StandardClassLoader.parseProtocol(repository);
            if (this.factory != null) {
                streamHandler = this.factory.createURLStreamHandler(protocol);
            }
            if (!repository.endsWith(File.separator) && !repository.endsWith("/")) {
                ZipFile jarFile = null;
                try {
                    try {
                        Manifest manifest = null;
                        if (repository.startsWith("jar:")) {
                            URL url = new URL(null, repository, streamHandler);
                            JarURLConnection conn = (JarURLConnection)url.openConnection();
                            conn.setAllowUserInteraction(false);
                            conn.setDoInput(true);
                            conn.setDoOutput(false);
                            conn.connect();
                            jarFile = conn.getJarFile();
                        } else if (repository.startsWith("file://")) {
                            jarFile = new JarFile(repository.substring(7));
                        } else if (repository.startsWith("file:")) {
                            jarFile = new JarFile(repository.substring(5));
                        } else {
                            if (!repository.endsWith(".jar")) throw new IllegalArgumentException("addRepositoryInternal:  Invalid URL '" + repository + "'");
                            URL url = new URL(null, repository, streamHandler);
                            URLConnection conn = url.openConnection();
                            JarInputStream jis = new JarInputStream(conn.getInputStream());
                            manifest = jis.getManifest();
                        }
                        Object var10_13 = null;
                        if (jarFile == null) break block17;
                    }
                    catch (Throwable t) {
                        IllegalArgumentException iae = new IllegalArgumentException("addRepositoryInternal: repository='" + repository + "'");
                        jdkCompat.chainException((Throwable)iae, t);
                        throw iae;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    if (jarFile == null) throw throwable;
                    try {
                        jarFile.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable t) {}
                jarFile.close();
            }
        }
        String[] stringArray = this.repositories;
        synchronized (this.repositories) {
            String[] results = new String[this.repositories.length + 1];
            System.arraycopy(this.repositories, 0, results, 0, this.repositories.length);
            results[this.repositories.length] = repository;
            this.repositories = results;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected static URL[] convert(String[] input) {
        return StandardClassLoader.convert(input, null);
    }

    protected static URL[] convert(String[] input, URLStreamHandlerFactory factory) {
        URLStreamHandler streamHandler = null;
        URL[] url = new URL[input.length];
        for (int i = 0; i < url.length; ++i) {
            try {
                String protocol = StandardClassLoader.parseProtocol(input[i]);
                streamHandler = factory != null ? factory.createURLStreamHandler(protocol) : null;
                url[i] = new URL(null, input[i], streamHandler);
                continue;
            }
            catch (MalformedURLException e) {
                url[i] = null;
            }
        }
        return url;
    }

    protected InputStream findLoadedResource(String name) {
        return null;
    }

    private void log(String message) {
        System.out.println("StandardClassLoader: " + message);
    }

    private void log(String message, Throwable throwable) {
        System.out.println("StandardClassLoader: " + message);
        throwable.printStackTrace(System.out);
    }
}

