/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public final class ContextConfig
implements LifecycleListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$startup$ContextConfig == null ? (class$org$apache$catalina$startup$ContextConfig = ContextConfig.class$("org.apache.catalina.startup.ContextConfig")) : class$org$apache$catalina$startup$ContextConfig));
    private static Properties authenticators = null;
    private Context context = null;
    private int debug = 0;
    private String defaultWebXml = null;
    private boolean ok = false;
    private SAXParseException parseException = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private static Digester webDigester = null;
    private static WebRuleSet webRuleSet = new WebRuleSet();
    private static boolean xmlValidation = false;
    private static boolean xmlNamespaceAware = false;
    static /* synthetic */ Class class$org$apache$catalina$startup$ContextConfig;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String path) {
        this.defaultWebXml = path;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("contextConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void applicationConfig() {
        InputStream stream = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            log.info((Object)(sm.getString("contextConfig.applicationMissing") + " " + this.context));
            return;
        }
        long t1 = System.currentTimeMillis();
        if (webDigester == null) {
            webDigester = ContextConfig.createWebDigester();
        }
        URL url = null;
        Digester digester = webDigester;
        synchronized (digester) {
            block26: {
                block24: {
                    url = servletContext.getResource("/WEB-INF/web.xml");
                    if (url != null) {
                        InputSource is = new InputSource(url.toExternalForm());
                        is.setByteStream(stream);
                        webDigester.clear();
                        if (this.context instanceof StandardContext) {
                            ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                        }
                        webDigester.push((Object)this.context);
                        webDigester.setErrorHandler((ErrorHandler)new ContextErrorHandler());
                        webDigester.parse(is);
                        if (this.parseException != null) {
                            this.ok = false;
                        }
                        break block24;
                    }
                    log.info((Object)("No web.xml, using defaults " + this.context));
                }
                Object var9_10 = null;
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                }
                webDigester.clear();
                webDigester.push(null);
                webDigester.setErrorHandler(null);
                {
                    break block26;
                    catch (SAXParseException e) {
                        log.error((Object)sm.getString("contextConfig.applicationParse"), (Throwable)e);
                        log.error((Object)sm.getString("contextConfig.applicationPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                        this.ok = false;
                        Object var9_11 = null;
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                        }
                        webDigester.clear();
                        webDigester.push(null);
                        webDigester.setErrorHandler(null);
                        break block26;
                    }
                    catch (Exception e) {
                        log.error((Object)sm.getString("contextConfig.applicationParse"), (Throwable)e);
                        this.ok = false;
                        Object var9_12 = null;
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                        }
                        webDigester.clear();
                        webDigester.push(null);
                        webDigester.setErrorHandler(null);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    this.parseException = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                    }
                    webDigester.clear();
                    webDigester.push(null);
                    webDigester.setErrorHandler(null);
                    throw throwable;
                }
            }
        }
        webRuleSet.recycle();
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(t2 - t1);
        }
    }

    private synchronized void managerConfig() {
        if (this.context.getManager() == null) {
            if (this.context.getCluster() != null && this.context.getDistributable()) {
                try {
                    this.context.setManager(this.context.getCluster().createManager(this.context.getName()));
                }
                catch (Exception ex) {
                    log.error((Object)"contextConfig.clusteringInit", (Throwable)ex);
                    this.ok = false;
                }
            } else {
                this.context.setManager(new StandardManager());
            }
        }
    }

    private synchronized void authenticatorConfig() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline != null) {
                Valve basic = pipeline.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                Valve[] valves = pipeline.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        if (this.context.getRealm() == null) {
            log.error((Object)sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        if (authenticators == null) {
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
                if (is == null) {
                    log.error((Object)sm.getString("contextConfig.authenticatorResources"));
                    this.ok = false;
                    return;
                }
                authenticators = new Properties();
                authenticators.load(is);
            }
            catch (IOException e) {
                log.error((Object)sm.getString("contextConfig.authenticatorResources"), (Throwable)e);
                this.ok = false;
                return;
            }
        }
        String authenticatorName = null;
        authenticatorName = authenticators.getProperty(loginConfig.getAuthMethod());
        if (authenticatorName == null) {
            log.error((Object)sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        try {
            Pipeline pipeline;
            Class<?> authenticatorClass = Class.forName(authenticatorName);
            authenticator = (Valve)authenticatorClass.newInstance();
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                ((ContainerBase)((Object)this.context)).addValve(authenticator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t);
            this.ok = false;
        }
    }

    private static Digester createWebDigester() {
        Digester webDigester = ContextConfig.createWebXmlDigester(xmlNamespaceAware, xmlValidation);
        return webDigester;
    }

    public static Digester createWebXmlDigester(boolean namespaceAware, boolean validation) {
        Digester webDigester = DigesterFactory.newDigester(xmlValidation, xmlNamespaceAware, (RuleSet)webRuleSet);
        return webDigester;
    }

    private String getBaseDir() {
        Container engineC = this.context.getParent().getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void defaultConfig() {
        t1 = System.currentTimeMillis();
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if (!(file = new File(this.defaultWebXml)).isAbsolute()) {
            file = new File(this.getBaseDir(), this.defaultWebXml);
        }
        stream = null;
        source = null;
        try {
            if (file.exists()) ** GOTO lbl19
            stream = this.getClass().getClassLoader().getResourceAsStream(this.defaultWebXml);
            if (stream != null) {
                source = new InputSource(this.getClass().getClassLoader().getResource(this.defaultWebXml).toString());
            } else {
                ContextConfig.log.info((Object)"No default web.xml");
                return;
lbl19:
                // 1 sources

                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
            }
        }
        catch (Exception e) {
            ContextConfig.log.error((Object)(ContextConfig.sm.getString("contextConfig.defaultMissing") + " " + this.defaultWebXml + " " + file), (Throwable)e);
            return;
        }
        if (ContextConfig.webDigester == null) {
            ContextConfig.webDigester = ContextConfig.createWebDigester();
        }
        e = ContextConfig.webDigester;
        synchronized (e) {
            block29: {
                block27: {
                    source.setByteStream(stream);
                    if (this.context instanceof StandardContext) {
                        ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                    }
                    ContextConfig.webDigester.clear();
                    ContextConfig.webDigester.setClassLoader(this.getClass().getClassLoader());
                    ContextConfig.webDigester.setUseContextClassLoader(false);
                    ContextConfig.webDigester.push((Object)this.context);
                    ContextConfig.webDigester.setErrorHandler((ErrorHandler)new ContextErrorHandler());
                    ContextConfig.webDigester.parse(source);
                    if (this.parseException == null) break block27;
                    this.ok = false;
                }
                var9_8 = null;
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    ContextConfig.log.error((Object)ContextConfig.sm.getString("contextConfig.defaultClose"), (Throwable)e);
                }
                ContextConfig.webDigester.push(null);
                {
                    break block29;
                    catch (SAXParseException e) {
                        ContextConfig.log.error((Object)ContextConfig.sm.getString("contextConfig.defaultParse"), (Throwable)e);
                        ContextConfig.log.error((Object)ContextConfig.sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                        this.ok = false;
                        var9_9 = null;
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e) {
                            ContextConfig.log.error((Object)ContextConfig.sm.getString("contextConfig.defaultClose"), (Throwable)e);
                        }
                        ContextConfig.webDigester.push(null);
                        break block29;
                    }
                    catch (Exception e) {
                        ContextConfig.log.error((Object)ContextConfig.sm.getString("contextConfig.defaultParse"), (Throwable)e);
                        this.ok = false;
                        var9_10 = null;
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e) {
                            ContextConfig.log.error((Object)ContextConfig.sm.getString("contextConfig.defaultClose"), (Throwable)e);
                        }
                        ContextConfig.webDigester.push(null);
                    }
                }
                catch (Throwable var8_18) {
                    var9_11 = null;
                    this.parseException = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        ContextConfig.log.error((Object)ContextConfig.sm.getString("contextConfig.defaultClose"), (Throwable)e);
                    }
                    ContextConfig.webDigester.push(null);
                    throw var8_18;
                }
            }
        }
        ContextConfig.webRuleSet.recycle();
        t2 = System.currentTimeMillis();
        if (t2 - t1 > 200L) {
            ContextConfig.log.debug((Object)("Processed default web.xml " + file + " " + (t2 - t1)));
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "]: " + message);
        } else {
            log.info((Object)message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "] " + message, throwable);
        } else {
            log.error((Object)message, throwable);
        }
    }

    private synchronized void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.start"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        Container container = this.context.getParent();
        if (!this.context.getOverride()) {
            if (container instanceof Host) {
                ((Host)container).importDefaultContext(this.context);
                xmlValidation = this.context.getXmlValidation();
                if (!xmlValidation) {
                    xmlValidation = ((Host)container).getXmlValidation();
                }
                if (!(xmlNamespaceAware = this.context.getXmlNamespaceAware())) {
                    xmlNamespaceAware = ((Host)container).getXmlNamespaceAware();
                }
                container = container.getParent();
            }
            if (container instanceof Engine) {
                ((Engine)container).importDefaultContext(this.context);
            }
        }
        this.defaultConfig();
        this.applicationConfig();
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (this.ok) {
            this.managerConfig();
        }
        if (log.isDebugEnabled() && this.context instanceof ContainerBase) {
            log.debug((Object)"Pipline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    log.debug((Object)("  " + valves[i].getInfo()));
                }
            }
            log.debug((Object)"======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    private synchronized void stop() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.stop"));
        }
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        for (i = 0; i < securityConstraints.length; ++i) {
            this.context.removeConstraint(securityConstraints[i]);
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        for (i = 0; i < errorPages.length; ++i) {
            this.context.removeErrorPage(errorPages[i]);
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.context.removeFilterMap(filterMaps[i]);
        }
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        String[] securityRoles = this.context.findSecurityRoles();
        for (i = 0; i < securityRoles.length; ++i) {
            this.context.removeSecurityRole(securityRoles[i]);
        }
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        String[] taglibs = this.context.findTaglibs();
        for (i = 0; i < taglibs.length; ++i) {
            this.context.removeTaglib(taglibs[i]);
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        for (i = 0; i < welcomeFiles.length; ++i) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        for (i = 0; i < wrapperLifecycles.length; ++i) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        for (i = 0; i < wrapperListeners.length; ++i) {
            this.context.removeWrapperListener(wrapperListeners[i]);
        }
        this.ok = true;
    }

    private void validateSecurityRoles() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            String[] roles = constraints[i].findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || this.context.findSecurityRole(roles[j])) continue;
                log.info((Object)sm.getString("contextConfig.role.auth", roles[j]));
                this.context.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.findSecurityRole(runAs)) {
                log.info((Object)sm.getString("contextConfig.role.runas", runAs));
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.findSecurityRole(link)) continue;
                log.info((Object)sm.getString("contextConfig.role.link", link));
                this.context.addSecurityRole(link);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ContextErrorHandler
    implements ErrorHandler {
        private ContextErrorHandler() {
        }

        public void error(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        public void fatalError(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        public void warning(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }
    }
}

