/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.general.AbstractController;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.ui.general.GridBagHelper;
import com.sun.javaws.ui.general.Subcontroller;
import com.sun.javaws.ui.player.Player;
import com.sun.javaws.ui.prefs.SubcontrollerCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrefsPanel
extends JDialog
implements ChangeListener {
    private JTabbedPane tabPane;
    private ConfigProperties configProperties;
    private boolean exitOnClose;
    private AbstractController controller;
    private JButton _cancelButton;
    private JButton _resetButton;
    private JButton _okButton;

    private void addTabs() {
        String string = Globals.getOperatingSystemID();
        SubcontrollerCreator subcontrollerCreator = SubcontrollerCreator.getInstance();
        int n = subcontrollerCreator.getSubcontrollerCount();
        for (int i = 0; i < n; ++i) {
            this.tabPane.addTab(subcontrollerCreator.getSubcontrollerTitle(i), new JPanel());
            Subcontroller subcontroller = subcontrollerCreator.getSubcontroller(false, i);
            if (subcontroller == null) continue;
            subcontroller.revert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply() {
        this.controller.apply(true);
        if (InstallCache.refreshCacheLocation()) {
            Player.getPlayer().resetCacheEntryManager();
        }
        ConfigProperties configProperties = ConfigProperties.getInstance();
        boolean bl = false;
        ConfigProperties configProperties2 = configProperties;
        synchronized (configProperties2) {
            if (configProperties.doesNewVersionExist()) {
                configProperties.refresh();
            } else {
                configProperties.store();
                bl = true;
            }
        }
        if (!bl) {
            GeneralUtilities.showMessageDialog(this, Resources.getString("controlpanel.storeFailed"), Resources.getString("controlpanel.storeFailedTitle"), 0);
        }
    }

    private void closeControlPanel() {
        this.setVisible(false);
        this.tabPane.removeChangeListener(this);
        if (this.exitOnClose) {
            System.exit(0);
        }
        this.dispose();
    }

    private void ok() {
        this.apply();
        this.closeControlPanel();
    }

    private void revert() {
        this.controller.revert(true);
    }

    private void setSelectedTab(int n) {
        if (n != this.controller.getActiveSubcontrollerIndex()) {
            Subcontroller subcontroller = this.controller.getSubcontroller(n);
            this.controller.setActiveSubcontrollerIndex(n);
            if (subcontroller == null) {
                this.tabPane.setSelectedIndex(0);
                this.controller.setActiveSubcontrollerIndex(n);
                String string = this.tabPane.getTitleAt(n);
                this.tabPane.removeTabAt(n);
                this.tabPane.insertTab(string, null, this.controller.getActiveSubcontroller().getComponent(), null, n);
                this.tabPane.setSelectedIndex(n);
            }
        }
    }

    private Subcontroller createSubcontroller(int n) {
        return SubcontrollerCreator.getInstance().getSubcontroller(true, n);
    }

    public PrefsPanel(Frame frame, boolean bl) {
        super(frame, Resources.getString("controlpanel.title"), false);
        this.exitOnClose = bl;
        this.configProperties = ConfigProperties.getInstance();
        this.tabPane = new JTabbedPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabPane, "Center");
        this.controller = new AbstractController(){

            protected Subcontroller createSubcontroller(int n) {
                return PrefsPanel.this.createSubcontroller(n);
            }
        };
        this.addTabs();
        this.setSelectedTab(0);
        this.tabPane.addChangeListener(this);
        JPanel jPanel = new JPanel();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefsPanel.this.closeControlPanel();
            }
        };
        this._cancelButton = new JButton(Resources.getString("controlpanel.cancel"));
        int n = Resources.getVKCode("controlpanel.cancelMnemonic");
        KeyStroke keyStroke = KeyStroke.getKeyStroke((char)n);
        this._cancelButton.addActionListener(actionListener);
        this.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
        this._resetButton = new JButton(Resources.getString("controlpanel.reset"));
        this._resetButton.setMnemonic(Resources.getVKCode("controlpanel.resetMnemonic"));
        this._resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefsPanel.this.revert();
            }
        });
        this._okButton = new JButton(Resources.getString("controlpanel.ok"));
        this._okButton.setMnemonic(Resources.getVKCode("controlpanel.okMnemonic"));
        this.getRootPane().setDefaultButton(this._okButton);
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefsPanel.this.ok();
            }
        });
        Dimension dimension = this._cancelButton.getPreferredSize();
        Dimension dimension2 = this._resetButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = this._okButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        this._cancelButton.setPreferredSize(dimension);
        this._resetButton.setPreferredSize(dimension);
        this._okButton.setPreferredSize(dimension);
        jPanel.add(this._okButton);
        jPanel.add(this._resetButton);
        jPanel.add(this._cancelButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "East");
        this.getContentPane().add((Component)jPanel2, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PrefsPanel.this.closeControlPanel();
            }
        });
        this.pack();
        this.setSize(420, 400);
        GeneralUtilities.placeWindow(this);
    }

    public static void main(String[] stringArray) {
        PrefsPanel prefsPanel = new PrefsPanel(null, true);
        prefsPanel.show();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.tabPane.getSelectedIndex();
        if (n >= 0) {
            this.setSelectedTab(n);
        }
    }

    public static class PropertyPanel
    extends JPanel
    implements Subcontroller {
        private boolean started;

        public void apply() {
        }

        protected void createPropertyControls() {
        }

        public void revert() {
        }

        public void start() {
            if (!this.started) {
                this.started = true;
                this.createPropertyControls();
            }
        }

        public void stop() {
        }

        protected ConfigProperties getConfigProperties() {
            return ConfigProperties.getInstance();
        }

        public Component getComponent() {
            return this;
        }

        protected void addGridBagComponent(Container container, Component component, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, Insets insets, int n7, int n8) {
            GridBagHelper.addGridBagComponent(container, component, n, n2, n3, n4, d, d2, n5, n6, insets, n7, n8);
        }
    }
}

