if exists (select 1
            from  sysobjects
           where  id = object_id('BLVLSALE')
            and   type = 'U')
   drop table BLVLSALE
go


if exists (select 1
            from  sysobjects
           where  id = object_id('CLASSINFO')
            and   type = 'U')
   drop table CLASSINFO
go


if exists (select 1
            from  sysobjects
           where  id = object_id('SALES')
            and   type = 'U')
   drop table SALES
go


if exists (select 1
            from  sysobjects
           where  id = object_id('SCORE')
            and   type = 'U')
   drop table SCORE
go


if exists (select 1
            from  sysobjects
           where  id = object_id('STUDENT')
            and   type = 'U')
   drop table STUDENT
go


/*==============================================================*/
/* Table: BLVLSALE                                              */
/*==============================================================*/
create table BLVLSALE (
SALEWEEK             datetime             not null,
DATATYPE             varchar(40)          not null,
VALUE                decimal(5,2)         null,
constraint PK_BLVLSALE primary key  (SALEWEEK, DATATYPE)
)
go


/*==============================================================*/
/* Table: CLASSINFO                                             */
/*==============================================================*/
create table CLASSINFO (
CLASSID              varchar(10)          not null,
CLASSNAME            varchar(100)         not null,
TEACHER              varchar(20)          not null,
CLASSROOM            varchar(100)         null,
REMARK               varchar(255)         null,
constraint PK_CLASSINFO primary key  (CLASSID)
)
go


/*==============================================================*/
/* Table: SALES                                                 */
/*==============================================================*/
create table SALES (
sale_no              decimal(4)           not null,
sale_region          decimal(4)           not null,
sale_company         decimal(4)           not null,
sale_goods           decimal(4)           not null,
sale_date            datetime             not null,
sale_amount          decimal(18,2)        not null,
sale_sale            decimal(18,2)        not null,
constraint PK_SALES primary key  (sale_no)
)
go


/*==============================================================*/
/* Table: SCORE                                                 */
/*==============================================================*/
create table SCORE (
CLASSID              varchar(10)          not null,
STUDENTID            decimal(4)           not null,
SUBJECT              decimal(4)           not null,
SCORE                decimal(3,1)         not null,
constraint PK_SCORE primary key  (CLASSID, STUDENTID, SUBJECT)
)
go


/*==============================================================*/
/* Table: STUDENT                                               */
/*==============================================================*/
create table STUDENT (
CLASSID              varchar(10)          not null,
STUDENTID            decimal(4)           not null,
NAME                 varchar(20)          not null,
SEX                  decimal(4)           not null,
AGE                  decimal(4)           not null,
DRESS                varchar(100)         null,
TEL                  varchar(10)          null,
POST                 decimal(4)           null,
PHOTO                image                null,
REMARK               varchar(100)         null,
constraint PK_STUDENT primary key  (CLASSID, STUDENTID)
)
go


