/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.ClassDocCatalog;
import com.sun.tools.doclets.MessageRetriever;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Configuration {
    public static final int DEFAULT_TAB_STOP_LENGTH = 8;
    public static final String SOURCE_OUTPUT_DIR_NAME = "src-html/";
    public int linksourcetab = 8;
    public boolean genSrc = false;
    public boolean nosince = false;
    public boolean copydocfilesubdirs = false;
    public String charset = "";
    protected Set excludedDocFileDirs;
    protected Set excludedQualifiers;
    public RootDoc root;
    public String destdirname = "";
    public String docencoding = null;
    public String encoding = null;
    public boolean showauthor = false;
    public boolean showversion = false;
    public boolean nodate = false;
    public String sourcepath = "";
    public boolean nodeprecated = false;
    public PackageDoc[] packages;
    public ClassDocCatalog classDocCatalog;
    public MessageRetriever message = new MessageRetriever(this, "com.sun.tools.doclets.resources.doclets");

    public Configuration() {
        this.excludedDocFileDirs = new HashSet();
        this.excludedQualifiers = new HashSet();
    }

    public void setOptions(RootDoc rootDoc) {
        String[][] stringArray = rootDoc.options();
        this.root = rootDoc;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string = stringArray2[0].toLowerCase();
            if (string.equals("-d")) {
                this.destdirname = this.addTrailingFileSep(stringArray2[1]);
                continue;
            }
            if (string.equals("-docfilessubdirs")) {
                this.copydocfilesubdirs = true;
                continue;
            }
            if (string.equals("-docencoding")) {
                this.docencoding = stringArray2[1];
                continue;
            }
            if (string.equals("-encoding")) {
                this.encoding = stringArray2[1];
                continue;
            }
            if (string.equals("-author")) {
                this.showauthor = true;
                continue;
            }
            if (string.equals("-version")) {
                this.showversion = true;
                continue;
            }
            if (string.equals("-nodeprecated")) {
                this.nodeprecated = true;
                continue;
            }
            if (string.equals("-xnodate")) {
                this.nodate = true;
                continue;
            }
            if (string.equals("-sourcepath")) {
                this.sourcepath = stringArray2[1];
                continue;
            }
            if (string.equals("-classpath") && this.sourcepath.length() == 0) {
                this.sourcepath = stringArray2[1];
                continue;
            }
            if (string.equals("-excludedocfilessubdir")) {
                this.addToSet(this.excludedDocFileDirs, stringArray2[1]);
                continue;
            }
            if (string.equals("-noqualifier")) {
                this.addToSet(this.excludedQualifiers, stringArray2[1]);
                continue;
            }
            if (string.equals("-linksource")) {
                this.genSrc = true;
                continue;
            }
            if (!string.equals("-linksourcetab")) continue;
            this.genSrc = true;
            try {
                this.linksourcetab = Integer.parseInt(stringArray2[1]);
            }
            catch (NumberFormatException numberFormatException) {
                this.linksourcetab = -1;
            }
            if (this.linksourcetab > 0) continue;
            this.message.warning("doclet.linksourcetab_warning");
            this.linksourcetab = 8;
        }
        if (this.sourcepath.length() == 0) {
            this.sourcepath = System.getProperty("env.class.path");
        }
        if (this.docencoding == null) {
            this.docencoding = this.encoding;
        }
        this.packages = rootDoc.specifiedPackages();
        this.classDocCatalog = new ClassDocCatalog(rootDoc.specifiedClasses());
        Arrays.sort(this.packages);
        this.setSpecificDocletOptions(rootDoc);
    }

    public abstract void setSpecificDocletOptions(RootDoc var1);

    public int generalOptionLength(String string) {
        if ((string = string.toLowerCase()).equals("-docfilessubdirs") || string.equals("-linksource") || string.equals("-version") || string.equals("-nodeprecated") || string.equals("-author") || string.equals("-xnodate")) {
            return 1;
        }
        if (string.equals("-docencoding") || string.equals("-encoding") || string.equals("-excludedocfilessubdir") || string.equals("-noqualifier") || string.equals("-sourcepath") || string.equals("-d")) {
            return 2;
        }
        return -1;
    }

    public abstract int optionLength(String var1);

    public boolean shouldExcludeDocFileDir(String string) {
        return this.excludedDocFileDirs.contains(string);
    }

    public boolean shouldExcludeQualifier(String string) {
        if (this.excludedQualifiers.contains("all") || this.excludedQualifiers.contains(string)) {
            return true;
        }
        int n = -1;
        while ((n = string.indexOf(".", n + 1)) != -1) {
            if (!this.excludedQualifiers.contains(string.substring(0, n + 1) + "*")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean checkOutputFileEncoding(String string, DocErrorReporter docErrorReporter) {
        block11: {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = null;
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
            Object var8_5 = null;
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    docErrorReporter.printError(this.message.getText("doclet.Encoding_not_supported", string));
                    boolean bl = false;
                    Object var8_6 = null;
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    public boolean generalValidOptions(String[][] stringArray, DocErrorReporter docErrorReporter) {
        boolean bl = false;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string2 = stringArray2[0].toLowerCase();
            if (string2.equals("-d")) {
                String string3 = this.addTrailingFileSep(stringArray2[1]);
                File file = new File(string3);
                if (!file.exists()) {
                    new File(string3).mkdirs();
                    continue;
                }
                if (!file.isDirectory()) {
                    docErrorReporter.printError(this.message.getText("doclet.destination_directory_not_directory_0", file.getPath()));
                    return false;
                }
                if (file.canWrite()) continue;
                docErrorReporter.printError(this.message.getText("doclet.destination_directory_not_writable_0", file.getPath()));
                return false;
            }
            if (string2.equals("-docencoding")) {
                bl = true;
                if (this.checkOutputFileEncoding(stringArray2[1], docErrorReporter)) continue;
                return false;
            }
            if (!string2.equals("-encoding")) continue;
            string = stringArray2[1];
        }
        return bl || string.length() <= 0 || this.checkOutputFileEncoding(string, docErrorReporter);
    }

    public String getClassName(ClassDoc classDoc) {
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc != null && this.shouldExcludeQualifier(classDoc.containingPackage().name())) {
            return classDoc.name();
        }
        return classDoc.qualifiedName();
    }

    String addTrailingFileSep(String string) {
        int n;
        String string2 = System.getProperty("file.separator");
        String string3 = string2 + string2;
        while ((n = string.indexOf(string3)) >= 0) {
            string = string.substring(0, n) + string.substring(n + string2.length());
        }
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        return string;
    }

    protected void addToSet(Set set, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            set.add(string2);
        }
    }
}

