/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.util.Vector;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;

public class RemoteType
extends InterfaceType {
    public String getTypeDescription() {
        return "Remote interface";
    }

    private boolean initialize(boolean bl, ContextStack contextStack) {
        boolean bl2 = false;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (this.isConformingRemoteInterface(vector, vector2, vector3, bl, contextStack)) {
            bl2 = this.initialize(vector, vector2, vector3, contextStack, bl);
        }
        return bl2;
    }

    protected RemoteType(ContextStack contextStack, ClassDefinition classDefinition) {
        super(contextStack, classDefinition, 0xA001000);
    }

    protected RemoteType(ContextStack contextStack, ClassDefinition classDefinition, int n) {
        super(contextStack, classDefinition, n);
    }

    private static boolean couldBeRemote(boolean bl, ContextStack contextStack, ClassDefinition classDefinition) {
        boolean bl2 = false;
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        try {
            if (!classDefinition.isInterface()) {
                RemoteType.failedConstraint(16, bl, contextStack, classDefinition.getName());
            } else {
                bl2 = batchEnvironment.defRemote.implementedBy(batchEnvironment, classDefinition.getClassDeclaration());
                if (!bl2) {
                    RemoteType.failedConstraint(1, bl, contextStack, classDefinition.getName());
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            RemoteType.classNotFound(contextStack, classNotFound);
        }
        return bl2;
    }

    public static RemoteType forRemote(ClassDefinition classDefinition, ContextStack contextStack, boolean bl) {
        RemoteType remoteType;
        block8: {
            if (contextStack.anyErrors()) {
                return null;
            }
            boolean bl2 = false;
            remoteType = null;
            try {
                sun.tools.java.Type type = classDefinition.getType();
                Type type2 = RemoteType.getType(type, contextStack);
                if (type2 != null) {
                    if (!(type2 instanceof RemoteType)) {
                        return null;
                    }
                    return (RemoteType)type2;
                }
                if (RemoteType.couldBeRemote(bl, contextStack, classDefinition)) {
                    RemoteType remoteType2 = new RemoteType(contextStack, classDefinition);
                    RemoteType.putType(type, (Type)remoteType2, contextStack);
                    contextStack.push(remoteType2);
                    bl2 = true;
                    if (remoteType2.initialize(bl, contextStack)) {
                        contextStack.pop(true);
                        remoteType = remoteType2;
                    } else {
                        RemoteType.removeType(type, contextStack);
                        contextStack.pop(false);
                    }
                }
            }
            catch (CompilerError compilerError) {
                if (!bl2) break block8;
                contextStack.pop(false);
            }
        }
        return remoteType;
    }

    private boolean isConformingRemoteInterface(Vector vector, Vector vector2, Vector vector3, boolean bl, ContextStack contextStack) {
        ClassDefinition classDefinition = this.getClassDefinition();
        try {
            if (this.addRemoteInterfaces(vector, false, contextStack) == null) {
                return false;
            }
            if (!this.addAllMembers(vector3, true, bl, contextStack)) {
                return false;
            }
            if (this.addAllMethods(classDefinition, vector2, true, bl, contextStack) == null) {
                return false;
            }
            boolean bl2 = true;
            for (int i = 0; i < vector2.size(); ++i) {
                if (this.isConformingRemoteMethod((CompoundType.Method)vector2.elementAt(i), bl)) continue;
                bl2 = false;
            }
            if (!bl2) {
                return false;
            }
        }
        catch (ClassNotFound classNotFound) {
            RemoteType.classNotFound(contextStack, classNotFound);
            return false;
        }
        return true;
    }
}

