/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.logger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.logger.LoggersForm;

public class DeleteLoggerAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        String pattern = null;
        LoggersForm loggersForm = new LoggersForm();
        String select = request.getParameter("select");
        if (select != null) {
            String[] loggers = new String[]{select};
            loggersForm.setLoggers(loggers);
            pattern = select;
        }
        request.setAttribute("loggersForm", (Object)loggersForm);
        ArrayList<String> list = new ArrayList<String>();
        String parent = request.getParameter("parent");
        if (parent != null) {
            try {
                pattern = DeleteLoggerAction.getObjectName(parent, ":type=Logger");
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.select"));
                response.sendError(500, resources.getMessage(locale, "users.error.select"));
                return null;
            }
        }
        try {
            Iterator<ObjectName> items = this.mBServer.queryNames(new ObjectName(pattern), null).iterator();
            while (items.hasNext()) {
                list.add(((Object)items.next()).toString());
            }
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.select"));
            response.sendError(500, resources.getMessage(locale, "users.error.select"));
            return null;
        }
        Collections.sort(list);
        request.setAttribute("loggersList", list);
        return mapping.findForward("Loggers");
    }

    public static String getObjectName(String parent, String MBeanType) throws Exception {
        ObjectName poname = new ObjectName(parent);
        String domain = poname.getDomain();
        StringBuffer sb = new StringBuffer(domain + MBeanType);
        String type = poname.getKeyProperty("type");
        String j2eeType = poname.getKeyProperty("j2eeType");
        String path = "";
        String host = "";
        String name = poname.getKeyProperty("name");
        if (name != null && name.length() > 0) {
            name = name.substring(2);
            int i = name.indexOf("/");
            host = name.substring(0, i);
            path = name.substring(i);
        }
        if ("WebModule".equalsIgnoreCase(j2eeType)) {
            sb.append(",path=" + path);
            sb.append(",host=" + host);
        }
        if ("Host".equalsIgnoreCase(type)) {
            sb.append(",host=");
            sb.append(poname.getKeyProperty("host"));
        }
        if ("Service".equalsIgnoreCase(type)) {
            // empty if block
        }
        return sb.toString();
    }
}

