/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.logger;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.logger.LoggerForm;

public class EditLoggerAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ObjectName lname = null;
        StringBuffer sb = null;
        try {
            lname = new ObjectName(request.getParameter("select"));
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.loggerName.bad", (Object)request.getParameter("select"));
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        LoggerForm loggerFm = new LoggerForm();
        session.setAttribute("loggerForm", (Object)loggerFm);
        loggerFm.setAdminAction("Edit");
        loggerFm.setObjectName(lname.toString());
        loggerFm.setParentObjectName("");
        sb = new StringBuffer("");
        String host = lname.getKeyProperty("host");
        String context = lname.getKeyProperty("path");
        if (host != null) {
            sb.append(resources.getMessage(locale, "server.service.treeBuilder.host"));
            sb.append(" (" + host + ") > ");
        }
        if (context != null) {
            sb.append(resources.getMessage(locale, "server.service.treeBuilder.context"));
            sb.append(" (" + context + ") > ");
        }
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.logger", (Object)locale));
        loggerFm.setNodeLabel(sb.toString());
        loggerFm.setDebugLvlVals(Lists.getDebugLevels());
        loggerFm.setVerbosityLvlVals(Lists.getVerbosityLevels());
        loggerFm.setBooleanVals(Lists.getBooleanValues());
        String attribute = null;
        try {
            attribute = "className";
            String className = (String)this.mBServer.getAttribute(lname, attribute);
            int period = className.lastIndexOf(46);
            String loggerType = className.substring(period + 1);
            loggerFm.setLoggerType(loggerType);
            attribute = "debug";
            loggerFm.setDebugLvl(((Integer)this.mBServer.getAttribute(lname, attribute)).toString());
            attribute = "verbosity";
            loggerFm.setVerbosityLvl(((Integer)this.mBServer.getAttribute(lname, attribute)).toString());
            if ("FileLogger".equals(loggerType)) {
                attribute = "directory";
                loggerFm.setDirectory((String)this.mBServer.getAttribute(lname, attribute));
                attribute = "prefix";
                loggerFm.setPrefix((String)this.mBServer.getAttribute(lname, attribute));
                attribute = "suffix";
                loggerFm.setSuffix((String)this.mBServer.getAttribute(lname, attribute));
                attribute = "timestamp";
                loggerFm.setTimestamp(((Boolean)this.mBServer.getAttribute(lname, attribute)).toString());
            }
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
            return null;
        }
        return mapping.findForward("Logger");
    }
}

