/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.logger;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.logger.DeleteLoggerAction;
import org.apache.webapp.admin.logger.LoggerForm;

public final class SaveLoggerAction
extends Action {
    private String[] createStandardLoggerTypes = new String[]{"java.lang.String"};
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        LoggerForm lform = (LoggerForm)form;
        String adminAction = lform.getAdminAction();
        String lObjectName = lform.getObjectName();
        String loggerType = lform.getLoggerType();
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String parent = lform.getParentObjectName();
                String objectName = DeleteLoggerAction.getObjectName(parent, ":type=Logger");
                ObjectName pname = new ObjectName(parent);
                StringBuffer sb = new StringBuffer(pname.getDomain());
                try {
                    if ("Service".equalsIgnoreCase(pname.getKeyProperty("type"))) {
                        sb.append(":type=Engine");
                        parent = sb.toString();
                    }
                }
                catch (Exception e) {
                    String message = resources.getMessage(locale, "error.engineName.bad", (Object)sb.toString());
                    this.getServlet().log(message);
                    response.sendError(400, message);
                    return null;
                }
                ObjectName oname = new ObjectName(objectName);
                if (this.mBServer.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("loggerName", new ActionError("error.loggerName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                String domain = oname.getDomain();
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new String[]{parent};
                operation = "create" + loggerType;
                lObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createStandardLoggerTypes);
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    TreeControlNode parentNode = control.findNode(lform.getParentObjectName());
                    if (parentNode != null) {
                        String nodeLabel = resources.getMessage(locale, "server.service.treeBuilder.loggerFor", (Object)parentNode.getLabel().toString());
                        String encodedName = URLEncoder.encode(lObjectName);
                        TreeControlNode childNode = new TreeControlNode(lObjectName, "Logger.gif", nodeLabel, "EditLogger.do?select=" + encodedName, "content", true, domain);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parent + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName loname = new ObjectName(lObjectName);
            attribute = "debug";
            int debug = 0;
            try {
                debug = Integer.parseInt(lform.getDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(loname, new Attribute("debug", new Integer(debug)));
            attribute = "verbosity";
            int verbosity = 0;
            try {
                verbosity = Integer.parseInt(lform.getVerbosityLvl());
            }
            catch (Throwable t) {
                verbosity = 0;
            }
            this.mBServer.setAttribute(loname, new Attribute("verbosity", new Integer(verbosity)));
            if ("FileLogger".equalsIgnoreCase(loggerType)) {
                attribute = "directory";
                this.mBServer.setAttribute(loname, new Attribute("directory", lform.getDirectory()));
                attribute = "prefix";
                this.mBServer.setAttribute(loname, new Attribute("prefix", lform.getPrefix()));
                attribute = "suffix";
                this.mBServer.setAttribute(loname, new Attribute("suffix", lform.getSuffix()));
                attribute = "timestamp";
                this.mBServer.setAttribute(loname, new Attribute("timestamp", new Boolean(lform.getTimestamp())));
            }
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

