/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.realm;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.LabelValueBean;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.realm.DataSourceRealmForm;
import org.apache.webapp.admin.realm.JDBCRealmForm;
import org.apache.webapp.admin.realm.JNDIRealmForm;
import org.apache.webapp.admin.realm.MemoryRealmForm;
import org.apache.webapp.admin.realm.UserDatabaseRealmForm;

public class AddRealmAction
extends Action {
    private ArrayList types = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        String[] realmTypes = new String[]{"UserDatabaseRealm", "JNDIRealm", "MemoryRealm", "JDBCRealm", "DataSourceRealm"};
        String parent = request.getParameter("parent");
        String type = request.getParameter("type");
        if (type == null) {
            type = "UserDatabaseRealm";
        }
        this.types = new ArrayList();
        this.types.add(new LabelValueBean(type, "AddRealm.do?parent=" + URLEncoder.encode(parent) + "&type=" + type));
        for (int i = 0; i < realmTypes.length; ++i) {
            if (type.equalsIgnoreCase(realmTypes[i])) continue;
            this.types.add(new LabelValueBean(realmTypes[i], "AddRealm.do?parent=" + URLEncoder.encode(parent) + "&type=" + realmTypes[i]));
        }
        if ("UserDatabaseRealm".equalsIgnoreCase(type)) {
            this.createUserDatabaseRealm(session, parent);
        } else if ("JNDIRealm".equalsIgnoreCase(type)) {
            this.createJNDIRealm(session, parent);
        } else if ("MemoryRealm".equalsIgnoreCase(type)) {
            this.createMemoryRealm(session, parent);
        } else if ("JDBCRealm".equalsIgnoreCase(type)) {
            this.createJDBCRealm(session, parent);
        } else if ("DataSourceRealm".equalsIgnoreCase(type)) {
            this.createDataSourceRealm(session, parent);
        }
        return mapping.findForward(type);
    }

    private void createUserDatabaseRealm(HttpSession session, String parent) {
        UserDatabaseRealmForm realmFm = new UserDatabaseRealmForm();
        session.setAttribute("userDatabaseRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Create");
        realmFm.setObjectName("");
        realmFm.setParentObjectName(parent);
        String realmType = "UserDatabaseRealm";
        realmFm.setNodeLabel("Realm (" + realmType + ")");
        realmFm.setRealmType(realmType);
        realmFm.setDebugLvl("0");
        realmFm.setResource("");
        realmFm.setDebugLvlVals(Lists.getDebugLevels());
        realmFm.setRealmTypeVals(this.types);
    }

    private void createJNDIRealm(HttpSession session, String parent) {
        JNDIRealmForm realmFm = new JNDIRealmForm();
        session.setAttribute("jndiRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Create");
        realmFm.setObjectName("");
        realmFm.setParentObjectName(parent);
        String realmType = "JNDIRealm";
        realmFm.setNodeLabel("Realm (" + realmType + ")");
        realmFm.setRealmType(realmType);
        realmFm.setDebugLvl("0");
        realmFm.setDigest("");
        realmFm.setRoleBase("");
        realmFm.setUserSubtree("false");
        realmFm.setRoleSubtree("false");
        realmFm.setRolePattern("");
        realmFm.setUserRoleName("");
        realmFm.setRoleName("");
        realmFm.setRoleBase("");
        realmFm.setContextFactory("");
        realmFm.setUserPattern("");
        realmFm.setUserSearch("");
        realmFm.setUserPassword("");
        realmFm.setConnectionName("");
        realmFm.setConnectionPassword("");
        realmFm.setConnectionURL("");
        realmFm.setDebugLvlVals(Lists.getDebugLevels());
        realmFm.setSearchVals(Lists.getBooleanValues());
        realmFm.setRealmTypeVals(this.types);
    }

    private void createMemoryRealm(HttpSession session, String parent) {
        MemoryRealmForm realmFm = new MemoryRealmForm();
        session.setAttribute("memoryRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Create");
        realmFm.setObjectName("");
        realmFm.setParentObjectName(parent);
        String realmType = "MemoryRealm";
        realmFm.setNodeLabel("Realm (" + realmType + ")");
        realmFm.setRealmType(realmType);
        realmFm.setDebugLvl("0");
        realmFm.setPathName("");
        realmFm.setDebugLvlVals(Lists.getDebugLevels());
        realmFm.setRealmTypeVals(this.types);
    }

    private void createJDBCRealm(HttpSession session, String parent) {
        JDBCRealmForm realmFm = new JDBCRealmForm();
        session.setAttribute("jdbcRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Create");
        realmFm.setObjectName("");
        realmFm.setParentObjectName(parent);
        String realmType = "JDBCRealm";
        realmFm.setNodeLabel("Realm (" + realmType + ")");
        realmFm.setRealmType(realmType);
        realmFm.setDebugLvl("0");
        realmFm.setDigest("");
        realmFm.setDriver("");
        realmFm.setRoleNameCol("");
        realmFm.setPasswordCol("");
        realmFm.setUserTable("");
        realmFm.setRoleTable("");
        realmFm.setConnectionName("");
        realmFm.setConnectionPassword("");
        realmFm.setConnectionURL("");
        realmFm.setDebugLvlVals(Lists.getDebugLevels());
        realmFm.setRealmTypeVals(this.types);
    }

    private void createDataSourceRealm(HttpSession session, String parent) {
        DataSourceRealmForm realmFm = new DataSourceRealmForm();
        session.setAttribute("dataSourceRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Create");
        realmFm.setObjectName("");
        realmFm.setParentObjectName(parent);
        String realmType = "DataSourceRealm";
        realmFm.setNodeLabel("Realm (" + realmType + ")");
        realmFm.setRealmType(realmType);
        realmFm.setDebugLvl("0");
        realmFm.setDataSourceName("");
        realmFm.setDigest("");
        realmFm.setLocalDataSource("false");
        realmFm.setRoleNameCol("");
        realmFm.setUserCredCol("");
        realmFm.setUserNameCol("");
        realmFm.setUserRoleTable("");
        realmFm.setUserTable("");
        realmFm.setDebugLvlVals(Lists.getDebugLevels());
        realmFm.setRealmTypeVals(this.types);
        realmFm.setBooleanVals(Lists.getBooleanValues());
    }
}

