/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.server;

import java.io.IOException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.server.ServerForm;

public final class SaveServerAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ActionErrors errors = new ActionErrors();
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return new ActionForward(mapping.getInput());
        }
        ServerForm sform = (ServerForm)form;
        String sObjectName = sform.getObjectName();
        ObjectName soname = null;
        try {
            soname = new ObjectName(sObjectName);
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire Server MBean reference ", t);
        }
        String attribute = null;
        try {
            attribute = "debug";
            int debug = 0;
            try {
                debug = Integer.parseInt(sform.getDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(soname, new Attribute("debug", new Integer(debug)));
            attribute = "port";
            int port = 0;
            try {
                port = Integer.parseInt(sform.getPortNumberText());
            }
            catch (Throwable t) {
                port = 0;
            }
            this.mBServer.setAttribute(soname, new Attribute("port", new Integer(port)));
            if (port < 1024) {
                request.setAttribute("warning", (Object)"server.port.warning");
            }
            attribute = "shutdown";
            this.mBServer.setAttribute(soname, new Attribute("shutdown", sform.getShutdownText()));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

