/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.RequestUtil;
import org.apache.tomcat.util.compat.JdkCompat;

public class StatusTransformer {
    public static void setContentType(HttpServletResponse response, int mode) {
        if (mode == 0) {
            response.setContentType("text/html;charset=utf-8");
        } else if (mode == 1) {
            response.setContentType("text/xml;charset=utf-8");
        }
    }

    public static void writeHeader(PrintWriter writer, int mode) {
        if (mode == 0) {
            writer.print("<html>\n<head>\n<style>\nH1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}  table {\n    width: 100%;\n  }\n  td.page-title {\n    text-align: center;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: white;\n    color: black;\n  }\n  td.title {\n    text-align: left;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-style:italic;\n    font-weight: bold;\n    background: #D2A41C;\n  }\n  td.header-left {\n    text-align: left;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  td.header-center {\n    text-align: center;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  td.row-left {\n    text-align: left;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n    background: white;\n  }\n  td.row-center {\n    text-align: center;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n    background: white;\n  }\n  td.row-right {\n    text-align: right;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n    background: white;\n  }\n  TH {\n    text-align: center;\n    vertical-align: top;\n    font-family:sans-serif,Tahoma,Arial;\n    font-weight: bold;\n    background: #FFDC75;\n  }\n  TD {\n    text-align: center;\n    vertical-align: middle;\n    font-family:sans-serif,Tahoma,Arial;\n    color: black;\n    background: white;\n  }\n</style>\n");
        } else if (mode == 1) {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            writer.write("<?xml-stylesheet type=\"text/xsl\" href=\"/manager/xform.xsl\" ?>");
            writer.write("<status>");
        }
    }

    public static void writeBody(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<title>{0}</title>\n</head>\n\n<body bgcolor=\"#FFFFFF\">\n\n<table cellspacing=\"4\" width=\"100%\" border=\"0\">\n <tr>\n  <td colspan=\"2\">\n   <a href=\"http://jakarta.apache.org/\">\n    <img border=\"0\" alt=\"The Jakarta Project\" align=\"left\"\n         src=\"{0}/images/jakarta-logo.gif\">\n   </a>\n   <a href=\"http://jakarta.apache.org/tomcat/\">\n    <img border=\"0\" alt=\"The Tomcat Servlet/JSP Container\"\n         align=\"right\" src=\"{0}/images/tomcat.gif\">\n   </a>\n  </td>\n </tr>\n</table>\n<hr size=\"1\" noshade=\"noshade\">\n<table cellspacing=\"4\" width=\"100%\" border=\"0\">\n <tr>\n  <td class=\"page-title\" bordercolor=\"#000000\" align=\"left\" nowrap>\n   <font size=\"+2\">{1}</font>\n  </td>\n </tr>\n</table>\n<br>\n\n", args));
        }
    }

    public static void writeManager(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"4\" class=\"title\">{0}</td>\n</tr>\n <tr>\n  <td class=\"row-left\"><a href=\"{1}\">{2}</a></td>\n  <td class=\"row-center\"><a href=\"{3}\">{4}</a></td>\n  <td class=\"row-center\"><a href=\"{5}\">{6}</a></td>\n  <td class=\"row-right\"><a href=\"{7}\">{8}</a></td>\n </tr>\n</table>\n<br>\n\n", args));
        }
    }

    public static void writePageHeading(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"6\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-center\"><small>{1}</small></td>\n <td class=\"header-center\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-center\"><small>{5}</small></td>\n <td class=\"header-center\"><small>{6}</small></td>\n</tr>\n", args));
        }
    }

    public static void writeServerInfo(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format("<tr>\n <td class=\"row-center\"><small>{0}</small></td>\n <td class=\"row-center\"><small>{1}</small></td>\n <td class=\"row-center\"><small>{2}</small></td>\n <td class=\"row-center\"><small>{3}</small></td>\n <td class=\"row-center\"><small>{4}</small></td>\n <td class=\"row-center\"><small>{5}</small></td>\n</tr>\n</table>\n<br>\n\n", args));
        }
    }

    public static void writeFooter(PrintWriter writer, int mode) {
        if (mode == 0) {
            writer.print("<hr size=\"1\" noshade=\"noshade\">\n<center><font size=\"-1\" color=\"#525D76\">\n <em>Copyright &copy; 1999-2003, Apache Software Foundation</em></font></center>\n\n</body>\n</html>");
        } else if (mode == 1) {
            writer.write("</status>");
        }
    }

    public static void writeVMState(PrintWriter writer, int mode) throws Exception {
        if (mode == 0) {
            writer.print("<h1>JVM</h1>");
            writer.print("<p>");
            writer.print(" Free memory: ");
            writer.print(StatusTransformer.formatSize(new Long(Runtime.getRuntime().freeMemory()), true));
            writer.print(" Total memory: ");
            writer.print(StatusTransformer.formatSize(new Long(Runtime.getRuntime().totalMemory()), true));
            writer.print(" Max memory: ");
            writer.print(StatusTransformer.formatSize(new Long(JdkCompat.getJdkCompat().getMaxMemory()), true));
            writer.print("</p>");
        } else if (mode == 1) {
            writer.write("<jvm>");
            writer.write("<memory");
            writer.write(" free='" + Runtime.getRuntime().freeMemory() + "'");
            writer.write(" total='" + Runtime.getRuntime().totalMemory() + "'");
            writer.write(" max='" + JdkCompat.getJdkCompat().getMaxMemory() + "'/>");
            writer.write("</jvm>");
        }
    }

    public static void writeConnectorState(PrintWriter writer, ObjectName tpName, String name, MBeanServer mBeanServer, Vector globalRequestProcessors, Vector requestProcessors, int mode) throws Exception {
        if (mode == 0) {
            ObjectName objectName;
            writer.print("<h1>");
            writer.print(name);
            writer.print("</h1>");
            writer.print("<p>");
            writer.print(" Max threads: ");
            writer.print(mBeanServer.getAttribute(tpName, "maxThreads"));
            writer.print(" Min spare threads: ");
            writer.print(mBeanServer.getAttribute(tpName, "minSpareThreads"));
            writer.print(" Max spare threads: ");
            writer.print(mBeanServer.getAttribute(tpName, "maxSpareThreads"));
            writer.print(" Current thread count: ");
            writer.print(mBeanServer.getAttribute(tpName, "currentThreadCount"));
            writer.print(" Current thread busy: ");
            writer.print(mBeanServer.getAttribute(tpName, "currentThreadsBusy"));
            writer.print("<br>");
            ObjectName grpName = null;
            Enumeration enumeration = globalRequestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                objectName = (ObjectName)enumeration.nextElement();
                if (!name.equals(objectName.getKeyProperty("name"))) continue;
                grpName = objectName;
            }
            if (grpName == null) {
                return;
            }
            writer.print(" Max processing time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "maxTime"), false));
            writer.print(" Processing time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "processingTime"), true));
            writer.print(" Request count: ");
            writer.print(mBeanServer.getAttribute(grpName, "requestCount"));
            writer.print(" Error count: ");
            writer.print(mBeanServer.getAttribute(grpName, "errorCount"));
            writer.print(" Bytes received: ");
            writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesReceived"), true));
            writer.print(" Bytes sent: ");
            writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesSent"), true));
            writer.print("</p>");
            writer.print("<table border=\"0\"><tr><th>Stage</th><th>Time</th><th>B Sent</th><th>B Recv</th><th>Client</th><th>VHost</th><th>Request</th></tr>");
            enumeration = requestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                objectName = (ObjectName)enumeration.nextElement();
                if (!name.equals(objectName.getKeyProperty("worker"))) continue;
                writer.print("<tr>");
                StatusTransformer.writeProcessorState(writer, objectName, mBeanServer, mode);
                writer.print("</tr>");
            }
            writer.print("</table>");
            writer.print("<p>");
            writer.print("P: Parse and prepare request S: Service F: Finishing R: Ready K: Keepalive");
            writer.print("</p>");
        } else if (mode == 1) {
            ObjectName objectName;
            writer.write("<connector name='" + name + "'>");
            writer.write("<threadInfo ");
            writer.write(" maxThreads=\"" + mBeanServer.getAttribute(tpName, "maxThreads") + "\"");
            writer.write(" minSpareThreads=\"" + mBeanServer.getAttribute(tpName, "minSpareThreads") + "\"");
            writer.write(" maxSpareThreads=\"" + mBeanServer.getAttribute(tpName, "maxSpareThreads") + "\"");
            writer.write(" currentThreadCount=\"" + mBeanServer.getAttribute(tpName, "currentThreadCount") + "\"");
            writer.write(" currentThreadsBusy=\"" + mBeanServer.getAttribute(tpName, "currentThreadsBusy") + "\"");
            writer.write(" />");
            ObjectName grpName = null;
            Enumeration enumeration = globalRequestProcessors.elements();
            while (enumeration.hasMoreElements()) {
                objectName = (ObjectName)enumeration.nextElement();
                if (!name.equals(objectName.getKeyProperty("name"))) continue;
                grpName = objectName;
            }
            if (grpName != null) {
                writer.write("<requestInfo ");
                writer.write(" maxTime=\"" + mBeanServer.getAttribute(grpName, "maxTime") + "\"");
                writer.write(" processingTime=\"" + mBeanServer.getAttribute(grpName, "processingTime") + "\"");
                writer.write(" requestCount=\"" + mBeanServer.getAttribute(grpName, "requestCount") + "\"");
                writer.write(" errorCount=\"" + mBeanServer.getAttribute(grpName, "errorCount") + "\"");
                writer.write(" bytesReceived=\"" + mBeanServer.getAttribute(grpName, "bytesReceived") + "\"");
                writer.write(" bytesSent=\"" + mBeanServer.getAttribute(grpName, "bytesSent") + "\"");
                writer.write(" />");
                writer.write("<workers>");
                enumeration = requestProcessors.elements();
                while (enumeration.hasMoreElements()) {
                    objectName = (ObjectName)enumeration.nextElement();
                    if (!name.equals(objectName.getKeyProperty("worker"))) continue;
                    StatusTransformer.writeProcessorState(writer, objectName, mBeanServer, mode);
                }
                writer.write("</workers>");
            }
            writer.write("</connector>");
        }
    }

    protected static void writeProcessorState(PrintWriter writer, ObjectName pName, MBeanServer mBeanServer, int mode) throws Exception {
        Integer stageValue = (Integer)mBeanServer.getAttribute(pName, "stage");
        int stage = stageValue;
        boolean fullStatus = true;
        boolean showRequest = true;
        String stageStr = null;
        switch (stage) {
            case 1: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 2: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 3: {
                stageStr = "S";
                break;
            }
            case 4: {
                stageStr = "F";
                break;
            }
            case 5: {
                stageStr = "F";
                break;
            }
            case 7: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            case 6: {
                stageStr = "K";
                fullStatus = true;
                showRequest = false;
                break;
            }
            case 0: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            default: {
                stageStr = "?";
                fullStatus = false;
            }
        }
        if (mode == 0) {
            writer.write("<td><strong>");
            writer.write(stageStr);
            writer.write("</strong></td>");
            if (fullStatus) {
                writer.write("<td>");
                writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(pName, "requestProcessingTime"), false));
                writer.write("</td>");
                writer.write("<td>");
                if (showRequest) {
                    writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesSent"), false));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
                writer.write("<td>");
                if (showRequest) {
                    writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesReceived"), false));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
                writer.write("<td>");
                writer.print(StatusTransformer.filter(mBeanServer.getAttribute(pName, "remoteAddr")));
                writer.write("</td>");
                writer.write("<td nowrap>");
                writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "virtualHost")));
                writer.write("</td>");
                writer.write("<td nowrap>");
                if (showRequest) {
                    writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "method")));
                    writer.write(" ");
                    writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "currentUri")));
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer.write("?");
                        writer.print(RequestUtil.filter((String)queryString));
                    }
                    writer.write(" ");
                    writer.write(StatusTransformer.filter(mBeanServer.getAttribute(pName, "protocol")));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
            } else {
                writer.write("<td>?</td><td>?</td><td>?</td><td>?</td><td>?</td><td>?</td>");
            }
        } else if (mode == 1) {
            writer.write("<worker ");
            writer.write(" stage=\"" + stageStr + "\"");
            if (fullStatus) {
                writer.write(" requestProcessingTime=\"" + mBeanServer.getAttribute(pName, "requestProcessingTime") + "\"");
                writer.write(" requestBytesSent=\"");
                if (showRequest) {
                    writer.write("" + mBeanServer.getAttribute(pName, "requestBytesSent"));
                } else {
                    writer.write("0");
                }
                writer.write("\"");
                writer.write(" requestBytesReceived=\"");
                if (showRequest) {
                    writer.write("" + mBeanServer.getAttribute(pName, "requestBytesReceived"));
                } else {
                    writer.write("0");
                }
                writer.write("\"");
                writer.write(" remoteAddr=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "remoteAddr")) + "\"");
                writer.write(" virtualHost=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "virtualHost")) + "\"");
                if (showRequest) {
                    writer.write(" method=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "method")) + "\"");
                    writer.write(" currentUri=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "currentUri")) + "\"");
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer.write(" currentQueryString=\"" + RequestUtil.filter((String)queryString) + "\"");
                    } else {
                        writer.write(" currentQueryString=\"&#63;\"");
                    }
                    writer.write(" protocol=\"" + StatusTransformer.filter(mBeanServer.getAttribute(pName, "protocol")) + "\"");
                } else {
                    writer.write(" method=\"&#63;\"");
                    writer.write(" currentUri=\"&#63;\"");
                    writer.write(" currentQueryString=\"&#63;\"");
                    writer.write(" protocol=\"&#63;\"");
                }
            } else {
                writer.write(" requestProcessingTime=\"0\"");
                writer.write(" requestBytesSent=\"0\"");
                writer.write(" requestBytesRecieved=\"0\"");
                writer.write(" remoteAddr=\"&#63;\"");
                writer.write(" virtualHost=\"&#63;\"");
                writer.write(" method=\"&#63;\"");
                writer.write(" currentUri=\"&#63;\"");
                writer.write(" currentQueryString=\"&#63;\"");
                writer.write(" protocol=\"&#63;\"");
            }
            writer.write(" />");
        }
    }

    public static void writeDetailedState(PrintWriter writer, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            ObjectName contextON;
            ObjectName queryHosts = new ObjectName("*:j2eeType=WebModule,*");
            Set<ObjectName> hostsON = mBeanServer.queryNames(queryHosts, null);
            writer.print("<h1>");
            writer.print("Application list");
            writer.print("</h1>");
            writer.print("<p>");
            int count = 0;
            Iterator<ObjectName> iterator = hostsON.iterator();
            while (iterator.hasNext()) {
                int slash;
                contextON = iterator.next();
                String webModuleName = contextON.getKeyProperty("name");
                if (webModuleName.startsWith("//")) {
                    webModuleName = webModuleName.substring(2);
                }
                if ((slash = webModuleName.indexOf("/")) == -1) {
                    ++count;
                    continue;
                }
                writer.print("<a href=\"#" + count++ + ".0\">");
                writer.print(webModuleName);
                writer.print("</a>");
                if (!iterator.hasNext()) continue;
                writer.print("<br>");
            }
            writer.print("</p>");
            count = 0;
            iterator = hostsON.iterator();
            while (iterator.hasNext()) {
                contextON = iterator.next();
                writer.print("<a class=\"A.name\" name=\"" + count++ + ".0\">");
                StatusTransformer.writeContext(writer, contextON, mBeanServer, mode);
            }
        } else if (mode == 1) {
            // empty if block
        }
    }

    protected static void writeContext(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            int slash;
            String webModuleName = objectName.getKeyProperty("name");
            String name = webModuleName;
            if (name == null) {
                return;
            }
            String hostName = null;
            String contextName = null;
            if (name.startsWith("//")) {
                name = name.substring(2);
            }
            if ((slash = name.indexOf("/")) == -1) {
                return;
            }
            hostName = name.substring(0, slash);
            contextName = name.substring(slash);
            ObjectName queryManager = new ObjectName(objectName.getDomain() + ":type=Manager,path=" + contextName + ",host=" + hostName + ",*");
            Set<ObjectName> managersON = mBeanServer.queryNames(queryManager, null);
            ObjectName managerON = null;
            Iterator<ObjectName> iterator2 = managersON.iterator();
            while (iterator2.hasNext()) {
                managerON = iterator2.next();
            }
            ObjectName queryJspMonitor = new ObjectName(objectName.getDomain() + ":type=JspMonitor,WebModule=" + webModuleName + ",*");
            Set<ObjectName> jspMonitorsON = mBeanServer.queryNames(queryJspMonitor, null);
            ObjectName jspMonitorON = null;
            iterator2 = jspMonitorsON.iterator();
            while (iterator2.hasNext()) {
                jspMonitorON = iterator2.next();
            }
            if (contextName.equals("/")) {
                contextName = "";
            }
            writer.print("<h1>");
            writer.print(name);
            writer.print("</h1>");
            writer.print("</a>");
            writer.print("<p>");
            writer.print(" Startup time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "startupTime"), false));
            writer.print(" TLD scan time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "tldScanTime"), false));
            if (managerON != null) {
                StatusTransformer.writeManager(writer, managerON, mBeanServer, mode);
            }
            if (jspMonitorON != null) {
                StatusTransformer.writeJspMonitor(writer, jspMonitorON, mBeanServer, mode);
            }
            writer.print("</p>");
            String onStr = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + webModuleName + ",*";
            ObjectName servletObjectName = new ObjectName(onStr);
            Set<ObjectInstance> set = mBeanServer.queryMBeans(servletObjectName, null);
            Iterator<ObjectInstance> iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectInstance oi = iterator.next();
                StatusTransformer.writeWrapper(writer, oi.getObjectName(), mBeanServer, mode);
            }
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeManager(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            writer.print("<br>");
            writer.print(" Active sessions: ");
            writer.print(mBeanServer.getAttribute(objectName, "activeSessions"));
            writer.print(" Session count: ");
            writer.print(mBeanServer.getAttribute(objectName, "sessionCounter"));
            writer.print(" Max active sessions: ");
            writer.print(mBeanServer.getAttribute(objectName, "maxActive"));
            writer.print(" Rejected session creations: ");
            writer.print(mBeanServer.getAttribute(objectName, "rejectedSessions"));
            writer.print(" Expired sessions: ");
            writer.print(mBeanServer.getAttribute(objectName, "expiredSessions"));
            writer.print(" Processing time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), false));
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeJspMonitor(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            writer.print("<br>");
            writer.print(" JSPs loaded: ");
            writer.print(mBeanServer.getAttribute(objectName, "jspCount"));
            writer.print(" JSPs reloaded: ");
            writer.print(mBeanServer.getAttribute(objectName, "jspReloadCount"));
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static void writeWrapper(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            String servletName = objectName.getKeyProperty("name");
            String[] mappings = (String[])mBeanServer.invoke(objectName, "findMappings", null, null);
            writer.print("<h2>");
            writer.print(servletName);
            if (mappings != null && mappings.length > 0) {
                writer.print(" [ ");
                for (int i = 0; i < mappings.length; ++i) {
                    writer.print(mappings[i]);
                    if (i >= mappings.length - 1) continue;
                    writer.print(" , ");
                }
                writer.print(" ] ");
            }
            writer.print("</h2>");
            writer.print("<p>");
            writer.print(" Processing time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), true));
            writer.print(" Max time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "maxTime"), false));
            writer.print(" Request count: ");
            writer.print(mBeanServer.getAttribute(objectName, "requestCount"));
            writer.print(" Error count: ");
            writer.print(mBeanServer.getAttribute(objectName, "errorCount"));
            writer.print(" Load time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "loadTime"), false));
            writer.print(" Classloading time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "classLoadTime"), false));
            writer.print("</p>");
        } else if (mode == 1) {
            // empty if block
        }
    }

    public static String filter(Object obj) {
        if (obj == null) {
            return "?";
        }
        String message = obj.toString();
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuffer result = new StringBuffer(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String formatSize(Object obj, boolean mb) {
        long bytes = -1L;
        if (obj instanceof Long) {
            bytes = (Long)obj;
        } else if (obj instanceof Integer) {
            bytes = ((Integer)obj).intValue();
        }
        if (mb) {
            long mbytes = bytes / 0x100000L;
            long rest = (bytes - mbytes * 0x100000L) * 100L / 0x100000L;
            return mbytes + "." + (rest < 10L ? "0" : "") + rest + " MB";
        }
        return bytes / 1024L + " KB";
    }

    public static String formatTime(Object obj, boolean seconds) {
        long time = -1L;
        if (obj instanceof Long) {
            time = (Long)obj;
        } else if (obj instanceof Integer) {
            time = ((Integer)obj).intValue();
        }
        if (seconds) {
            return time / 1000L + " s";
        }
        return time + " ms";
    }
}

