/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSetLCFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterLCFixed";
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;

    CharacterSetLCFixed(int n, CharacterConverters characterConverters) {
        super(n, characterConverters);
        this.m_leadingCodes = characterConverters.getLeadingCodes();
    }

    static CharacterSetLCFixed getInstance(int n, CharacterConverters characterConverters) {
        if (characterConverters.getGroupId() == 3) {
            return new CharacterSetLCFixed(n, characterConverters);
        }
        return null;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        if (characterWalker.bytes.length - characterWalker.next < 4) {
            throw new SQLException("destination too small");
        }
        int n = characterWalker.bytes[characterWalker.next] << 8 | characterWalker.bytes[characterWalker.next + 1];
        for (int i = 0; i < this.m_leadingCodes.length; ++i) {
            if (n != this.m_leadingCodes[i]) continue;
            int n2 = 0;
            for (int j = 0; j < 4; ++j) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next++];
            }
            return n2;
        }
        throw new SQLException("Leading code invalid");
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2 = n >> 16;
        for (int i = 0; i < this.m_leadingCodes.length; ++i) {
            if (n2 != this.m_leadingCodes[i]) continue;
            CharacterSetLCFixed.need(characterBuffer, 4);
            for (int j = 3; j >= 0; --j) {
                characterBuffer.bytes[characterBuffer.next++] = (byte)(n >> 8 * j & 0xFF);
            }
            return;
        }
        throw new SQLException("Leading code invalid");
    }
}

