/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.io.File;
import java.security.AccessController;
import sun.plugin.services.PlatformService;
import sun.plugin.util.DeploymentConfig;
import sun.security.action.GetPropertyAction;

final class PluginConfig
extends DeploymentConfig {
    private static final String CACHE_VERSION = "v1.0";

    PluginConfig() {
        new File(this.getPluginCacheDirectory()).mkdirs();
    }

    protected String getUserProfilePath() {
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
        if ((string == null || string.trim().equals("")) && (string = PlatformService.getService().getUserProfilePath()) == null) {
            string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
        }
        return string;
    }

    protected String getSystemProfilePath() {
        String string = PlatformService.getService().getSystemProfilePath();
        if (string == null) {
            string = this.getUserProfilePath();
        }
        return string;
    }

    protected String getInfrastructurePath() {
        return PlatformService.getService().getInfrastructurePath();
    }

    private String getCacheDirectorySubStructure() {
        return "javapi" + File.separator + CACHE_VERSION;
    }

    public String getPluginCacheDirectory() {
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.cache.directory"));
        if (string == null || string.trim().equals("")) {
            string = super.getCacheDirectory() + File.separator + this.getCacheDirectorySubStructure();
        }
        return string;
    }

    public String getLogDirectory() {
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.outputfiles.path"));
        if (string == null || string.trim().equals("")) {
            string = super.getLogDirectory();
        }
        return string;
    }
}

