/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import sun.net.www.MessageHeader;
import sun.net.www.protocol.https.DelegateHttpsURLConnection;
import sun.net.www.protocol.https.Handler;
import sun.net.www.protocol.https.HttpsClient;
import sun.plugin.cache.CachedFile;
import sun.plugin.cache.FileCache;
import sun.plugin.net.cookie.PluginCookieManager;
import sun.plugin.net.proxy.PluginProxyManager;
import sun.plugin.net.proxy.ProxyInfo;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.ProgressInputStream;
import sun.plugin.util.ThreadGroupLocal;
import sun.plugin.util.Trace;

final class PluginDelegateHttpsURLConnection
extends DelegateHttpsURLConnection {
    private String proxy = null;
    private int proxyPort = -1;
    private MessageHeader cachedHeaders = null;
    private boolean progressTracking = false;
    private int callCount = 0;
    private static MessageFormat mf1 = new MessageFormat(ResourceHandler.getMessage("net.connect.no_proxy"));
    private static MessageFormat mf2 = new MessageFormat(ResourceHandler.getMessage("net.connect.proxy_is"));
    private static Method New;
    private boolean securityCheck = false;
    private boolean cacheConnect = false;
    private boolean realConnect = false;
    private boolean checkSetCookie = false;
    private InputStream cacheStream = null;
    static /* synthetic */ Class class$sun$net$www$protocol$https$HttpsClient;
    static /* synthetic */ Class class$javax$net$ssl$SSLSocketFactory;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$javax$net$ssl$HostnameVerifier;
    static /* synthetic */ Class class$java$lang$String;

    static {
        try {
            New = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Method[] methodArray = (class$sun$net$www$protocol$https$HttpsClient == null ? (class$sun$net$www$protocol$https$HttpsClient = PluginDelegateHttpsURLConnection.class$("sun.net.www.protocol.https.HttpsClient")) : class$sun$net$www$protocol$https$HttpsClient).getDeclaredMethods();
                    Class[] classArray = new Class[]{class$javax$net$ssl$SSLSocketFactory == null ? (class$javax$net$ssl$SSLSocketFactory = PluginDelegateHttpsURLConnection.class$("javax.net.ssl.SSLSocketFactory")) : class$javax$net$ssl$SSLSocketFactory, class$java$net$URL == null ? (class$java$net$URL = PluginDelegateHttpsURLConnection.class$("java.net.URL")) : class$java$net$URL, class$javax$net$ssl$HostnameVerifier == null ? (class$javax$net$ssl$HostnameVerifier = PluginDelegateHttpsURLConnection.class$("javax.net.ssl.HostnameVerifier")) : class$javax$net$ssl$HostnameVerifier, class$java$lang$String == null ? (class$java$lang$String = PluginDelegateHttpsURLConnection.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Boolean.TYPE};
                    for (int i = 0; i < methodArray.length; ++i) {
                        Class<?>[] classArray2 = methodArray[i].getParameterTypes();
                        if (classArray2.length != classArray.length) continue;
                        boolean bl = true;
                        for (int j = 0; j < classArray.length; ++j) {
                            if (classArray[j] == classArray2[j]) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        methodArray[i].setAccessible(true);
                        return methodArray[i];
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.netPrintException(privilegedActionException);
        }
    }

    private synchronized void checkCookieHeader() {
        if (this.checkSetCookie) {
            return;
        }
        this.checkSetCookie = true;
        Map<String, List<String>> map = this.getHeaderFields();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null || !string.equalsIgnoreCase("Set-Cookie")) continue;
            List<String> list = map.get(string);
            Iterator<String> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                if (string2 == null) continue;
                PluginCookieManager.setCookieInfo(this.url, string2);
            }
        }
    }

    private void checkPermission() throws IOException {
        if (this.securityCheck) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        this.securityCheck = true;
    }

    public synchronized void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.checkPermission();
        if (this.getRequestMethod().equalsIgnoreCase("GET") && ThreadGroupLocal.get("javaplugin.progressTracking") != null) {
            this.progressTracking = true;
        }
        this.connectWithCache();
        if (this.cacheStream == null) {
            this.connectSetup();
            this.superConnect();
        }
        this.setConnected(true);
    }

    private void connectSetup() throws IOException {
        Object object;
        if (this.realConnect) {
            return;
        }
        if (this.proxy == null && (object = PluginProxyManager.getProxyInfo(this.url)) != null) {
            this.proxy = object.getProxy();
            this.proxyPort = object.getPort();
        }
        if (this.proxy == null) {
            object = new Object[]{this.url};
            Trace.netPrintln(mf1.format(object), 2);
        } else {
            object = new Object[]{this.url, this.proxy + (this.proxyPort != -1 ? ":" + this.proxyPort : "")};
            Trace.netPrintln(mf2.format(object), 2);
        }
        if (this.getRequestProperty("cookie") == null && (object = PluginCookieManager.getCookieInfo(this.url)) != null) {
            this.addRequestProperty("cookie", (String)object);
        }
        this.realConnect = true;
    }

    private void connectWithCache() throws IOException {
        block7: {
            if (this.cacheConnect) {
                return;
            }
            if (this.getUseCaches() && this.getRequestMethod().equalsIgnoreCase("GET")) {
                try {
                    final CachedFile cachedFile = FileCache.get(this.url);
                    if (cachedFile == null) break block7;
                    InputStream inputStream = null;
                    try {
                        inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return new BufferedInputStream(new FileInputStream(cachedFile));
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        // empty catch block
                    }
                    if (inputStream != null) {
                        this.responseCode = 200;
                        this.cachedHeaders = cachedFile.getHeaderFields();
                        this.cacheStream = this.progressTracking ? new ProgressInputStream(inputStream, this) : inputStream;
                    }
                }
                catch (IOException iOException) {
                    Trace.netPrintException(iOException);
                }
            }
        }
        this.cacheConnect = true;
    }

    public synchronized void disconnect() {
        super.disconnect();
        if (this.cacheStream != null) {
            this.cacheStream = null;
        }
        if (this.cachedHeaders != null) {
            this.cachedHeaders.reset();
        }
    }

    private void superConnect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        if (this.proxy == null) {
            this.setNewClient(this.url, true);
        } else {
            this.setProxiedClient(this.url, this.proxy, this.proxyPort, true);
        }
    }

    public boolean usingProxy() {
        ProxyInfo proxyInfo = PluginProxyManager.getProxyInfo(this.url);
        return proxyInfo != null && proxyInfo.getProxy() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        try {
            ++this.callCount;
            if (this.cacheStream != null) {
                InputStream inputStream = this.cacheStream;
                return inputStream;
            }
            InputStream inputStream = super.getInputStream();
            if (this.callCount == 1) {
                if (inputStream != null) {
                    this.cacheStream = this.progressTracking && !(inputStream instanceof ProgressInputStream) ? new ProgressInputStream(inputStream, this) : inputStream;
                }
                this.checkCookieHeader();
                InputStream inputStream2 = this.cacheStream;
                return inputStream2;
            }
            InputStream inputStream3 = inputStream;
            return inputStream3;
        }
        finally {
            --this.callCount;
        }
    }

    public String getHeaderField(String string) {
        String string2 = null;
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string2 = this.cachedHeaders != null ? this.cachedHeaders.findValue(string) : super.getHeaderField(string);
        return string2;
    }

    protected void proxiedConnect(URL uRL, String string, int n, boolean bl) throws IOException {
        if (this.isConnected()) {
            return;
        }
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
        HostnameVerifier hostnameVerifier = this.getHostnameVerifier();
        Object[] objectArray = new Object[]{sSLSocketFactory, uRL, hostnameVerifier, string, new Integer(n), new Boolean(bl)};
        try {
            this.http = (HttpsClient)New.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessError illegalAccessError = new IllegalAccessError();
            illegalAccessError.initCause(illegalAccessException);
            throw illegalAccessError;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (IOException)invocationTargetException.getTargetException();
        }
        this.setConnected(true);
    }

    public PluginDelegateHttpsURLConnection(URL uRL, Handler handler, HttpsURLConnection httpsURLConnection) throws IOException {
        super(uRL, handler, httpsURLConnection);
    }
}

