/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.BlueprintStyle;
import com.sun.java.swing.plaf.gtk.CircularIdentityList;
import com.sun.java.swing.plaf.gtk.GTKEngineParser;
import com.sun.java.swing.plaf.gtk.GTKParser;
import com.sun.java.swing.plaf.gtk.GTKScanner;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.XColors;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;

class BlueprintEngineParser
extends GTKEngineParser {
    private static final int SYM_IMAGE = 269;
    private static final int SYM_FUNCTION = 270;
    private static final int SYM_FILE = 271;
    private static final int SYM_STRETCH = 272;
    private static final int SYM_RECOLORABLE = 273;
    private static final int SYM_BORDER = 274;
    private static final int SYM_DETAIL = 275;
    private static final int SYM_STATE = 276;
    private static final int SYM_SHADOW = 277;
    private static final int SYM_GAP_SIDE = 278;
    private static final int SYM_GAP_FILE = 279;
    private static final int SYM_GAP_BORDER = 280;
    private static final int SYM_GAP_START_FILE = 281;
    private static final int SYM_GAP_START_BORDER = 282;
    private static final int SYM_GAP_END_FILE = 283;
    private static final int SYM_GAP_END_BORDER = 284;
    private static final int SYM_OVERLAY_FILE = 285;
    private static final int SYM_OVERLAY_BORDER = 286;
    private static final int SYM_OVERLAY_STRETCH = 287;
    private static final int SYM_ARROW_DIRECTION = 288;
    private static final int SYM_ORIENTATION = 289;
    private static final int SYM_PARENT_TYPE = 290;
    private static final int SYM_COLORIZE_COLOR = 291;
    private static final int SYM_ICON_COLORIZE = 292;
    private static final int SYM_ICON_COLORIZE_ANCESTOR_TYPE = 293;
    private static final int SYM_USE_AS_BKG_MASK = 294;
    private static final int SYM_OVERLAY_RECOLORABLE = 295;
    private static final int SYM_OVERLAY_COLORIZE_COLOR = 296;
    private static final int SYM_D_HLINE = 297;
    private static final int SYM_D_VLINE = 298;
    private static final int SYM_D_SHADOW = 299;
    private static final int SYM_D_POLYGON = 300;
    private static final int SYM_D_ARROW = 301;
    private static final int SYM_D_DIAMOND = 302;
    private static final int SYM_D_OVAL = 303;
    private static final int SYM_D_STRING = 304;
    private static final int SYM_D_BOX = 305;
    private static final int SYM_D_FLAT_BOX = 306;
    private static final int SYM_D_CHECK = 307;
    private static final int SYM_D_OPTION = 308;
    private static final int SYM_D_CROSS = 309;
    private static final int SYM_D_RAMP = 310;
    private static final int SYM_D_TAB = 311;
    private static final int SYM_D_SHADOW_GAP = 312;
    private static final int SYM_D_BOX_GAP = 313;
    private static final int SYM_D_EXTENSION = 314;
    private static final int SYM_D_FOCUS = 315;
    private static final int SYM_D_SLIDER = 316;
    private static final int SYM_D_ENTRY = 317;
    private static final int SYM_D_HANDLE = 318;
    private static final int SYM_D_LAYOUT = 319;
    private static final int SYM_D_BACKGROUND = 320;
    private static final int SYM_D_STEPPER = 321;
    private static final int SYM_TRUE = 322;
    private static final int SYM_FALSE = 323;
    private static final int SYM_TOP = 324;
    private static final int SYM_UP = 325;
    private static final int SYM_BOTTOM = 326;
    private static final int SYM_DOWN = 327;
    private static final int SYM_LEFT = 328;
    private static final int SYM_RIGHT = 329;
    private static final int SYM_NORMAL = 330;
    private static final int SYM_ACTIVE = 331;
    private static final int SYM_PRELIGHT = 332;
    private static final int SYM_SELECTED = 333;
    private static final int SYM_INSENSITIVE = 334;
    private static final int SYM_NONE = 335;
    private static final int SYM_IN = 336;
    private static final int SYM_OUT = 337;
    private static final int SYM_ETCHED_IN = 338;
    private static final int SYM_ETCHED_OUT = 339;
    private static final int SYM_HORIZONTAL = 340;
    private static final int SYM_VERTICAL = 341;
    private static final int[] symbolVals = new int[]{269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341};
    private static final String[] symbolNames = new String[]{"image", "function", "file", "stretch", "recolorable", "border", "detail", "state", "shadow", "gap_side", "gap_file", "gap_border", "gap_start_file", "gap_start_border", "gap_end_file", "gap_end_border", "overlay_file", "overlay_border", "overlay_stretch", "arrow_direction", "orientation", "parent_type", "colorize_color", "icon_colorize", "icon_colorize_ancestor_type", "use_as_bkg_mask", "overlay_recolorable", "overlay_colorize_color", "HLINE", "VLINE", "SHADOW", "POLYGON", "ARROW", "DIAMOND", "OVAL", "STRING", "BOX", "FLAT_BOX", "CHECK", "OPTION", "CROSS", "RAMP", "TAB", "SHADOW_GAP", "BOX_GAP", "EXTENSION", "FOCUS", "SLIDER", "ENTRY", "HANDLE", "LAYOUT", "BACKGROUND", "STEPPER", "TRUE", "FALSE", "TOP", "UP", "BOTTOM", "DOWN", "LEFT", "RIGHT", "NORMAL", "ACTIVE", "PRELIGHT", "SELECTED", "INSENSITIVE", "NONE", "IN", "OUT", "ETCHED_IN", "ETCHED_OUT", "HORIZONTAL", "VERTICAL"};
    private GTKScanner scanner;
    private GTKParser parser;
    private BlueprintEngineInfo engineInfo;

    BlueprintEngineParser() {
    }

    private void registerSymbolsIfNecessary() {
        if (this.scanner.containsSymbol(symbolNames[0])) {
            return;
        }
        for (int i2 = 0; i2 < symbolNames.length; ++i2) {
            this.scanner.addSymbol(symbolNames[i2], symbolVals[i2]);
        }
    }

    private static int intColorVal(double d2) {
        float f2 = (float)Math.max(Math.min(d2, 1.0), 0.0);
        return (int)(f2 * 255.0f);
    }

    private static int intColorVal(long l2) {
        int n2 = (int)Math.max(Math.min(l2, 255L), 0L);
        return n2;
    }

    private int parseRecolorable(boolean[] blArray) throws IOException {
        this.scanner.getToken();
        int n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 == 322) {
            blArray[0] = true;
        } else if (n2 == 323) {
            blArray[0] = false;
        } else {
            return 322;
        }
        return 256;
    }

    private int parseStretch(boolean[] blArray) throws IOException {
        int n2 = this.scanner.getToken();
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 322: {
                blArray[0] = true;
                break;
            }
            case 323: {
                blArray[0] = false;
                break;
            }
            default: {
                return 322;
            }
        }
        return 256;
    }

    private int parseIconColorize(BlueprintEngineInfo blueprintEngineInfo) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 292) {
            return 292;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 == 322) {
            blueprintEngineInfo.iconColorize = true;
        } else if (n2 == 323) {
            blueprintEngineInfo.iconColorize = false;
        } else {
            return 322;
        }
        return 256;
    }

    private int parseArrowDirection(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 288) {
            return 288;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 325: {
                info.arrowDirection = 100;
                break;
            }
            case 327: {
                info.arrowDirection = 101;
                break;
            }
            case 328: {
                info.arrowDirection = 102;
                break;
            }
            case 329: {
                info.arrowDirection = 103;
                break;
            }
            default: {
                return 325;
            }
        }
        return 256;
    }

    private int parseDetail(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 275) {
            return 275;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        info.setDetail(this.scanner.currValue.stringVal);
        return 256;
    }

    private int parseFunction(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 270) {
            return 270;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 >= 297 && n2 <= 321) {
            info.setFunction(symbolNames[n2 - 269]);
        }
        return 256;
    }

    private int parseGapSide(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 278) {
            return 278;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 324: {
                info.gapSide = 2;
                break;
            }
            case 326: {
                info.gapSide = 3;
                break;
            }
            case 328: {
                info.gapSide = 0;
                break;
            }
            case 329: {
                info.gapSide = 1;
                break;
            }
            default: {
                return 324;
            }
        }
        return 256;
    }

    private int parseOrientation(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 289) {
            return 289;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 340: {
                info.orientation = 0;
                break;
            }
            case 341: {
                info.orientation = 1;
                break;
            }
            default: {
                return 340;
            }
        }
        return 256;
    }

    private int parseShadow(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 277) {
            return 277;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 335: {
                info.shadow = 4;
                break;
            }
            case 336: {
                info.shadow = 0;
                break;
            }
            case 337: {
                info.shadow = 1;
                break;
            }
            case 338: {
                info.shadow = 2;
                break;
            }
            case 339: {
                info.shadow = 3;
                break;
            }
            default: {
                return 335;
            }
        }
        return 256;
    }

    private int parseState(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 276) {
            return 276;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 330: {
                info.componentState = 1;
                break;
            }
            case 331: {
                info.componentState = 4;
                break;
            }
            case 332: {
                info.componentState = 2;
                break;
            }
            case 333: {
                info.componentState = 512;
                break;
            }
            case 334: {
                info.componentState = 8;
                break;
            }
            default: {
                return 330;
            }
        }
        return 256;
    }

    private int parseUseAsBkgMask(BlueprintStyle.Info info) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 294) {
            return 294;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 322: {
                info.useAsBkgMask = true;
                break;
            }
            case 323: {
                info.useAsBkgMask = false;
                break;
            }
            default: {
                return 322;
            }
        }
        return 256;
    }

    private int parseImage(BlueprintStyle.Info[] infoArray) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 269) {
            return 269;
        }
        n2 = this.scanner.getToken();
        if (n2 != 123) {
            return 123;
        }
        BlueprintStyle.Info info = new BlueprintStyle.Info();
        String[] stringArray = new String[1];
        boolean[] blArray = new boolean[1];
        Insets[] insetsArray = new Insets[1];
        Color[] colorArray = new Color[1];
        n2 = this.scanner.peekNextToken();
        while (n2 != 125) {
            switch (n2) {
                case 270: {
                    n2 = this.parseFunction(info);
                    break;
                }
                case 273: {
                    n2 = this.parseRecolorable(blArray);
                    if (n2 != 256) break;
                    info.recolorable = blArray[0];
                    break;
                }
                case 295: {
                    n2 = this.parseRecolorable(blArray);
                    if (n2 != 256) break;
                    info.overlayRecolorable = blArray[0];
                    break;
                }
                case 275: {
                    n2 = this.parseDetail(info);
                    break;
                }
                case 276: {
                    n2 = this.parseState(info);
                    break;
                }
                case 277: {
                    n2 = this.parseShadow(info);
                    break;
                }
                case 278: {
                    n2 = this.parseGapSide(info);
                    break;
                }
                case 288: {
                    n2 = this.parseArrowDirection(info);
                    break;
                }
                case 289: {
                    n2 = this.parseOrientation(info);
                    break;
                }
                case 271: {
                    n2 = this.parseFile(stringArray);
                    if (n2 != 256) break;
                    info.image = stringArray[0];
                    break;
                }
                case 274: {
                    n2 = this.parseBorder(insetsArray);
                    if (n2 != 256) break;
                    info.fileInsets = insetsArray[0];
                    break;
                }
                case 272: {
                    n2 = this.parseStretch(blArray);
                    if (n2 != 256) break;
                    info.stretch = blArray[0];
                    break;
                }
                case 279: {
                    n2 = this.parseFile(stringArray);
                    if (n2 != 256) break;
                    info.gapImage = stringArray[0];
                    break;
                }
                case 280: {
                    n2 = this.parseBorder(insetsArray);
                    if (n2 != 256) break;
                    info.gapInsets = insetsArray[0];
                    break;
                }
                case 281: {
                    n2 = this.parseFile(stringArray);
                    if (n2 != 256) break;
                    info.gapStartImage = stringArray[0];
                    break;
                }
                case 282: {
                    n2 = this.parseBorder(insetsArray);
                    if (n2 != 256) break;
                    info.gapStartInsets = insetsArray[0];
                    break;
                }
                case 283: {
                    n2 = this.parseFile(stringArray);
                    if (n2 != 256) break;
                    info.gapEndImage = stringArray[0];
                    break;
                }
                case 284: {
                    n2 = this.parseBorder(insetsArray);
                    if (n2 != 256) break;
                    info.gapEndInsets = insetsArray[0];
                    break;
                }
                case 285: {
                    n2 = this.parseFile(stringArray);
                    if (n2 != 256) break;
                    info.overlayImage = stringArray[0];
                    break;
                }
                case 286: {
                    n2 = this.parseBorder(insetsArray);
                    if (n2 != 256) break;
                    info.overlayInsets = insetsArray[0];
                    break;
                }
                case 287: {
                    n2 = this.parseStretch(blArray);
                    if (n2 != 256) break;
                    info.overlayStretch = blArray[0];
                    break;
                }
                case 290: {
                    this.scanner.getToken();
                    if (info.parentTypeList == null) {
                        info.parentTypeList = new ArrayList();
                    }
                    n2 = this.parseStringList(info.parentTypeList);
                    break;
                }
                case 291: {
                    n2 = this.parseColorizeColor(colorArray);
                    if (n2 != 256) break;
                    info.colorizeColor = colorArray[0];
                    break;
                }
                case 296: {
                    n2 = this.parseColorizeColor(colorArray);
                    if (n2 != 256) break;
                    info.overlayColorizeColor = colorArray[0];
                    break;
                }
                case 294: {
                    n2 = this.parseUseAsBkgMask(info);
                    break;
                }
                default: {
                    this.scanner.getToken();
                    n2 = 125;
                }
            }
            if (n2 != 256) {
                return n2;
            }
            n2 = this.scanner.peekNextToken();
        }
        n2 = this.scanner.getToken();
        if (n2 != 125) {
            return 125;
        }
        infoArray[0] = info;
        return 256;
    }

    private int parseColorizeColor(Color[] colorArray) throws IOException {
        this.scanner.getToken();
        int n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        switch (n2) {
            case 123: {
                int n3;
                int n4;
                int n5;
                int n6 = 255;
                n2 = this.scanner.getToken();
                if (n2 == 261) {
                    n5 = BlueprintEngineParser.intColorVal(this.scanner.currValue.longVal);
                } else if (n2 == 263) {
                    n5 = BlueprintEngineParser.intColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n2 = this.scanner.getToken();
                if (n2 != 44) {
                    return 44;
                }
                n2 = this.scanner.getToken();
                if (n2 == 261) {
                    n4 = BlueprintEngineParser.intColorVal(this.scanner.currValue.longVal);
                } else if (n2 == 263) {
                    n4 = BlueprintEngineParser.intColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n2 = this.scanner.getToken();
                if (n2 != 44) {
                    return 44;
                }
                n2 = this.scanner.getToken();
                if (n2 == 261) {
                    n3 = BlueprintEngineParser.intColorVal(this.scanner.currValue.longVal);
                } else if (n2 == 263) {
                    n3 = BlueprintEngineParser.intColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n2 = this.scanner.getToken();
                if (n2 == 44) {
                    n2 = this.scanner.getToken();
                    if (n2 == 261) {
                        n6 = BlueprintEngineParser.intColorVal(this.scanner.currValue.longVal);
                    } else if (n2 == 263) {
                        n6 = BlueprintEngineParser.intColorVal(this.scanner.currValue.doubleVal);
                    } else {
                        return 263;
                    }
                    n2 = this.scanner.getToken();
                }
                if (n2 != 125) {
                    return 125;
                }
                colorArray[0] = new Color(n5, n4, n3, n6);
                break;
            }
            case 264: {
                Color color = BlueprintEngineParser.parseColorString(this.scanner.currValue.stringVal);
                if (color == null) {
                    this.scanner.printMessage("Invalid color constant '" + this.scanner.currValue.stringVal + "'", false);
                    return 264;
                }
                colorArray[0] = color;
                break;
            }
            default: {
                return 264;
            }
        }
        return 256;
    }

    private int parseBorder(Insets[] insetsArray) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.scanner.getToken();
        if (this.scanner.getToken() != 61) {
            return 61;
        }
        if (this.scanner.getToken() != 123) {
            return 123;
        }
        if (this.scanner.getToken() != 261) {
            return 261;
        }
        n2 = (int)this.scanner.currValue.longVal;
        if (this.scanner.getToken() != 44) {
            return 44;
        }
        if (this.scanner.getToken() != 261) {
            return 261;
        }
        n3 = (int)this.scanner.currValue.longVal;
        if (this.scanner.getToken() != 44) {
            return 44;
        }
        if (this.scanner.getToken() != 261) {
            return 261;
        }
        n4 = (int)this.scanner.currValue.longVal;
        if (this.scanner.getToken() != 44) {
            return 44;
        }
        if (this.scanner.getToken() != 261) {
            return 261;
        }
        n5 = (int)this.scanner.currValue.longVal;
        if (this.scanner.getToken() != 125) {
            return 125;
        }
        insetsArray[0] = new Insets(n4, n2, n5, n3);
        return 256;
    }

    private int parseFile(String[] stringArray) throws IOException {
        int n2 = this.scanner.getToken();
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        stringArray[0] = this.parser.resolvePixmapPath(this.scanner.currValue.stringVal);
        return 256;
    }

    private int parseStringList(ArrayList arrayList) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 != 123) {
            return 123;
        }
        n2 = this.scanner.getToken();
        while (n2 == 264) {
            arrayList.add(this.scanner.currValue.stringVal.intern());
            n2 = this.scanner.getToken();
            if (n2 == 125) continue;
            if (n2 != 44) {
                return 44;
            }
            n2 = this.scanner.getToken();
        }
        if (n2 != 125) {
            return 125;
        }
        return 256;
    }

    private static Color parseColorString(String string) {
        if (string.charAt(0) == '#') {
            int n2;
            int n3;
            int n4;
            int n5 = (string = string.substring(1)).length();
            if (n5 < 3 || n5 > 12 || n5 % 3 != 0) {
                return null;
            }
            n5 /= 3;
            try {
                n4 = Integer.parseInt(string.substring(0, n5), 16);
                n3 = Integer.parseInt(string.substring(n5, n5 * 2), 16);
                n2 = Integer.parseInt(string.substring(n5 * 2, n5 * 3), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n5 == 4) {
                return new Color((float)n4 / 65535.0f, (float)n3 / 65535.0f, (float)n2 / 65535.0f);
            }
            if (n5 == 1) {
                return new Color((float)n4 / 15.0f, (float)n3 / 15.0f, (float)n2 / 15.0f);
            }
            if (n5 == 2) {
                return new Color(n4, n3, n2);
            }
            return new Color((float)n4 / 4095.0f, (float)n3 / 4095.0f, (float)n2 / 4095.0f);
        }
        return XColors.lookupColor(string);
    }

    int parse(GTKScanner gTKScanner, GTKParser gTKParser, GTKParser.EngineInfo[] engineInfoArray) throws IOException {
        this.scanner = gTKScanner;
        this.parser = gTKParser;
        this.engineInfo = engineInfoArray[0] == null ? new BlueprintEngineInfo() : (BlueprintEngineInfo)engineInfoArray[0];
        int n2 = gTKScanner.setScope(this.uniqueScopeID);
        this.registerSymbolsIfNecessary();
        BlueprintStyle.Info[] infoArray = new BlueprintStyle.Info[1];
        int n3 = gTKScanner.peekNextToken();
        while (n3 != 125) {
            infoArray[0] = null;
            switch (n3) {
                case 269: {
                    n3 = this.parseImage(infoArray);
                    break;
                }
                case 291: {
                    Color[] colorArray = new Color[1];
                    n3 = this.parseColorizeColor(colorArray);
                    if (n3 != 256) break;
                    this.engineInfo.colorizeColor = colorArray[0];
                    break;
                }
                case 292: {
                    n3 = this.parseIconColorize(this.engineInfo);
                    break;
                }
                case 293: {
                    gTKScanner.getToken();
                    if (this.engineInfo.iconAncestorTypes == null) {
                        this.engineInfo.iconAncestorTypes = new ArrayList();
                    }
                    n3 = this.parseStringList(this.engineInfo.iconAncestorTypes);
                    break;
                }
                default: {
                    gTKScanner.getToken();
                    n3 = 125;
                }
            }
            if (n3 != 256) {
                return n3;
            }
            if (infoArray[0] != null) {
                this.engineInfo.pInfos.add(infoArray[0]);
            }
            n3 = gTKScanner.peekNextToken();
        }
        gTKScanner.getToken();
        engineInfoArray[0] = this.engineInfo;
        gTKScanner.setScope(n2);
        return 256;
    }

    private static class BlueprintEngineInfo
    extends GTKParser.EngineInfo {
        ArrayList pInfos = new ArrayList();
        boolean iconColorize = false;
        ArrayList iconAncestorTypes = null;
        Color colorizeColor = null;

        private BlueprintEngineInfo() {
        }

        GTKStyle constructGTKStyle(GTKStyle.GTKStateInfo[] gTKStateInfoArray, CircularIdentityList circularIdentityList, Font font, int n2, int n3, GTKStyle.GTKStockIconInfo[] gTKStockIconInfoArray) {
            Object[] objectArray = null;
            if (this.pInfos.size() != 0) {
                objectArray = new BlueprintStyle.Info[this.pInfos.size()];
                objectArray = (BlueprintStyle.Info[])this.pInfos.toArray(objectArray);
            }
            Object[] objectArray2 = null;
            if (this.iconAncestorTypes != null && this.iconAncestorTypes.size() != 0) {
                objectArray2 = new String[this.iconAncestorTypes.size()];
                objectArray2 = (String[])this.iconAncestorTypes.toArray(objectArray2);
            }
            return new BlueprintStyle(gTKStateInfoArray, circularIdentityList, font, n2, n3, gTKStockIconInfoArray, (BlueprintStyle.Info[])objectArray, this.iconColorize, (String[])objectArray2, this.colorizeColor);
        }
    }
}

