/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SynthTableHeaderUI
extends TableHeaderUI
implements PropertyChangeListener,
SynthUI {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    protected JTableHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;
    private SynthStyle style;

    private int getHeaderHeight() {
        int n2 = 0;
        boolean bl2 = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            TableColumn tableColumn = tableColumnModel.getColumn(i2);
            if (tableColumn.getHeaderRenderer() == null && bl2) continue;
            Component component = this.getHeaderRenderer(i2);
            int n3 = component.getPreferredSize().height;
            n2 = Math.max(n2, n3);
            if (n3 <= 0) continue;
            bl2 = true;
        }
        return n2;
    }

    SynthTableHeaderUI() {
    }

    protected void installDefaults() {
        this.fetchStyle(this.header);
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
        this.header.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.header, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.header.removePropertyChangeListener(this);
        this.mouseInputListener = null;
    }

    private Component getHeaderRenderer(int n2) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
    }

    private Dimension createHeaderSize(long l2) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, this.getHeaderHeight());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JTableHeader)propertyChangeEvent.getSource());
        }
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private void fetchStyle(JTableHeader jTableHeader) {
        SynthContext synthContext = this.getContext(jTableHeader, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        this.header.setDefaultRenderer(new HeadererRenderer());
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getMaxWidth();
        }
        return this.createHeaderSize(l2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSize(l2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l2);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        int n2;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl2 = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n3 = this.header.columnAtPoint(bl2 ? point : point2);
        int n4 = this.header.columnAtPoint(bl2 ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        int n5 = tableColumnModel.getColumnMargin();
        Rectangle rectangle2 = this.header.getHeaderRect(n3);
        if (bl2) {
            for (n2 = n3; n2 <= n4; ++n2) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
                int n6 = tableColumn2.getWidth();
                rectangle2.width = n6 - n5;
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n2);
                }
                rectangle2.x += n6;
            }
        } else {
            int n7;
            TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
            if (tableColumn3 != tableColumn) {
                n7 = tableColumn3.getWidth();
                rectangle2.width = n7 - n5;
                rectangle2.x += n5;
                this.paintCell(graphics, rectangle2, n3);
            }
            for (n2 = n3 + 1; n2 <= n4; ++n2) {
                tableColumn3 = tableColumnModel.getColumn(n2);
                n7 = tableColumn3.getWidth();
                rectangle2.width = n7 - n5;
                rectangle2.x -= n7;
                if (tableColumn3 == tableColumn) continue;
                this.paintCell(graphics, rectangle2, n2);
            }
        }
        if (tableColumn != null) {
            n2 = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n2);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n2);
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n2) {
        Component component = this.getHeaderRenderer(n2);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTableHeaderUI();
    }

    private class HeadererRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        HeadererRenderer() {
            this.setName("TableHeader.renderer");
            this.setBorder(null);
            this.setHorizontalAlignment(10);
            this.updateUI();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private Cursor otherCursor = SynthTableHeaderUI.access$000();

        private void swapCursor() {
            Cursor cursor = SynthTableHeaderUI.this.header.getCursor();
            SynthTableHeaderUI.this.header.setCursor(this.otherCursor);
            this.otherCursor = cursor;
        }

        private void setDraggedDistance(int n2, int n3) {
            SynthTableHeaderUI.this.header.setDraggedDistance(n2);
            if (n3 != -1) {
                SynthTableHeaderUI.this.header.getColumnModel().moveColumn(n3, n3);
            }
        }

        MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getX();
            TableColumn tableColumn = SynthTableHeaderUI.this.header.getResizingColumn();
            TableColumn tableColumn2 = SynthTableHeaderUI.this.header.getDraggedColumn();
            boolean bl2 = SynthTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            if (tableColumn != null) {
                JTable jTable;
                Container container;
                int n3 = tableColumn.getWidth();
                int n4 = bl2 ? n2 - this.mouseXOffset : this.mouseXOffset - n2;
                tableColumn.setWidth(n4);
                if (SynthTableHeaderUI.this.header.getParent() == null || (container = SynthTableHeaderUI.this.header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                    return;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !bl2 && (jTable = SynthTableHeaderUI.this.header.getTable()) != null) {
                    JViewport jViewport = ((JScrollPane)container).getViewport();
                    int n5 = jViewport.getWidth();
                    int n6 = n4 - n3;
                    int n7 = jTable.getWidth() + n6;
                    Dimension dimension = jTable.getSize();
                    dimension.width += n6;
                    jTable.setSize(dimension);
                    if (n7 >= n5 && jTable.getAutoResizeMode() == 0) {
                        Point point = jViewport.getViewPosition();
                        point.x = Math.max(0, Math.min(n7 - n5, point.x + n6));
                        jViewport.setViewPosition(point);
                        this.mouseXOffset += n6;
                    }
                }
            } else if (tableColumn2 != null) {
                TableColumnModel tableColumnModel = SynthTableHeaderUI.this.header.getColumnModel();
                int n8 = n2 - this.mouseXOffset;
                int n9 = n8 < 0 ? -1 : 1;
                int n10 = SynthTableHeaderUI.this.viewIndexForColumn(tableColumn2);
                int n11 = n10 + (bl2 ? n9 : -n9);
                if (0 <= n11 && n11 < tableColumnModel.getColumnCount()) {
                    int n12 = tableColumnModel.getColumn(n11).getWidth();
                    if (Math.abs(n8) > n12 / 2) {
                        this.mouseXOffset += n9 * n12;
                        SynthTableHeaderUI.this.header.setDraggedDistance(n8 - n9 * n12);
                        tableColumnModel.moveColumn(n10, n11);
                        return;
                    }
                }
                this.setDraggedDistance(n8, n10);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.canResize(this.getResizingColumn(mouseEvent.getPoint())) != (SynthTableHeaderUI.this.header.getCursor() == resizeCursor)) {
                this.swapCursor();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            SynthTableHeaderUI.this.header.setDraggedColumn(null);
            SynthTableHeaderUI.this.header.setResizingColumn(null);
            SynthTableHeaderUI.this.header.setDraggedDistance(0);
            Point point = mouseEvent.getPoint();
            TableColumnModel tableColumnModel = SynthTableHeaderUI.this.header.getColumnModel();
            int n2 = SynthTableHeaderUI.this.header.columnAtPoint(point);
            if (n2 != -1) {
                TableColumn tableColumn = this.getResizingColumn(point, n2);
                if (this.canResize(tableColumn)) {
                    SynthTableHeaderUI.this.header.setResizingColumn(tableColumn);
                    this.mouseXOffset = SynthTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? point.x - tableColumn.getWidth() : point.x + tableColumn.getWidth();
                } else if (SynthTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
                    SynthTableHeaderUI.this.header.setDraggedColumn(tableColumn2);
                    this.mouseXOffset = point.x;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.setDraggedDistance(0, SynthTableHeaderUI.this.viewIndexForColumn(SynthTableHeaderUI.this.header.getDraggedColumn()));
            SynthTableHeaderUI.this.header.setResizingColumn(null);
            SynthTableHeaderUI.this.header.setDraggedColumn(null);
        }

        private boolean canResize(TableColumn tableColumn) {
            return tableColumn != null && SynthTableHeaderUI.this.header.getResizingAllowed() && tableColumn.getResizable();
        }

        private TableColumn getResizingColumn(Point point) {
            return this.getResizingColumn(point, SynthTableHeaderUI.this.header.columnAtPoint(point));
        }

        private TableColumn getResizingColumn(Point point, int n2) {
            int n3;
            if (n2 == -1) {
                return null;
            }
            Rectangle rectangle = SynthTableHeaderUI.this.header.getHeaderRect(n2);
            rectangle.grow(-3, 0);
            if (rectangle.contains(point)) {
                return null;
            }
            int n4 = rectangle.x + rectangle.width / 2;
            if (SynthTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                n3 = point.x < n4 ? n2 - 1 : n2;
            } else {
                int n5 = n3 = point.x < n4 ? n2 : n2 - 1;
            }
            if (n3 == -1) {
                return null;
            }
            return SynthTableHeaderUI.this.header.getColumnModel().getColumn(n3);
        }
    }
}

