/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class MotifFileChooserUI
extends BasicFileChooserUI {
    private FilterComboBoxModel filterComboBoxModel;
    protected JList directoryList = null;
    protected JList fileList = null;
    protected JTextField pathField = null;
    protected JComboBox filterComboBox = null;
    protected JTextField filenameTextField = null;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension prefListSize = new Dimension(75, 150);
    private static Dimension WITH_ACCELERATOR_PREF_SIZE = new Dimension(650, 450);
    private static Dimension PREF_SIZE = new Dimension(350, 450);
    private static Dimension MIN_SIZE = new Dimension(200, 300);
    private static Dimension PREF_ACC_SIZE = new Dimension(10, 10);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);
    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);
    private JPanel directoryPanel = new JPanel();
    protected JButton approveButton;
    private String enterFileNameLabelText = null;
    private int enterFileNameLabelMnemonic = 0;
    private String filesLabelText = null;
    private int filesLabelMnemonic = 0;
    private String foldersLabelText = null;
    private int foldersLabelMnemonic = 0;
    private String pathLabelText = null;
    private int pathLabelMnemonic = 0;
    private String filterLabelText = null;
    private int filterLabelMnemonic = 0;

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    public String getDirectoryName() {
        return this.pathField.getText();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setDirectoryName(String string) {
        this.pathField.setText(string);
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    protected void align(JComponent jComponent) {
        jComponent.setAlignmentX(0.0f);
        jComponent.setAlignmentY(0.0f);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.getFileChooser().removeAll();
        super.uninstallUI(jComponent);
    }

    public MotifFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setLayout(new BorderLayout(10, 10));
        jFileChooser.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel(){

            public Insets getInsets() {
                return insets;
            }
        };
        this.align(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jFileChooser.add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel(this.pathLabelText);
        jLabel.setDisplayedMnemonic(this.pathLabelMnemonic);
        this.align(jLabel);
        jPanel.add(jLabel);
        File file = jFileChooser.getCurrentDirectory();
        String string = null;
        if (file != null) {
            string = file.getPath();
        }
        this.pathField = new JTextField(string){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        jLabel.setLabelFor(this.pathField);
        this.align(this.pathField);
        this.pathField.addActionListener(this.getUpdateAction());
        jPanel.add(this.pathField);
        jPanel.add(Box.createRigidArea(vstrut10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        this.align(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        this.align(jPanel3);
        jLabel = new JLabel(this.filterLabelText);
        jLabel.setDisplayedMnemonic(this.filterLabelMnemonic);
        this.align(jLabel);
        jPanel3.add(jLabel);
        this.filterComboBox = new JComboBox(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        jLabel.setLabelFor(this.filterComboBox);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.align(this.filterComboBox);
        jPanel3.add(this.filterComboBox);
        jLabel = new JLabel(this.foldersLabelText);
        jLabel.setDisplayedMnemonic(this.foldersLabelMnemonic);
        this.align(jLabel);
        jPanel3.add(jLabel);
        JScrollPane jScrollPane = this.createDirectoryList();
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.getHorizontalScrollBar().setFocusable(false);
        jLabel.setLabelFor(jScrollPane.getViewport().getView());
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        this.align(jPanel4);
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        jLabel = new JLabel(this.filesLabelText);
        jLabel.setDisplayedMnemonic(this.filesLabelMnemonic);
        this.align(jLabel);
        jPanel4.add(jLabel);
        jScrollPane = this.createFilesList();
        jLabel.setLabelFor(jScrollPane);
        jPanel4.add(jScrollPane);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(hstrut10));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = this.getAccessoryPanel();
        JComponent jComponent = jFileChooser.getAccessory();
        if (jPanel5 != null) {
            if (jComponent == null) {
                jPanel5.setPreferredSize(ZERO_ACC_SIZE);
                jPanel5.setMaximumSize(ZERO_ACC_SIZE);
            } else {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
                jPanel5.setPreferredSize(PREF_ACC_SIZE);
                jPanel5.setMaximumSize(MAX_SIZE);
            }
            this.align(jPanel5);
            jPanel2.add(jPanel5);
        }
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(vstrut10));
        jLabel = new JLabel(this.enterFileNameLabelText);
        jLabel.setDisplayedMnemonic(this.enterFileNameLabelMnemonic);
        this.align(jLabel);
        jPanel.add(jLabel);
        this.filenameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        jLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        this.align(this.filenameTextField);
        this.filenameTextField.setAlignmentX(0.0f);
        jPanel.add(this.filenameTextField);
        JPanel jPanel6 = new JPanel(new BorderLayout(0, 4));
        jPanel6.add((Component)new JSeparator(), "North");
        JPanel jPanel7 = new JPanel();
        this.align(jPanel7);
        jPanel7.setLayout(new BoxLayout(jPanel7, 2));
        jPanel7.add(Box.createGlue());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser)){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.align(this.approveButton);
        this.approveButton.setMargin(buttonMargin);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        jPanel7.add(this.approveButton);
        jPanel7.add(Box.createGlue());
        JButton jButton = new JButton(this.updateButtonText){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        jButton.setMnemonic(this.updateButtonMnemonic);
        jButton.setToolTipText(this.updateButtonToolTipText);
        this.align(jButton);
        jButton.setMargin(buttonMargin);
        jButton.addActionListener(this.getUpdateAction());
        jPanel7.add(jButton);
        jPanel7.add(Box.createGlue());
        JButton jButton2 = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        jButton2.setMnemonic(this.cancelButtonMnemonic);
        jButton2.setToolTipText(this.cancelButtonToolTipText);
        this.align(jButton2);
        jButton2.setMargin(buttonMargin);
        jButton2.addActionListener(this.getCancelSelectionAction());
        jPanel7.add(jButton2);
        jPanel7.add(Box.createGlue());
        JButton jButton3 = new JButton(this.helpButtonText){

            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        jButton3.setMnemonic(this.helpButtonMnemonic);
        jButton3.setToolTipText(this.helpButtonToolTipText);
        this.align(jButton3);
        jButton3.setMargin(buttonMargin);
        jButton3.setEnabled(false);
        jPanel7.add(jButton3);
        jPanel7.add(Box.createGlue());
        jPanel6.add((Component)jPanel7, "South");
        jFileChooser.add((Component)jPanel6, "South");
    }

    protected void installIcons(JFileChooser jFileChooser) {
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.enterFileNameLabelText = UIManager.getString((Object)"FileChooser.enterFileNameLabelText", locale);
        this.enterFileNameLabelMnemonic = UIManager.getInt("FileChooser.enterFileNameLabelMnemonic");
        this.filesLabelText = UIManager.getString((Object)"FileChooser.filesLabelText", locale);
        this.filesLabelMnemonic = UIManager.getInt("FileChooser.filesLabelMnemonic");
        this.foldersLabelText = UIManager.getString((Object)"FileChooser.foldersLabelText", locale);
        this.foldersLabelMnemonic = UIManager.getInt("FileChooser.foldersLabelMnemonic");
        this.pathLabelText = UIManager.getString((Object)"FileChooser.pathLabelText", locale);
        this.pathLabelMnemonic = UIManager.getInt("FileChooser.pathLabelMnemonic");
        this.filterLabelText = UIManager.getString((Object)"FileChooser.filterLabelText", locale);
        this.filterLabelMnemonic = UIManager.getInt("FileChooser.filterLabelMnemonic");
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
    }

    protected JScrollPane createDirectoryList() {
        this.directoryList = new JList();
        this.align(this.directoryList);
        this.directoryList.setCellRenderer(new DirectoryCellRenderer());
        this.directoryList.setModel(new MotifDirectoryListModel());
        this.directoryList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.directoryList));
        this.directoryList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        JScrollPane jScrollPane = new JScrollPane(this.directoryList);
        jScrollPane.setMaximumSize(MAX_SIZE);
        jScrollPane.setPreferredSize(prefListSize);
        this.align(jScrollPane);
        return jScrollPane;
    }

    protected JScrollPane createFilesList() {
        this.fileList = new JList();
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
        }
        this.fileList.setModel(new MotifFileListModel());
        this.fileList.setCellRenderer(new FileCellRenderer());
        this.fileList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        this.fileList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.fileList));
        this.align(this.fileList);
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setPreferredSize(prefListSize);
        jScrollPane.setMaximumSize(MAX_SIZE);
        this.align(jScrollPane);
        return jScrollPane;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getFileChooser().getAccessory() != null ? WITH_ACCELERATOR_PREF_SIZE : PREF_SIZE;
        Dimension dimension2 = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension2 != null) {
            return new Dimension(dimension2.width < dimension.width ? dimension.width : dimension2.width, dimension2.height < dimension.height ? dimension.height : dimension2.height);
        }
        return dimension;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file != null) {
                        MotifFileChooserUI.this.setFileName(MotifFileChooserUI.this.getFileChooser().getName(file));
                    }
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    File[] fileArray = (File[])propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = MotifFileChooserUI.this.getFileChooser();
                    if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
                        MotifFileChooserUI.this.setFileName(MotifFileChooserUI.this.fileNameString(fileArray));
                    }
                } else if (string.equals("directoryChanged")) {
                    MotifFileChooserUI.this.directoryList.clearSelection();
                    MotifFileChooserUI.this.fileList.clearSelection();
                    File file = MotifFileChooserUI.this.getFileChooser().getCurrentDirectory();
                    if (file != null) {
                        try {
                            MotifFileChooserUI.this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getCanonicalPath());
                        }
                        catch (IOException iOException) {
                            MotifFileChooserUI.this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getAbsolutePath());
                        }
                    }
                } else if (string.equals("fileSelectionChanged")) {
                    MotifFileChooserUI.this.directoryList.clearSelection();
                } else if (string == "MultiSelectionEnabledChangedProperty") {
                    if (MotifFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                        MotifFileChooserUI.this.fileList.setSelectionMode(2);
                    } else {
                        MotifFileChooserUI.this.fileList.setSelectionMode(0);
                        MotifFileChooserUI.this.fileList.clearSelection();
                        MotifFileChooserUI.this.getFileChooser().setSelectedFiles(null);
                    }
                } else if (string == "AccessoryChangedProperty") {
                    if (MotifFileChooserUI.this.getAccessoryPanel() != null) {
                        JComponent jComponent;
                        if (propertyChangeEvent.getOldValue() != null) {
                            MotifFileChooserUI.this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                        }
                        if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                            MotifFileChooserUI.this.getAccessoryPanel().add((Component)jComponent, "Center");
                            MotifFileChooserUI.this.getAccessoryPanel().setPreferredSize(PREF_ACC_SIZE);
                            MotifFileChooserUI.this.getAccessoryPanel().setMaximumSize(MAX_SIZE);
                        } else {
                            MotifFileChooserUI.this.getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
                            MotifFileChooserUI.this.getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
                        }
                    }
                } else if (string == "ApproveButtonTextChangedProperty" || string == "ApproveButtonToolTipTextChangedProperty" || string == "DialogTypeChangedProperty") {
                    MotifFileChooserUI.this.approveButton.setText(MotifFileChooserUI.this.getApproveButtonText(MotifFileChooserUI.this.getFileChooser()));
                    MotifFileChooserUI.this.approveButton.setToolTipText(MotifFileChooserUI.this.getApproveButtonToolTipText(MotifFileChooserUI.this.getFileChooser()));
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                }
            }
        };
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i2]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifFileChooserUI((JFileChooser)jComponent);
    }

    protected class DirectoryCellRenderer
    extends DefaultListCellRenderer {
        protected DirectoryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)object));
            return this;
        }
    }

    protected class FileCellRenderer
    extends DefaultListCellRenderer {
        protected FileCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)object));
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        protected FilterComboBoxModel() {
            this.filters = MotifFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = MotifFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl2 = false;
            if (fileFilter != null) {
                for (int i2 = 0; i2 < this.filters.length; ++i2) {
                    if (this.filters[i2] != fileFilter) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    MotifFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return MotifFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public Object getElementAt(int n2) {
            if (n2 > this.getSize() - 1) {
                return MotifFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n2];
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                MotifFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    protected class MotifDirectoryListModel
    extends AbstractListModel
    implements ListDataListener {
        public int getSize() {
            return MotifFileChooserUI.this.getModel().getDirectories().size();
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getDirectories().size() - 1);
        }

        public MotifDirectoryListModel() {
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        public Object getElementAt(int n2) {
            return MotifFileChooserUI.this.getModel().getDirectories().elementAt(n2);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireIntervalAdded(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireIntervalRemoved(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }

    protected class MotifFileListModel
    extends AbstractListModel
    implements ListDataListener {
        public int getSize() {
            return MotifFileChooserUI.this.getModel().getFiles().size();
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getFiles().size() - 1);
        }

        public MotifFileListModel() {
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        public Object getElementAt(int n2) {
            return MotifFileChooserUI.this.getModel().getFiles().elementAt(n2);
        }

        public int indexOf(Object object) {
            return MotifFileChooserUI.this.getModel().getFiles().indexOf(object);
        }

        public boolean contains(Object object) {
            return MotifFileChooserUI.this.getModel().getFiles().contains(object);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireIntervalAdded(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireIntervalRemoved(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }
}

