/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.peer.LightweightPeer;
import sun.awt.SunGraphicsCallback;

abstract class GraphicsCallback
extends SunGraphicsCallback {
    GraphicsCallback() {
    }

    static final class PaintAllCallback
    extends GraphicsCallback {
        private static PaintAllCallback instance = new PaintAllCallback();

        private PaintAllCallback() {
        }

        static PaintAllCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            component.paintAll(graphics);
        }
    }

    static final class PaintCallback
    extends GraphicsCallback {
        private static PaintCallback instance = new PaintCallback();

        private PaintCallback() {
        }

        static PaintCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            component.paint(graphics);
        }
    }

    static final class PaintHeavyweightComponentsCallback
    extends GraphicsCallback {
        private static PaintHeavyweightComponentsCallback instance = new PaintHeavyweightComponentsCallback();

        private PaintHeavyweightComponentsCallback() {
        }

        static PaintHeavyweightComponentsCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            if (component.peer instanceof LightweightPeer) {
                component.paintHeavyweightComponents(graphics);
            } else {
                component.paintAll(graphics);
            }
        }
    }

    static final class PeerPaintCallback
    extends GraphicsCallback {
        private static PeerPaintCallback instance = new PeerPaintCallback();

        private PeerPaintCallback() {
        }

        static PeerPaintCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            component.validate();
            if (component.peer instanceof LightweightPeer) {
                component.lightweightPaint(graphics);
            } else {
                component.peer.paint(graphics);
            }
        }
    }

    static final class PeerPrintCallback
    extends GraphicsCallback {
        private static PeerPrintCallback instance = new PeerPrintCallback();

        private PeerPrintCallback() {
        }

        static PeerPrintCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            component.validate();
            if (component.peer instanceof LightweightPeer) {
                component.lightweightPrint(graphics);
            } else {
                component.peer.print(graphics);
            }
        }
    }

    static final class PrintAllCallback
    extends GraphicsCallback {
        private static PrintAllCallback instance = new PrintAllCallback();

        private PrintAllCallback() {
        }

        static PrintAllCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            component.printAll(graphics);
        }
    }

    static final class PrintCallback
    extends GraphicsCallback {
        private static PrintCallback instance = new PrintCallback();

        private PrintCallback() {
        }

        static PrintCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            component.print(graphics);
        }
    }

    static final class PrintHeavyweightComponentsCallback
    extends GraphicsCallback {
        private static PrintHeavyweightComponentsCallback instance = new PrintHeavyweightComponentsCallback();

        private PrintHeavyweightComponentsCallback() {
        }

        static PrintHeavyweightComponentsCallback getInstance() {
            return instance;
        }

        public void run(Component component, Graphics graphics) {
            if (component.peer instanceof LightweightPeer) {
                component.printHeavyweightComponents(graphics);
            } else {
                component.printAll(graphics);
            }
        }
    }
}

