/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static Map declaredMethodCache = Collections.synchronizedMap(new WeakHashMap(100));
    private static Map beanInfoCache = Collections.synchronizedMap(new WeakHashMap(100));
    private Class beanClass;
    private BeanInfo explicitBeanInfo;
    private BeanInfo superBeanInfo;
    private BeanInfo[] additionalBeanInfo;
    private boolean propertyChangeSource = false;
    private static Class eventListenerType = EventListener.class;
    private String defaultEventName;
    private String defaultPropertyName;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private Map methods = new TreeMap();
    private Map properties = new TreeMap();
    private Map events = new TreeMap();
    private static final String DEFAULT_INFO_PATH = "sun.beans.infos";
    private static String[] searchPath = new String[]{"sun.beans.infos"};
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String BEANINFO_SUFFIX = "BeanInfo";
    private HashMap pdStore;
    static /* synthetic */ Class class$java$beans$PropertyVetoException;
    static /* synthetic */ Class class$java$util$TooManyListenersException;

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        declaredMethodCache.clear();
    }

    private void processPropertyDescriptors() {
        if (this.pdStore == null) {
            return;
        }
        Iterator iterator = this.pdStore.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            PropertyDescriptor propertyDescriptor = null;
            PropertyDescriptor propertyDescriptor2 = null;
            PropertyDescriptor propertyDescriptor3 = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor2 = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor3 = null;
            List list = (List)iterator.next();
            for (n2 = 0; n2 < list.size(); ++n2) {
                propertyDescriptor = (PropertyDescriptor)list.get(n2);
                if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                    if (indexedPropertyDescriptor.getIndexedReadMethod() == null) continue;
                    if (indexedPropertyDescriptor2 != null) {
                        indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor);
                        continue;
                    }
                    indexedPropertyDescriptor2 = indexedPropertyDescriptor;
                    continue;
                }
                if (propertyDescriptor.getReadMethod() == null) continue;
                if (propertyDescriptor2 != null) {
                    Method method = propertyDescriptor2.getReadMethod();
                    if (method.getName().startsWith(IS_PREFIX)) continue;
                    propertyDescriptor2 = new PropertyDescriptor(propertyDescriptor2, propertyDescriptor);
                    continue;
                }
                propertyDescriptor2 = propertyDescriptor;
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                propertyDescriptor = (PropertyDescriptor)list.get(n2);
                if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                    if (indexedPropertyDescriptor.getIndexedWriteMethod() == null) continue;
                    if (indexedPropertyDescriptor2 != null) {
                        if (indexedPropertyDescriptor2.getIndexedPropertyType() != indexedPropertyDescriptor.getIndexedPropertyType()) continue;
                        if (indexedPropertyDescriptor3 != null) {
                            indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                            continue;
                        }
                        indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                        continue;
                    }
                    if (indexedPropertyDescriptor3 != null) {
                        indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                        continue;
                    }
                    indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                    continue;
                }
                if (propertyDescriptor.getWriteMethod() == null) continue;
                if (propertyDescriptor2 != null) {
                    if (propertyDescriptor2.getPropertyType() != propertyDescriptor.getPropertyType()) continue;
                    if (propertyDescriptor3 != null) {
                        propertyDescriptor3 = new PropertyDescriptor(propertyDescriptor3, propertyDescriptor);
                        continue;
                    }
                    propertyDescriptor3 = propertyDescriptor;
                    continue;
                }
                propertyDescriptor3 = propertyDescriptor3 != null ? new PropertyDescriptor(propertyDescriptor3, propertyDescriptor) : propertyDescriptor;
            }
            propertyDescriptor = null;
            indexedPropertyDescriptor = null;
            if (indexedPropertyDescriptor2 != null && indexedPropertyDescriptor3 != null) {
                if (propertyDescriptor2 != null && (propertyDescriptor2.getPropertyType().isArray() || propertyDescriptor2.getPropertyType().equals(indexedPropertyDescriptor2.getIndexedPropertyType()))) {
                    indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(propertyDescriptor2, indexedPropertyDescriptor2);
                }
                if (propertyDescriptor3 != null && (propertyDescriptor3.getPropertyType().isArray() || propertyDescriptor3.getPropertyType().equals(indexedPropertyDescriptor3.getIndexedPropertyType()))) {
                    indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(propertyDescriptor3, indexedPropertyDescriptor3);
                }
                propertyDescriptor = new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor3);
            } else if (propertyDescriptor2 != null && propertyDescriptor3 != null) {
                propertyDescriptor = new PropertyDescriptor(propertyDescriptor2, propertyDescriptor3);
            } else if (indexedPropertyDescriptor3 != null) {
                if (propertyDescriptor3 != null) {
                    indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(propertyDescriptor3, indexedPropertyDescriptor3);
                }
                if (propertyDescriptor2 != null) {
                    indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(propertyDescriptor2, indexedPropertyDescriptor3);
                }
                propertyDescriptor = indexedPropertyDescriptor3;
            } else if (indexedPropertyDescriptor2 != null) {
                if (propertyDescriptor2 != null) {
                    indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(propertyDescriptor2, indexedPropertyDescriptor2);
                }
                if (propertyDescriptor3 != null) {
                    indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(propertyDescriptor3, indexedPropertyDescriptor2);
                }
                propertyDescriptor = indexedPropertyDescriptor2;
            } else if (propertyDescriptor3 != null) {
                propertyDescriptor = propertyDescriptor3;
            } else if (propertyDescriptor2 != null) {
                propertyDescriptor = propertyDescriptor2;
            }
            if (propertyDescriptor instanceof IndexedPropertyDescriptor && ((indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod() == null || indexedPropertyDescriptor.getIndexedWriteMethod() == null) && indexedPropertyDescriptor.getReadMethod() != null && indexedPropertyDescriptor.getWriteMethod() != null) {
                propertyDescriptor = new PropertyDescriptor(indexedPropertyDescriptor);
            }
            if (propertyDescriptor == null) continue;
            this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
        }
    }

    private BeanDescriptor getTargetBeanDescriptor() throws IntrospectionException {
        BeanDescriptor beanDescriptor;
        if (this.explicitBeanInfo != null && (beanDescriptor = this.explicitBeanInfo.getBeanDescriptor()) != null) {
            return beanDescriptor;
        }
        return new BeanDescriptor(this.beanClass);
    }

    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        int n2;
        EventSetDescriptor[] eventSetDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            eventSetDescriptorArray = this.explicitBeanInfo.getEventSetDescriptors();
            n2 = this.explicitBeanInfo.getDefaultEventIndex();
            if (n2 >= 0 && n2 < eventSetDescriptorArray.length) {
                this.defaultEventName = eventSetDescriptorArray[n2].getName();
            }
        }
        if (eventSetDescriptorArray == null && this.superBeanInfo != null) {
            int n3;
            EventSetDescriptor[] eventSetDescriptorArray2 = this.superBeanInfo.getEventSetDescriptors();
            for (n3 = 0; n3 < eventSetDescriptorArray2.length; ++n3) {
                this.addEvent(eventSetDescriptorArray2[n3]);
            }
            n3 = this.superBeanInfo.getDefaultEventIndex();
            if (n3 >= 0 && n3 < eventSetDescriptorArray2.length) {
                this.defaultEventName = eventSetDescriptorArray2[n3].getName();
            }
        }
        for (n2 = 0; n2 < this.additionalBeanInfo.length; ++n2) {
            EventSetDescriptor[] eventSetDescriptorArray3 = this.additionalBeanInfo[n2].getEventSetDescriptors();
            if (eventSetDescriptorArray3 == null) continue;
            for (int i2 = 0; i2 < eventSetDescriptorArray3.length; ++i2) {
                this.addEvent(eventSetDescriptorArray3[i2]);
            }
        }
        if (eventSetDescriptorArray != null) {
            for (n2 = 0; n2 < eventSetDescriptorArray.length; ++n2) {
                this.addEvent(eventSetDescriptorArray[n2]);
            }
        } else {
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            HashMap hashMap = new HashMap(methodArray.length);
            HashMap hashMap2 = new HashMap(methodArray.length);
            HashMap hashMap3 = new HashMap(methodArray.length);
            for (int i3 = 0; i3 < methodArray.length; ++i3) {
                int n4;
                object4 = methodArray[i3];
                if (object4 == null || Modifier.isStatic(n4 = ((Method)object4).getModifiers())) continue;
                string = ((Method)object4).getName();
                object3 = ((Method)object4).getParameterTypes();
                object2 = ((Method)object4).getReturnType();
                if (string.startsWith(ADD_PREFIX) && ((Class[])object3).length == 1 && object2 == Void.TYPE && Introspector.isSubclass(object3[0], eventListenerType)) {
                    object = string.substring(3);
                    if (((String)object).length() <= 0 || !((Class)object3[0]).getName().endsWith((String)object)) continue;
                    hashMap.put(object, object4);
                    continue;
                }
                if (string.startsWith(REMOVE_PREFIX) && ((Class[])object3).length == 1 && object2 == Void.TYPE && Introspector.isSubclass(object3[0], eventListenerType)) {
                    object = string.substring(6);
                    if (((String)object).length() <= 0 || !((Class)object3[0]).getName().endsWith((String)object)) continue;
                    hashMap2.put(object, object4);
                    continue;
                }
                if (!string.startsWith(GET_PREFIX) || ((Class[])object3).length != 0 || !((Class)object2).isArray() || !Introspector.isSubclass(((Class)object2).getComponentType(), eventListenerType) || ((String)(object = string.substring(3, string.length() - 1))).length() <= 0 || !((Class)object2).getComponentType().getName().endsWith((String)object)) continue;
                hashMap3.put(object, object4);
            }
            Iterator iterator = hashMap.keySet().iterator();
            object4 = this.beanClass.getName();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (hashMap2.get(string2) == null) continue;
                string = Introspector.decapitalize(string2.substring(0, string2.length() - 8));
                object3 = (Method)hashMap.get(string2);
                object2 = (Method)hashMap2.get(string2);
                object = (Method)hashMap3.get(string2);
                Class clazz = ((Method)object3).getParameterTypes()[0];
                Method[] methodArray2 = Introspector.getPublicDeclaredMethods(clazz);
                ArrayList arrayList = new ArrayList(methodArray2.length);
                for (int i4 = 0; i4 < methodArray2.length; ++i4) {
                    if (methodArray2[i4] == null || !this.isEventHandler(methodArray2[i4])) continue;
                    arrayList.add(methodArray2[i4]);
                }
                Method[] methodArray3 = (Method[])arrayList.toArray(new Method[arrayList.size()]);
                EventSetDescriptor eventSetDescriptor = new EventSetDescriptor(string, clazz, methodArray3, (Method)object3, (Method)object2, (Method)object);
                if (this.throwsException((Method)object3, class$java$util$TooManyListenersException == null ? Introspector.class$("java.util.TooManyListenersException") : class$java$util$TooManyListenersException)) {
                    eventSetDescriptor.setUnicast(true);
                }
                this.addEvent(eventSetDescriptor);
            }
        }
        Object[] objectArray = new EventSetDescriptor[this.events.size()];
        objectArray = (EventSetDescriptor[])this.events.values().toArray(objectArray);
        for (int i5 = 0; i5 < objectArray.length; ++i5) {
            if (this.defaultEventName == null || !this.defaultEventName.equals(((FeatureDescriptor)objectArray[i5]).getName())) continue;
            this.defaultEventIndex = i5;
        }
        return objectArray;
    }

    private void addEvent(EventSetDescriptor eventSetDescriptor) {
        EventSetDescriptor eventSetDescriptor2;
        String string = eventSetDescriptor.getName();
        if (eventSetDescriptor.getName().equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if ((eventSetDescriptor2 = (EventSetDescriptor)this.events.get(string)) == null) {
            this.events.put(string, eventSetDescriptor);
            return;
        }
        EventSetDescriptor eventSetDescriptor3 = new EventSetDescriptor(eventSetDescriptor2, eventSetDescriptor);
        this.events.put(string, eventSetDescriptor3);
    }

    private GenericBeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor beanDescriptor = this.getTargetBeanDescriptor();
        MethodDescriptor[] methodDescriptorArray = this.getTargetMethodInfo();
        EventSetDescriptor[] eventSetDescriptorArray = this.getTargetEventInfo();
        PropertyDescriptor[] propertyDescriptorArray = this.getTargetPropertyInfo();
        int n2 = this.getTargetDefaultEventIndex();
        int n3 = this.getTargetDefaultPropertyIndex();
        return new GenericBeanInfo(beanDescriptor, eventSetDescriptorArray, n2, propertyDescriptorArray, n3, methodDescriptorArray, this.explicitBeanInfo);
    }

    private MethodDescriptor[] getTargetMethodInfo() throws IntrospectionException {
        int n2;
        int n3;
        MethodDescriptor[] methodDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            methodDescriptorArray = this.explicitBeanInfo.getMethodDescriptors();
        }
        if (methodDescriptorArray == null && this.superBeanInfo != null) {
            MethodDescriptor[] methodDescriptorArray2 = this.superBeanInfo.getMethodDescriptors();
            for (n3 = 0; n3 < methodDescriptorArray2.length; ++n3) {
                this.addMethod(methodDescriptorArray2[n3]);
            }
        }
        for (n2 = 0; n2 < this.additionalBeanInfo.length; ++n2) {
            MethodDescriptor[] methodDescriptorArray3 = this.additionalBeanInfo[n2].getMethodDescriptors();
            if (methodDescriptorArray3 == null) continue;
            for (int i2 = 0; i2 < methodDescriptorArray3.length; ++i2) {
                this.addMethod(methodDescriptorArray3[i2]);
            }
        }
        if (methodDescriptorArray != null) {
            for (n2 = 0; n2 < methodDescriptorArray.length; ++n2) {
                this.addMethod(methodDescriptorArray[n2]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n3 = 0; n3 < methodArray.length; ++n3) {
                Method method = methodArray[n3];
                if (method == null) continue;
                MethodDescriptor methodDescriptor = new MethodDescriptor(method);
                this.addMethod(methodDescriptor);
            }
        }
        Object[] objectArray = new MethodDescriptor[this.methods.size()];
        objectArray = (MethodDescriptor[])this.methods.values().toArray(objectArray);
        return objectArray;
    }

    private void addMethod(MethodDescriptor methodDescriptor) {
        String string = methodDescriptor.getName();
        MethodDescriptor methodDescriptor2 = (MethodDescriptor)this.methods.get(string);
        if (methodDescriptor2 == null) {
            this.methods.put(string, methodDescriptor);
            return;
        }
        Class[] classArray = methodDescriptor.getMethod().getParameterTypes();
        Class[] classArray2 = methodDescriptor2.getMethod().getParameterTypes();
        boolean bl2 = false;
        if (classArray.length == classArray2.length) {
            bl2 = true;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (classArray[i2] == classArray2[i2]) continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            MethodDescriptor methodDescriptor3 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
            this.methods.put(string, methodDescriptor3);
            return;
        }
        String string2 = this.makeQualifiedMethodName(methodDescriptor);
        methodDescriptor2 = (MethodDescriptor)this.methods.get(string2);
        if (methodDescriptor2 == null) {
            this.methods.put(string2, methodDescriptor);
            return;
        }
        MethodDescriptor methodDescriptor4 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
        this.methods.put(string2, methodDescriptor4);
    }

    private PropertyDescriptor[] getTargetPropertyInfo() throws IntrospectionException {
        int n2;
        int n3;
        PropertyDescriptor[] propertyDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            propertyDescriptorArray = this.explicitBeanInfo.getPropertyDescriptors();
            n3 = this.explicitBeanInfo.getDefaultPropertyIndex();
            if (n3 >= 0 && n3 < propertyDescriptorArray.length) {
                this.defaultPropertyName = propertyDescriptorArray[n3].getName();
            }
        }
        if (propertyDescriptorArray == null && this.superBeanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray2 = this.superBeanInfo.getPropertyDescriptors();
            for (n2 = 0; n2 < propertyDescriptorArray2.length; ++n2) {
                this.addPropertyDescriptor(propertyDescriptorArray2[n2]);
            }
            n2 = this.superBeanInfo.getDefaultPropertyIndex();
            if (n2 >= 0 && n2 < propertyDescriptorArray2.length) {
                this.defaultPropertyName = propertyDescriptorArray2[n2].getName();
            }
        }
        for (n3 = 0; n3 < this.additionalBeanInfo.length; ++n3) {
            PropertyDescriptor[] propertyDescriptorArray3 = this.additionalBeanInfo[n3].getPropertyDescriptors();
            if (propertyDescriptorArray3 == null) continue;
            for (int i2 = 0; i2 < propertyDescriptorArray3.length; ++i2) {
                this.addPropertyDescriptor(propertyDescriptorArray3[i2]);
            }
        }
        if (propertyDescriptorArray != null) {
            for (n3 = 0; n3 < propertyDescriptorArray.length; ++n3) {
                this.addPropertyDescriptor(propertyDescriptorArray[n3]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                int n4;
                Method method = methodArray[n2];
                if (method == null || Modifier.isStatic(n4 = method.getModifiers())) continue;
                String string = method.getName();
                Class[] classArray = method.getParameterTypes();
                Class clazz = method.getReturnType();
                int n5 = classArray.length;
                PropertyDescriptor propertyDescriptor = null;
                try {
                    if (n5 == 0) {
                        if (string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), method, null);
                        } else if (clazz == Boolean.TYPE && string.startsWith(IS_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(2)), method, null);
                        }
                    } else if (n5 == 1) {
                        if (classArray[0] == Integer.TYPE && string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, method, null);
                        } else if (clazz == Void.TYPE && string.startsWith(SET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, method);
                            if (this.throwsException(method, class$java$beans$PropertyVetoException == null ? Introspector.class$("java.beans.PropertyVetoException") : class$java$beans$PropertyVetoException)) {
                                propertyDescriptor.setConstrained(true);
                            }
                        }
                    } else if (n5 == 2 && classArray[0] == Integer.TYPE && string.startsWith(SET_PREFIX)) {
                        propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, null, method);
                        if (this.throwsException(method, class$java$beans$PropertyVetoException == null ? Introspector.class$("java.beans.PropertyVetoException") : class$java$beans$PropertyVetoException)) {
                            propertyDescriptor.setConstrained(true);
                        }
                    }
                }
                catch (IntrospectionException introspectionException) {
                    propertyDescriptor = null;
                }
                if (propertyDescriptor == null) continue;
                if (this.propertyChangeSource) {
                    propertyDescriptor.setBound(true);
                }
                this.addPropertyDescriptor(propertyDescriptor);
            }
        }
        this.processPropertyDescriptors();
        Object[] objectArray = new PropertyDescriptor[this.properties.size()];
        objectArray = (PropertyDescriptor[])this.properties.values().toArray(objectArray);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (this.defaultPropertyName == null || !this.defaultPropertyName.equals(((FeatureDescriptor)objectArray[n2]).getName())) continue;
            this.defaultPropertyIndex = n2;
        }
        return objectArray;
    }

    private void addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        String string;
        List list;
        if (this.pdStore == null) {
            this.pdStore = new HashMap();
        }
        if ((list = (List)this.pdStore.get(string = propertyDescriptor.getName())) == null) {
            list = new ArrayList();
            this.pdStore.put(string, list);
        }
        list.add(propertyDescriptor);
    }

    public static void flushFromCaches(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        beanInfoCache.remove(clazz);
        declaredMethodCache.remove(clazz);
    }

    public static synchronized String[] getBeanInfoSearchPath() {
        String[] stringArray = new String[searchPath.length];
        for (int i2 = 0; i2 < searchPath.length; ++i2) {
            stringArray[i2] = searchPath[i2];
        }
        return stringArray;
    }

    public static synchronized void setBeanInfoSearchPath(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        searchPath = stringArray;
    }

    private boolean isEventHandler(Method method) throws IntrospectionException {
        try {
            Class[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            return Introspector.isSubclass(classArray[0], EventObject.class);
        }
        catch (Exception exception) {
            throw new IntrospectionException("Unexpected reflection exception: " + exception);
        }
    }

    private static synchronized BeanInfo findExplicitBeanInfo(Class clazz) {
        String string = clazz.getName() + BEANINFO_SUFFIX;
        try {
            return (BeanInfo)Introspector.instantiate(clazz, string);
        }
        catch (Exception exception) {
            try {
                if (Introspector.isSubclass(clazz, BeanInfo.class)) {
                    return (BeanInfo)clazz.newInstance();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            string = string.substring(string.lastIndexOf(46) + 1);
            for (int i2 = 0; i2 < searchPath.length; ++i2) {
                if (DEFAULT_INFO_PATH.equals(searchPath[i2]) && (!DEFAULT_INFO_PATH.equals(searchPath[i2]) || !"ComponentBeanInfo".equals(string))) continue;
                try {
                    Method method;
                    int n2;
                    FeatureDescriptor[] featureDescriptorArray;
                    String string2 = searchPath[i2] + "." + string;
                    BeanInfo beanInfo = (BeanInfo)Introspector.instantiate(clazz, string2);
                    if (beanInfo.getBeanDescriptor() != null) {
                        if (beanInfo.getBeanDescriptor().getBeanClass() != clazz) continue;
                        return beanInfo;
                    }
                    if (beanInfo.getPropertyDescriptors() != null) {
                        featureDescriptorArray = beanInfo.getPropertyDescriptors();
                        for (n2 = 0; n2 < featureDescriptorArray.length; ++n2) {
                            method = ((PropertyDescriptor)featureDescriptorArray[n2]).getReadMethod();
                            if (method.getDeclaringClass() != clazz) continue;
                            return beanInfo;
                        }
                        continue;
                    }
                    if (beanInfo.getMethodDescriptors() == null) continue;
                    featureDescriptorArray = beanInfo.getMethodDescriptors();
                    for (n2 = 0; n2 < featureDescriptorArray.length; ++n2) {
                        method = ((MethodDescriptor)featureDescriptorArray[n2]).getMethod();
                        if (method.getDeclaringClass() != clazz) continue;
                        return beanInfo;
                    }
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        GenericBeanInfo genericBeanInfo = (GenericBeanInfo)beanInfoCache.get(clazz);
        if (genericBeanInfo == null) {
            genericBeanInfo = new Introspector(clazz, null, 1).getBeanInfo();
            beanInfoCache.put(clazz, genericBeanInfo);
        }
        return genericBeanInfo;
    }

    public static BeanInfo getBeanInfo(Class clazz, int n2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, null, n2);
    }

    static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (!clazz2.isInterface()) continue;
            Class[] classArray = clazz3.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (!Introspector.isSubclass(classArray[i2], clazz2)) continue;
                return true;
            }
        }
        return false;
    }

    private Introspector(Class clazz, Class clazz2, int n2) throws IntrospectionException {
        Class clazz3;
        this.beanClass = clazz;
        if (clazz2 != null) {
            boolean bl2 = false;
            for (Class clazz4 = clazz.getSuperclass(); clazz4 != null; clazz4 = clazz4.getSuperclass()) {
                if (clazz4 != clazz2) continue;
                bl2 = true;
            }
            if (!bl2) {
                throw new IntrospectionException(clazz2.getName() + " not superclass of " + clazz.getName());
            }
        }
        if (n2 == 1) {
            this.explicitBeanInfo = Introspector.findExplicitBeanInfo(clazz);
        }
        if ((clazz3 = clazz.getSuperclass()) != clazz2) {
            int n3 = n2;
            if (n3 == 2) {
                n3 = 1;
            }
            this.superBeanInfo = Introspector.getBeanInfo(clazz3, clazz2, n3);
        }
        if (this.explicitBeanInfo != null) {
            this.additionalBeanInfo = this.explicitBeanInfo.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private boolean throwsException(Method method, Class clazz) {
        Class[] classArray = method.getExceptionTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] != clazz) continue;
            return true;
        }
        return false;
    }

    private String makeQualifiedMethodName(MethodDescriptor methodDescriptor) {
        Method method = methodDescriptor.getMethod();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append('=');
        Class[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(':');
            stringBuffer.append(classArray[i2].getName());
        }
        return stringBuffer.toString();
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clazz) {
        final Class clazz2 = clazz;
        Method[] methodArray = (Method[])declaredMethodCache.get(clazz2);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz2.getDeclaredMethods();
            }
        });
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Method method = methodArray[i2];
            int n2 = method.getModifiers();
            if (Modifier.isPublic(n2)) continue;
            methodArray[i2] = null;
        }
        declaredMethodCache.put(clazz2, methodArray);
        return methodArray;
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, clazz2, 1);
    }

    private static BeanInfo getBeanInfo(Class clazz, Class clazz2, int n2) throws IntrospectionException {
        GenericBeanInfo genericBeanInfo = clazz2 == null && n2 == 1 ? (GenericBeanInfo)Introspector.getBeanInfo(clazz) : new Introspector(clazz, clazz2, n2).getBeanInfo();
        return genericBeanInfo;
    }

    static Object instantiate(Class clazz, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            try {
                Class clazz2 = classLoader.loadClass(string);
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader != null) {
                Class clazz3 = classLoader.loadClass(string);
                return clazz3.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        Class clazz4 = classLoader.loadClass(string);
        return clazz4.newInstance();
    }

    static Method findMethod(Class clazz, String string, int n2) throws IntrospectionException {
        return Introspector.findMethod(clazz, string, n2, null);
    }

    static Method findMethod(Class clazz, String string, int n2, Class[] classArray) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = Introspector.internalFindMethod(clazz, string, n2, classArray);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n2 + " arg(s) of matching types.");
    }

    private static Method internalFindMethod(Class classArray, String string, int n2, Class[] classArray2) {
        Object object;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            Method[] methodArray = Introspector.getPublicDeclaredMethods((Class)object);
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                int n3;
                Method method = methodArray[i2];
                if (method == null || Modifier.isStatic(n3 = method.getModifiers())) continue;
                Class[] classArray3 = method.getParameterTypes();
                if (!method.getName().equals(string) || classArray3.length != n2) continue;
                if (classArray2 != null) {
                    boolean bl2 = false;
                    if (n2 > 0) {
                        for (int i3 = 0; i3 < n2; ++i3) {
                            if (classArray3[i3] == classArray2[i3]) continue;
                            bl2 = true;
                        }
                        if (bl2) continue;
                    }
                }
                return method;
            }
        }
        object = classArray.getInterfaces();
        for (int i4 = 0; i4 < ((Class[])object).length; ++i4) {
            Method method = Introspector.internalFindMethod(object[i4], string, n2, null);
            if (method == null) continue;
            return method;
        }
        return null;
    }
}

