/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.UnmodifiableSetException;

public final class AttributeSetUtilities {
    private AttributeSetUtilities() {
    }

    public static void verifyCategoryForValue(Class clazz, Attribute attribute) {
        if (!clazz.equals(attribute.getCategory())) {
            throw new IllegalArgumentException();
        }
    }

    public static AttributeSet synchronizedView(AttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedAttributeSet(attributeSet);
    }

    public static AttributeSet unmodifiableView(AttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableAttributeSet(attributeSet);
    }

    public static DocAttributeSet synchronizedView(DocAttributeSet docAttributeSet) {
        if (docAttributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedDocAttributeSet(docAttributeSet);
    }

    public static DocAttributeSet unmodifiableView(DocAttributeSet docAttributeSet) {
        if (docAttributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableDocAttributeSet(docAttributeSet);
    }

    public static PrintJobAttributeSet synchronizedView(PrintJobAttributeSet printJobAttributeSet) {
        if (printJobAttributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedPrintJobAttributeSet(printJobAttributeSet);
    }

    public static PrintJobAttributeSet unmodifiableView(PrintJobAttributeSet printJobAttributeSet) {
        if (printJobAttributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiablePrintJobAttributeSet(printJobAttributeSet);
    }

    public static PrintRequestAttributeSet synchronizedView(PrintRequestAttributeSet printRequestAttributeSet) {
        if (printRequestAttributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedPrintRequestAttributeSet(printRequestAttributeSet);
    }

    public static PrintRequestAttributeSet unmodifiableView(PrintRequestAttributeSet printRequestAttributeSet) {
        if (printRequestAttributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiablePrintRequestAttributeSet(printRequestAttributeSet);
    }

    public static PrintServiceAttributeSet synchronizedView(PrintServiceAttributeSet printServiceAttributeSet) {
        if (printServiceAttributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedPrintServiceAttributeSet(printServiceAttributeSet);
    }

    public static PrintServiceAttributeSet unmodifiableView(PrintServiceAttributeSet printServiceAttributeSet) {
        if (printServiceAttributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiablePrintServiceAttributeSet(printServiceAttributeSet);
    }

    public static Class verifyAttributeCategory(Object object, Class clazz) {
        Class clazz2 = (Class)object;
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz2;
        }
        throw new ClassCastException();
    }

    public static Attribute verifyAttributeValue(Object object, Class clazz) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (clazz.isInstance(object)) {
            return (Attribute)object;
        }
        throw new ClassCastException();
    }

    private static class SynchronizedAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet attrset;

        public synchronized int hashCode() {
            return ((Object)this.attrset).hashCode();
        }

        public synchronized int size() {
            return this.attrset.size();
        }

        public synchronized void clear() {
            this.attrset.clear();
        }

        public synchronized boolean isEmpty() {
            return this.attrset.isEmpty();
        }

        public synchronized boolean containsKey(Class clazz) {
            return this.attrset.containsKey(clazz);
        }

        public synchronized boolean remove(Class clazz) {
            return this.attrset.remove(clazz);
        }

        public synchronized boolean equals(Object object) {
            return ((Object)this.attrset).equals(object);
        }

        public synchronized Attribute[] toArray() {
            return this.attrset.toArray();
        }

        public synchronized boolean add(Attribute attribute) {
            return this.attrset.add(attribute);
        }

        public synchronized boolean containsValue(Attribute attribute) {
            return this.attrset.containsValue(attribute);
        }

        public synchronized boolean remove(Attribute attribute) {
            return this.attrset.remove(attribute);
        }

        public SynchronizedAttributeSet(AttributeSet attributeSet) {
            this.attrset = attributeSet;
        }

        public synchronized boolean addAll(AttributeSet attributeSet) {
            return this.attrset.addAll(attributeSet);
        }

        public synchronized Attribute get(Class clazz) {
            return this.attrset.get(clazz);
        }
    }

    private static class SynchronizedDocAttributeSet
    extends SynchronizedAttributeSet
    implements DocAttributeSet,
    Serializable {
        public SynchronizedDocAttributeSet(DocAttributeSet docAttributeSet) {
            super(docAttributeSet);
        }
    }

    private static class SynchronizedPrintJobAttributeSet
    extends SynchronizedAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public SynchronizedPrintJobAttributeSet(PrintJobAttributeSet printJobAttributeSet) {
            super(printJobAttributeSet);
        }
    }

    private static class SynchronizedPrintRequestAttributeSet
    extends SynchronizedAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public SynchronizedPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
            super(printRequestAttributeSet);
        }
    }

    private static class SynchronizedPrintServiceAttributeSet
    extends SynchronizedAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public SynchronizedPrintServiceAttributeSet(PrintServiceAttributeSet printServiceAttributeSet) {
            super(printServiceAttributeSet);
        }
    }

    private static class UnmodifiableAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet attrset;

        public int hashCode() {
            return ((Object)this.attrset).hashCode();
        }

        public int size() {
            return this.attrset.size();
        }

        public void clear() {
            throw new UnmodifiableSetException();
        }

        public boolean isEmpty() {
            return this.attrset.isEmpty();
        }

        public boolean containsKey(Class clazz) {
            return this.attrset.containsKey(clazz);
        }

        public synchronized boolean remove(Class clazz) {
            throw new UnmodifiableSetException();
        }

        public boolean equals(Object object) {
            return ((Object)this.attrset).equals(object);
        }

        public Attribute[] toArray() {
            return this.attrset.toArray();
        }

        public boolean add(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public boolean containsValue(Attribute attribute) {
            return this.attrset.containsValue(attribute);
        }

        public boolean remove(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public UnmodifiableAttributeSet(AttributeSet attributeSet) {
            this.attrset = attributeSet;
        }

        public boolean addAll(AttributeSet attributeSet) {
            throw new UnmodifiableSetException();
        }

        public Attribute get(Class clazz) {
            return this.attrset.get(clazz);
        }
    }

    private static class UnmodifiableDocAttributeSet
    extends UnmodifiableAttributeSet
    implements DocAttributeSet,
    Serializable {
        public UnmodifiableDocAttributeSet(DocAttributeSet docAttributeSet) {
            super(docAttributeSet);
        }
    }

    private static class UnmodifiablePrintJobAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public UnmodifiablePrintJobAttributeSet(PrintJobAttributeSet printJobAttributeSet) {
            super(printJobAttributeSet);
        }
    }

    private static class UnmodifiablePrintRequestAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public UnmodifiablePrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
            super(printRequestAttributeSet);
        }
    }

    private static class UnmodifiablePrintServiceAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public UnmodifiablePrintServiceAttributeSet(PrintServiceAttributeSet printServiceAttributeSet) {
            super(printServiceAttributeSet);
        }
    }
}

