/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultButtonModel
implements ButtonModel,
Serializable {
    protected int stateMask = 0;
    protected String actionCommand = null;
    protected ButtonGroup group = null;
    protected int mnemonic = 0;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    public static final int ARMED = 1;
    public static final int SELECTED = 2;
    public static final int PRESSED = 4;
    public static final int ENABLED = 8;
    public static final int ROLLOVER = 16;

    public int getMnemonic() {
        return this.mnemonic;
    }

    public DefaultButtonModel() {
        this.setEnabled(true);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$ChangeListener == null ? DefaultButtonModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    public boolean isArmed() {
        return (this.stateMask & 1) != 0;
    }

    public boolean isEnabled() {
        return (this.stateMask & 8) != 0;
    }

    public boolean isPressed() {
        return (this.stateMask & 4) != 0;
    }

    public boolean isRollover() {
        return (this.stateMask & 0x10) != 0;
    }

    public boolean isSelected() {
        return (this.stateMask & 2) != 0;
    }

    public void setMnemonic(int n2) {
        this.mnemonic = n2;
        this.fireStateChanged();
    }

    public void setArmed(boolean bl2) {
        if (this.isArmed() == bl2 || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl2 ? (this.stateMask |= 1) : (this.stateMask &= 0xFFFFFFFE);
        this.fireStateChanged();
    }

    public void setEnabled(boolean bl2) {
        if (this.isEnabled() == bl2) {
            return;
        }
        if (bl2) {
            this.stateMask |= 8;
        } else {
            this.stateMask &= 0xFFFFFFF7;
            this.stateMask &= 0xFFFFFFFE;
            this.stateMask &= 0xFFFFFFFB;
        }
        this.fireStateChanged();
    }

    public void setPressed(boolean bl2) {
        if (this.isPressed() == bl2 || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl2 ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!this.isPressed() && this.isArmed()) {
            int n2 = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n2 = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n2 = ((ActionEvent)aWTEvent).getModifiers();
            }
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n2));
        }
        this.fireStateChanged();
    }

    public void setRollover(boolean bl2) {
        if (this.isRollover() == bl2 || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl2 ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        this.fireStateChanged();
    }

    public void setSelected(boolean bl2) {
        if (this.isSelected() == bl2) {
            return;
        }
        this.stateMask = bl2 ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireItemStateChanged(new ItemEvent(this, 701, this, bl2 ? 1 : 2));
        this.fireStateChanged();
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$java$awt$event$ActionListener == null ? DefaultButtonModel.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i2 + 1]).actionPerformed(actionEvent);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$java$awt$event$ItemListener == null ? DefaultButtonModel.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) continue;
            ((ItemListener)objectArray[i2 + 1]).itemStateChanged(itemEvent);
        }
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public ButtonGroup getGroup() {
        return this.group;
    }

    public void setGroup(ButtonGroup buttonGroup) {
        this.group = buttonGroup;
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

