/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    private static final MenuSelectionManager instance = new MenuSelectionManager();
    private Vector selection = new Vector();
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public void clearSelectedPath() {
        if (this.selection.size() > 0) {
            this.setSelectedPath(null);
        }
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$ChangeListener == null ? MenuSelectionManager.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        if (this.selection.size() > 0) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(0);
            return this.isComponentPartOfCurrentMenu(menuElement, component);
        }
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        Vector vector = (Vector)this.selection.clone();
        int n2 = vector.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            MenuElement menuElement = (MenuElement)vector.elementAt(i2);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n3 = menuElementArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Component component;
                if (menuElementArray[i3] == null || !(component = menuElementArray[i3].getComponent()).isShowing()) continue;
                if (menuElementArray2 == null) {
                    menuElementArray2 = new MenuElement[i2 + 2];
                    for (int i4 = 0; i4 <= i2; ++i4) {
                        menuElementArray2[i4] = (MenuElement)vector.elementAt(i4);
                    }
                }
                menuElementArray2[i2 + 1] = menuElementArray[i3];
                menuElementArray[i3].processKeyEvent(keyEvent, menuElementArray2, this);
                if (!keyEvent.isConsumed()) continue;
                return;
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Component component = (Component)mouseEvent.getSource();
        if (!component.isShowing()) {
            return;
        }
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getModifiers();
        if ((n2 == 504 || n2 == 505) && (n3 & 0x1C) != 0) {
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        int n4 = point.x;
        int n5 = point.y;
        Vector vector = (Vector)this.selection.clone();
        int n6 = vector.size();
        boolean bl2 = false;
        for (int i2 = n6 - 1; i2 >= 0 && !bl2; --i2) {
            MenuElement menuElement = (MenuElement)vector.elementAt(i2);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n7 = menuElementArray.length;
            for (int i3 = 0; i3 < n7 && !bl2; ++i3) {
                Serializable serializable;
                int n8;
                int n9;
                Component component2;
                if (menuElementArray[i3] == null || !(component2 = menuElementArray[i3].getComponent()).isShowing()) continue;
                if (component2 instanceof JComponent) {
                    n9 = ((JComponent)component2).getWidth();
                    n8 = ((JComponent)component2).getHeight();
                } else {
                    Rectangle rectangle = component2.getBounds();
                    n9 = rectangle.width;
                    n8 = rectangle.height;
                }
                point.x = n4;
                point.y = n5;
                SwingUtilities.convertPointFromScreen(point, component2);
                if (point.x < 0 || point.x >= n9 || point.y < 0 || point.y >= n8) continue;
                if (menuElementArray2 == null) {
                    menuElementArray2 = new MenuElement[i2 + 2];
                    for (int i4 = 0; i4 <= i2; ++i4) {
                        menuElementArray2[i4] = (MenuElement)vector.elementAt(i4);
                    }
                }
                menuElementArray2[i2 + 1] = menuElementArray[i3];
                MenuElement[] menuElementArray3 = this.getSelectedPath();
                if (menuElementArray3[menuElementArray3.length - 1] != menuElementArray2[i2 + 1] && (menuElementArray3.length < 2 || menuElementArray3[menuElementArray3.length - 2] != menuElementArray2[i2 + 1])) {
                    serializable = menuElementArray3[menuElementArray3.length - 1].getComponent();
                    MouseEvent mouseEvent2 = new MouseEvent((Component)serializable, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    menuElementArray3[menuElementArray3.length - 1].processMouseEvent(mouseEvent2, menuElementArray2, this);
                    MouseEvent mouseEvent3 = new MouseEvent(component2, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    menuElementArray[i3].processMouseEvent(mouseEvent3, menuElementArray2, this);
                }
                serializable = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                menuElementArray[i3].processMouseEvent((MouseEvent)serializable, menuElementArray2, this);
                bl2 = true;
                mouseEvent.consume();
            }
        }
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selection.size()];
        int n2 = this.selection.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            menuElementArray[i2] = (MenuElement)this.selection.elementAt(i2);
        }
        return menuElementArray;
    }

    private void printMenuElementArray(MenuElement[] menuElementArray) {
        this.printMenuElementArray(menuElementArray, false);
    }

    public void setSelectedPath(MenuElement[] menuElementArray) {
        int n2;
        int n3 = this.selection.size();
        int n4 = 0;
        if (menuElementArray == null) {
            menuElementArray = new MenuElement[]{};
        }
        int n5 = menuElementArray.length;
        for (n2 = 0; n2 < n5 && n2 < n3 && (MenuElement)this.selection.elementAt(n2) == menuElementArray[n2]; ++n2) {
            ++n4;
        }
        for (n2 = n3 - 1; n2 >= n4; --n2) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(n2);
            this.selection.removeElementAt(n2);
            menuElement.menuSelectionChanged(false);
        }
        n5 = menuElementArray.length;
        for (n2 = n4; n2 < n5; ++n2) {
            if (menuElementArray[n2] == null) continue;
            this.selection.addElement(menuElementArray[n2]);
            menuElementArray[n2].menuSelectionChanged(true);
        }
        this.fireStateChanged();
    }

    private void printMenuElementArray(MenuElement[] menuElementArray, boolean bl2) {
        System.out.println("Path is(");
        int n2 = menuElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 <= i2; ++i3) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i2];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement instanceof JMenuBar) {
                System.out.println("JMenuBar, ");
                continue;
            }
            if (menuElement instanceof JPopupMenu) {
                System.out.println("JPopupMenu, ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl2) {
            Thread.dumpStack();
        }
    }

    public static MenuSelectionManager defaultManager() {
        return instance;
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private boolean isComponentPartOfCurrentMenu(MenuElement menuElement, Component component) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement.getComponent() == component) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n2 = menuElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.isComponentPartOfCurrentMenu(menuElementArray[i2], component)) continue;
            return true;
        }
        return false;
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        int n2 = point2.x;
        int n3 = point2.y;
        Vector vector = (Vector)this.selection.clone();
        int n4 = vector.size();
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            MenuElement menuElement = (MenuElement)vector.elementAt(i2);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            int n5 = menuElementArray.length;
            for (int i3 = 0; i3 < n5; ++i3) {
                int n6;
                int n7;
                Component component2;
                if (menuElementArray[i3] == null || !(component2 = menuElementArray[i3].getComponent()).isShowing()) continue;
                if (component2 instanceof JComponent) {
                    n7 = ((JComponent)component2).getWidth();
                    n6 = ((JComponent)component2).getHeight();
                } else {
                    Rectangle rectangle = component2.getBounds();
                    n7 = rectangle.width;
                    n6 = rectangle.height;
                }
                point2.x = n2;
                point2.y = n3;
                SwingUtilities.convertPointFromScreen(point2, component2);
                if (point2.x < 0 || point2.x >= n7 || point2.y < 0 || point2.y >= n6) continue;
                return component2;
            }
        }
        return null;
    }
}

