/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressMonitor {
    private ProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private Object[] cancelOption = null;
    private Object message;
    private long T0;
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int min;
    private int max;
    private int v;
    private int lastDisp;
    private int reportDelta;

    public int getMaximum() {
        return this.max;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public int getMinimum() {
        return this.min;
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object object = this.pane.getValue();
        return object != null && this.cancelOption.length == 1 && object.equals(this.cancelOption[0]);
    }

    public void setMaximum(int n2) {
        this.max = n2;
    }

    public void setMillisToDecideToPopup(int n2) {
        this.millisToDecideToPopup = n2;
    }

    public void setMillisToPopup(int n2) {
        this.millisToPopup = n2;
    }

    public void setMinimum(int n2) {
        this.min = n2;
    }

    public void setProgress(int n2) {
        this.v = n2;
        if (n2 >= this.max) {
            this.close();
        } else if (n2 >= this.lastDisp + this.reportDelta) {
            this.lastDisp = n2;
            if (this.myBar != null) {
                this.myBar.setValue(n2);
            } else {
                int n3;
                long l2 = System.currentTimeMillis();
                long l3 = (int)(l2 - this.T0);
                if (l3 >= (long)this.millisToDecideToPopup && (n3 = n2 > this.min ? (int)(l3 * (long)(this.max - this.min) / (long)(n2 - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                    this.myBar = new JProgressBar();
                    this.myBar.setMinimum(this.min);
                    this.myBar.setMaximum(this.max);
                    this.myBar.setValue(n2);
                    if (this.note != null) {
                        this.noteLabel = new JLabel(this.note);
                    }
                    this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                    this.dialog = this.pane.createDialog(this.parentComponent, UIManager.getString("ProgressMonitor.progressText"));
                    this.dialog.show();
                }
            }
        }
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
        }
    }

    public ProgressMonitor(Component component, Object object, String string, int n2, int n3) {
        this(component, object, string, n2, n3, null);
    }

    private ProgressMonitor(Component component, Object object, String string, int n2, int n3, ProgressMonitor progressMonitor) {
        this.min = n2;
        this.max = n3;
        this.parentComponent = component;
        this.cancelOption = new Object[1];
        this.cancelOption[0] = UIManager.getString("OptionPane.cancelButtonText");
        this.reportDelta = (n3 - n2) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.v = n2;
        this.message = object;
        this.note = string;
        if (progressMonitor != null) {
            this.root = progressMonitor.root != null ? progressMonitor.root : progressMonitor;
            this.T0 = this.root.T0;
            this.dialog = this.root.dialog;
        } else {
            this.T0 = System.currentTimeMillis();
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        ProgressOptionPane(Object object) {
            super(object, 1, -1, null, ProgressMonitor.this.cancelOption, null);
        }

        static /* synthetic */ ProgressMonitor access$100(ProgressOptionPane progressOptionPane) {
            return progressOptionPane.ProgressMonitor.this;
        }

        public JDialog createDialog(Component component, String string) {
            Frame frame = JOptionPane.getFrameForComponent(component);
            JDialog jDialog = new JDialog(frame, string, false);
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            jDialog.pack();
            jDialog.setLocationRelativeTo(component);
            jDialog.addWindowListener(new WindowAdapter(this){
                boolean gotFocus;
                private final /* synthetic */ ProgressOptionPane this$1;

                public void windowActivated(WindowEvent windowEvent) {
                    if (!this.gotFocus) {
                        this.this$1.selectInitialValue();
                        this.gotFocus = true;
                    }
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setValue(ProgressMonitor.access$000(ProgressOptionPane.access$100(this.this$1))[0]);
                }
                {
                    this.this$1 = progressOptionPane;
                    this.gotFocus = false;
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(this, jDialog){
                private final /* synthetic */ JDialog val$dialog;
                private final /* synthetic */ ProgressOptionPane this$1;

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (this.val$dialog.isVisible() && propertyChangeEvent.getSource() == this.this$1 && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                        this.val$dialog.setVisible(false);
                        this.val$dialog.dispose();
                    }
                }
                {
                    this.this$1 = progressOptionPane;
                    this.val$dialog = jDialog;
                }
            });
            return jDialog;
        }
    }
}

