/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class AbstractTableModel
implements TableModel,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableCellUpdated(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n2, n3));
    }

    public void fireTableRowsDeleted(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, -1, -1));
    }

    public void fireTableRowsInserted(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, -1, 1));
    }

    public void fireTableRowsUpdated(int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, -1, 0));
    }

    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    public Class getColumnClass(int n2) {
        return Object.class;
    }

    public void setValueAt(Object object, int n2, int n3) {
    }

    public String getColumnName(int n2) {
        String string = "";
        while (n2 >= 0) {
            string = (char)((char)(n2 % 26) + 65) + string;
            n2 = n2 / 26 - 1;
        }
        return string;
    }

    public int findColumn(String string) {
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            if (!string.equals(this.getColumnName(i2))) continue;
            return i2;
        }
        return -1;
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$TableModelListener == null ? AbstractTableModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)objectArray[i2 + 1]).tableChanged(tableModelEvent);
        }
    }

    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

