/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputSubset;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.awt.im.InputMethodAdapter;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WInputMethodDescriptor;
import sun.awt.windows.WToolkit;

public class WInputMethod
extends InputMethodAdapter {
    private InputMethodContext inputContext;
    private Component awtFocussedComponent;
    private WComponentPeer awtFocussedComponentPeer;
    private boolean isActive;
    private int context = this.createNativeContext();
    private boolean open;
    private int cmode = this.getConversionStatus(this.context);
    private Locale currentLocale;
    public static final byte ATTR_INPUT = 0;
    public static final byte ATTR_TARGET_CONVERTED = 1;
    public static final byte ATTR_CONVERTED = 2;
    public static final byte ATTR_TARGET_NOTCONVERTED = 3;
    public static final byte ATTR_INPUT_ERROR = 4;
    public static final int IME_CMODE_ALPHANUMERIC = 0;
    public static final int IME_CMODE_NATIVE = 1;
    public static final int IME_CMODE_KATAKANA = 2;
    public static final int IME_CMODE_LANGUAGE = 3;
    public static final int IME_CMODE_FULLSHAPE = 8;
    public static final int IME_CMODE_HANJACONVERT = 64;
    public static final int IME_CMODE_ROMAN = 16;
    private static final boolean COMMIT_INPUT = true;
    private static final boolean DISCARD_INPUT = false;
    private static Map[] highlightStyles;

    private native int createNativeContext();

    static {
        Map[] mapArray = new Map[4];
        HashMap hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(4);
        Color color = new Color(0, 0, 128);
        hashMap.put(TextAttribute.FOREGROUND, color);
        hashMap.put(TextAttribute.BACKGROUND, Color.white);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        highlightStyles = mapArray;
    }

    public WInputMethod() {
        this.open = this.getOpenStatus(this.context);
        this.currentLocale = WInputMethod.getNativeLocale();
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
    }

    public void activate() {
        if (this.awtFocussedComponentPeer != null) {
            this.enableNativeIME(this.awtFocussedComponentPeer, this.context, !this.haveActiveClient());
        }
        this.isActive = true;
        if (this.currentLocale != null) {
            this.setLocale(this.currentLocale, true);
        }
    }

    public final void dispose() {
    }

    public void endComposition() {
        this.endCompositionNative(this.context, this.haveActiveClient());
    }

    protected void finalize() throws Throwable {
        if (this.context != 0) {
            this.destroyNativeContext(this.context);
            this.context = 0;
        }
        super.finalize();
    }

    public void hideWindows() {
        if (this.awtFocussedComponentPeer != null) {
            this.hideWindowsNative(this.awtFocussedComponentPeer);
        }
    }

    public void inquireCandidatePosition() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int n2 = 0;
                int n3 = 0;
                Component component = WInputMethod.this.getClientComponent();
                if (component != null) {
                    if (WInputMethod.this.haveActiveClient()) {
                        Rectangle rectangle = WInputMethod.this.inputContext.getTextLocation(TextHitInfo.leading(0));
                        n2 = rectangle.x;
                        n3 = rectangle.y + rectangle.height;
                    } else {
                        Point point = component.getLocationOnScreen();
                        Dimension dimension = component.getSize();
                        n2 = point.x;
                        n3 = point.y + dimension.height;
                    }
                }
                WInputMethod.this.openCandidateWindow(WInputMethod.this.awtFocussedComponentPeer, n2, n3);
            }
        });
    }

    public void removeNotify() {
        this.endCompositionNative(this.context, false);
        this.awtFocussedComponent = null;
        this.awtFocussedComponentPeer = null;
    }

    public boolean isCompositionEnabled() {
        return this.getOpenStatus(this.context);
    }

    protected boolean supportsBelowTheSpot() {
        return true;
    }

    private native int getConversionStatus(int var1);

    private native void destroyNativeContext(int var1);

    private native boolean getOpenStatus(int var1);

    private native void setConversionStatus(int var1, int var2);

    private native void endCompositionNative(int var1, boolean var2);

    private native void setOpenStatus(int var1, boolean var2);

    public void deactivate(boolean bl2) {
        this.getLocale();
        if (this.awtFocussedComponentPeer != null) {
            this.disableNativeIME(this.awtFocussedComponentPeer);
        }
        this.isActive = false;
    }

    public void setCompositionEnabled(boolean bl2) {
        this.setOpenStatus(this.context, bl2);
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        Component component;
        if (aWTEvent instanceof ComponentEvent && (component = ((ComponentEvent)aWTEvent).getComponent()) == this.awtFocussedComponent) {
            if (this.awtFocussedComponentPeer.isDisposed()) {
                this.awtFocussedComponentPeer = this.getNearestNativePeer(component);
            }
            if (this.awtFocussedComponentPeer != null) {
                this.handleNativeIMEEvent(this.awtFocussedComponentPeer, aWTEvent);
            }
        }
    }

    protected void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        WComponentPeer wComponentPeer = this.getNearestNativePeer(component);
        if (this.isActive) {
            if (this.awtFocussedComponentPeer != null) {
                this.disableNativeIME(this.awtFocussedComponentPeer);
            }
            if (wComponentPeer != null) {
                this.enableNativeIME(wComponentPeer, this.context, !this.haveActiveClient());
            }
        }
        this.awtFocussedComponent = component;
        this.awtFocussedComponentPeer = wComponentPeer;
    }

    public synchronized void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.inputContext = inputMethodContext;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        if (subsetArray == null) {
            this.setConversionStatus(this.context, this.cmode);
            this.setOpenStatus(this.context, this.open);
            return;
        }
        Character.Subset subset = subsetArray[0];
        Locale locale = WInputMethod.getNativeLocale();
        if (locale == null) {
            return;
        }
        if (locale.getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else {
                int n2;
                if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.KANJI || subset == Character.UnicodeBlock.HIRAGANA) {
                    n2 = 9;
                } else if (subset == Character.UnicodeBlock.KATAKANA) {
                    n2 = 11;
                } else if (subset == InputSubset.HALFWIDTH_KATAKANA) {
                    n2 = 3;
                } else if (subset == InputSubset.FULLWIDTH_LATIN) {
                    n2 = 8;
                } else {
                    return;
                }
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, n2 |= this.getConversionStatus(this.context) & 0x10);
            }
        } else if (locale.getLanguage().equals(Locale.KOREAN.getLanguage())) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else {
                int n3;
                if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.HANJA || subset == Character.UnicodeBlock.HANGUL_SYLLABLES || subset == Character.UnicodeBlock.HANGUL_JAMO || subset == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO) {
                    n3 = 1;
                } else if (subset == InputSubset.FULLWIDTH_LATIN) {
                    n3 = 8;
                } else {
                    return;
                }
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, n3);
            }
        } else if (locale.getLanguage().equals(Locale.CHINESE.getLanguage())) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else {
                int n4;
                if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.TRADITIONAL_HANZI || subset == InputSubset.SIMPLIFIED_HANZI) {
                    n4 = 1;
                } else if (subset == InputSubset.FULLWIDTH_LATIN) {
                    n4 = 8;
                } else {
                    return;
                }
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, n4);
            }
        }
    }

    public Object getControlObject() {
        return null;
    }

    static native boolean setNativeLocale(String var0, boolean var1);

    public Locale getLocale() {
        if (this.isActive) {
            this.currentLocale = WInputMethod.getNativeLocale();
            if (this.currentLocale == null) {
                this.currentLocale = Locale.getDefault();
            }
        }
        return this.currentLocale;
    }

    static native Locale getNativeLocale();

    public boolean setLocale(Locale locale) {
        return this.setLocale(locale, false);
    }

    private boolean setLocale(Locale locale, boolean bl2) {
        Locale[] localeArray = WInputMethodDescriptor.getAvailableLocalesInternal();
        for (int i2 = 0; i2 < localeArray.length; ++i2) {
            Locale locale2 = localeArray[i2];
            if (!locale.equals(locale2) && (!locale2.equals(Locale.JAPAN) || !locale.equals(Locale.JAPANESE)) && (!locale2.equals(Locale.KOREA) || !locale.equals(Locale.KOREAN))) continue;
            if (this.isActive) {
                WInputMethod.setNativeLocale(locale2.toString(), bl2);
            }
            this.currentLocale = locale2;
            return true;
        }
        return false;
    }

    private native void disableNativeIME(WComponentPeer var1);

    private native void hideWindowsNative(WComponentPeer var1);

    private native void openCandidateWindow(WComponentPeer var1, int var2, int var3);

    private native void enableNativeIME(WComponentPeer var1, int var2, boolean var3);

    private native void handleNativeIMEEvent(WComponentPeer var1, AWTEvent var2);

    public void sendInputMethodEvent(int n2, long l2, String string, int[] nArray, String[] stringArray, int[] nArray2, byte[] byArray, int n3, int n4, int n5) {
        Object object;
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (string != null) {
            int n6;
            object = new AttributedString(string);
            ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.LANGUAGE, Locale.getDefault(), 0, string.length());
            if (nArray != null && stringArray != null && stringArray.length != 0 && nArray.length == stringArray.length + 1 && nArray[0] == 0 && nArray[stringArray.length] == string.length()) {
                for (n6 = 0; n6 < nArray.length - 1; ++n6) {
                    ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.INPUT_METHOD_SEGMENT, new Annotation(null), nArray[n6], nArray[n6 + 1]);
                    ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.READING, new Annotation(stringArray[n6]), nArray[n6], nArray[n6 + 1]);
                }
            } else {
                ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.INPUT_METHOD_SEGMENT, new Annotation(null), 0, string.length());
                ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.READING, new Annotation(new String("")), 0, string.length());
            }
            if (nArray2 != null && byArray != null && byArray.length != 0 && nArray2.length == byArray.length + 1 && nArray2[0] == 0 && nArray2[byArray.length] == string.length()) {
                for (n6 = 0; n6 < nArray2.length - 1; ++n6) {
                    InputMethodHighlight inputMethodHighlight;
                    switch (byArray[n6]) {
                        default: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 1: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 2: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 3: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                        }
                    }
                    ((AttributedString)object).addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, nArray2[n6], nArray2[n6 + 1]);
                }
            } else {
                ((AttributedString)object).addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT, 0, string.length());
            }
            attributedCharacterIterator = ((AttributedString)object).getIterator();
        }
        if ((object = this.getClientComponent()) == null) {
            return;
        }
        InputMethodEvent inputMethodEvent = new InputMethodEvent((Component)object, n2, l2, attributedCharacterIterator, n3, TextHitInfo.leading(n4), TextHitInfo.leading(n5));
        WToolkit.postEvent(WToolkit.targetToAppContext(object), inputMethodEvent);
    }

    static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n2;
        int n3 = inputMethodHighlight.getState();
        if (n3 == 0) {
            n2 = 0;
        } else if (n3 == 1) {
            n2 = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n2;
        }
        return highlightStyles[n2];
    }

    private WComponentPeer getNearestNativePeer(Component component) {
        if (component == null) {
            return null;
        }
        ComponentPeer componentPeer = component.getPeer();
        if (componentPeer == null) {
            return null;
        }
        while (componentPeer instanceof LightweightPeer) {
            if ((component = component.getParent()) == null) {
                return null;
            }
            componentPeer = component.getPeer();
            if (componentPeer != null) continue;
            return null;
        }
        if (componentPeer instanceof WComponentPeer) {
            return (WComponentPeer)componentPeer;
        }
        return null;
    }
}

