/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc.ee;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.ee.ConnectionPoolFactory;
import sun.jdbc.odbc.ee.PoolProperties;
import sun.jdbc.odbc.ee.PoolWorker;
import sun.jdbc.odbc.ee.PooledObject;

public abstract class ObjectPool {
    private int initialSize;
    private int maxSize;
    private int minSize;
    private int maxIdleTime;
    private int timeoutFromPool;
    private int mInterval;
    private int currentSize = 0;
    private String name;
    private Hashtable freePool;
    private Hashtable lockedObjects;
    private Hashtable garbagePool;
    private PoolWorker worker;
    private JdbcOdbcTracer tracer = new JdbcOdbcTracer();
    private boolean usable = true;
    private boolean initialized = false;
    private String errorMessage;

    public int getCurrentSize() {
        return this.currentSize;
    }

    public int getMaintenanceInterval() {
        return this.mInterval;
    }

    public void initializePool() throws SQLException {
        this.tracer.trace("Setting the properties in Pool");
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.fillThePool(this.initialSize);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintain() throws SQLException {
        Object object;
        this.tracer.trace("Before <maintenance> Locked :" + this.lockedObjects.size() + " free :" + this.freePool.size() + "garbage :" + this.garbagePool.size() + "current size :" + this.currentSize);
        Enumeration enumeration = this.garbagePool.keys();
        while (enumeration.hasMoreElements()) {
            object = (PooledObject)enumeration.nextElement();
            this.destroyFromPool((PooledObject)object, this.garbagePool);
        }
        object = this;
        synchronized (object) {
            Enumeration enumeration2 = this.freePool.keys();
            while (enumeration2.hasMoreElements()) {
                PooledObject pooledObject = (PooledObject)enumeration2.nextElement();
                this.checkAndMark(pooledObject);
            }
        }
        this.fillThePool(this.minSize);
        this.tracer.trace("Before <maintenance> Locked :" + this.lockedObjects.size() + " free :" + this.freePool.size() + "garbage :" + this.garbagePool.size() + "current size :" + this.currentSize);
    }

    private synchronized void shutDownNow() {
        try {
            PooledObject pooledObject;
            this.tracer.trace("Shutting down the pool");
            ConnectionPoolFactory.removePool(this.name);
            Enumeration enumeration = this.garbagePool.keys();
            while (enumeration.hasMoreElements()) {
                pooledObject = (PooledObject)enumeration.nextElement();
                this.destroyFromPool(pooledObject, this.garbagePool);
            }
            enumeration = this.freePool.keys();
            while (enumeration.hasMoreElements()) {
                pooledObject = (PooledObject)enumeration.nextElement();
                this.destroyFromPool(pooledObject, this.freePool);
            }
            enumeration = this.lockedObjects.keys();
            while (enumeration.hasMoreElements()) {
                pooledObject = (PooledObject)enumeration.nextElement();
                this.destroyFromPool(pooledObject, this.lockedObjects);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.tracer.trace("An error occurred while shutting down " + exception);
        }
    }

    protected void fillThePool(int n2) throws SQLException {
        this.tracer.trace("fillThePool: Filling the pool upto :" + n2 + "from :" + this.currentSize);
        if (!this.usable) {
            this.tracer.trace("The pool is marked non usable. Not filling the pool");
            return;
        }
        try {
            while (this.currentSize < n2) {
                this.addNew(this.createObject());
            }
        }
        catch (Exception exception) {
            this.tracer.trace("fillThePool: Exception thrown in filling." + exception.getMessage());
            throw new SQLException(exception.getMessage());
        }
    }

    public void shutDown(boolean bl2) {
        if (bl2) {
            this.worker.release();
            this.shutDownNow();
        } else {
            this.markError("Being shut down now");
        }
    }

    public String getName() {
        return this.name;
    }

    public ObjectPool(String string) {
        this.name = string;
        this.worker = new PoolWorker(this);
        this.freePool = new Hashtable();
        this.lockedObjects = new Hashtable();
        this.garbagePool = new Hashtable();
    }

    public void markError(String string) {
        this.usable = false;
        this.errorMessage = string;
    }

    public JdbcOdbcTracer getTracer() {
        return this.tracer;
    }

    public void setTracer(JdbcOdbcTracer jdbcOdbcTracer) {
        if (jdbcOdbcTracer != null) {
            this.tracer = jdbcOdbcTracer;
        }
    }

    public void setProperties(PoolProperties poolProperties) throws SQLException {
        this.tracer.trace("Setting the properties in Pool");
        this.initialSize = poolProperties.get("initialPoolSize");
        this.minSize = poolProperties.get("minPoolSize");
        this.maxSize = poolProperties.get("maxPoolSize");
        this.timeoutFromPool = poolProperties.get("timeOutFromPool");
        this.mInterval = poolProperties.get("mInterval");
        this.maxIdleTime = poolProperties.get("maxIdleTime");
        if (this.minSize > this.initialSize) {
            this.initialSize = this.minSize;
            this.tracer.trace("Connection Pool: Initial Size is set to Max Size ");
        }
        if (this.maxSize < this.initialSize && this.maxSize != 0) {
            this.maxSize = this.initialSize;
            this.tracer.trace("Connection Pool: Maximum size is less than Initial size, using the Initial size ");
        }
        if (this.mInterval == 0) {
            throw new SQLException("Maintenance interval cannot be zero");
        }
    }

    public synchronized PooledObject checkOut() throws SQLException {
        PooledObject pooledObject;
        if (!this.usable) {
            throw new SQLException(" Connection Pool: " + this.errorMessage);
        }
        Enumeration enumeration = this.freePool.keys();
        while (enumeration.hasMoreElements()) {
            pooledObject = (PooledObject)enumeration.nextElement();
            if (this.checkAndMark(pooledObject) || !this.freePool.containsKey(pooledObject)) continue;
            this.lockedObjects.put(pooledObject, "");
            this.freePool.remove(pooledObject);
            pooledObject.checkedOut();
            return pooledObject;
        }
        if (this.currentSize < this.maxSize || this.maxSize == 0) {
            pooledObject = this.createObject();
            this.lockedObjects.put(pooledObject, "");
            pooledObject.checkedOut();
            return pooledObject;
        }
        throw new SQLException("Maximum limit has reached and no connection is free");
    }

    protected PooledObject createObject() throws SQLException {
        return this.createObject(null);
    }

    protected synchronized void addNew(PooledObject pooledObject) {
        this.freePool.put(pooledObject, new Long(System.currentTimeMillis()));
    }

    public synchronized void checkIn(PooledObject pooledObject) {
        boolean bl2 = false;
        if (pooledObject.getCreatedTime() + (long)(this.timeoutFromPool * 1000) < System.currentTimeMillis() && this.timeoutFromPool != 0) {
            bl2 = true;
        }
        if (bl2 || !pooledObject.isUsable()) {
            pooledObject.markForSweep();
            this.garbagePool.put(pooledObject, "");
            this.lockedObjects.remove(pooledObject);
        } else {
            pooledObject.checkedIn();
            this.freePool.put(pooledObject, new Long(System.currentTimeMillis()));
            this.lockedObjects.remove(pooledObject);
        }
    }

    public synchronized void tryCheckOut(PooledObject pooledObject) throws SQLException {
        if (this.checkAndMark(pooledObject) || !this.freePool.containsKey(pooledObject)) {
            throw new SQLException("Object is not available for use" + this.freePool.containsKey(pooledObject));
        }
        this.lockedObjects.put(pooledObject, "");
        this.freePool.remove(pooledObject);
        pooledObject.checkedOut();
    }

    protected boolean checkAndMark(PooledObject pooledObject) {
        if (this.freePool.containsKey(pooledObject)) {
            long l2 = (Long)this.freePool.get(pooledObject);
            boolean bl2 = false;
            boolean bl3 = false;
            if (pooledObject.getCreatedTime() + (long)(this.timeoutFromPool * 1000) < System.currentTimeMillis() && this.timeoutFromPool != 0) {
                bl2 = true;
            }
            if (l2 + (long)(this.maxIdleTime * 1000) < System.currentTimeMillis() && this.maxIdleTime != 0) {
                bl3 = true;
            }
            if (bl2 || bl3 || !pooledObject.isUsable()) {
                pooledObject.markForSweep();
                this.garbagePool.put(pooledObject, "");
                this.freePool.remove(pooledObject);
                return true;
            }
            if (pooledObject.isMarkedForSweep()) {
                this.garbagePool.put(pooledObject, "");
                this.freePool.remove(pooledObject);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void destroyFromPool(PooledObject pooledObject, Hashtable hashtable) {
        try {
            pooledObject.destroy();
        }
        catch (Exception exception) {
            this.tracer.trace("Connection Pool : Exception while destroying + e.getMessage()");
        }
        hashtable.remove(pooledObject);
        --this.currentSize;
    }

    public synchronized PooledObject checkOut(Properties properties) throws SQLException {
        PooledObject pooledObject;
        if (!this.usable) {
            throw new SQLException(" Connection Pool: " + this.errorMessage);
        }
        Enumeration enumeration = this.freePool.keys();
        while (enumeration.hasMoreElements()) {
            pooledObject = (PooledObject)enumeration.nextElement();
            if (this.checkAndMark(pooledObject) || !this.freePool.containsKey(pooledObject) || !pooledObject.isMatching(properties)) continue;
            this.lockedObjects.put(pooledObject, "");
            this.freePool.remove(pooledObject);
            pooledObject.checkedOut();
            return pooledObject;
        }
        if (this.currentSize < this.maxSize || this.maxSize == 0) {
            pooledObject = this.createObject(properties);
            this.lockedObjects.put(pooledObject, "");
            pooledObject.checkedOut();
            return pooledObject;
        }
        throw new SQLException("Maximum limit has reached and no connection is free");
    }

    protected abstract PooledObject create(Properties var1) throws SQLException;

    protected synchronized PooledObject createObject(Properties properties) throws SQLException {
        PooledObject pooledObject = this.create(properties);
        ++this.currentSize;
        return pooledObject;
    }
}

