/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.ServiceName;

public class Krb5NameElement
implements GSSNameSpi {
    private PrincipalName krb5PrincipalName;
    private String gssNameStr = null;
    private Oid gssNameType = null;
    private static String CHAR_ENCODING = "UTF-8";

    public boolean isAnonymousName() {
        return this.gssNameType.equals(GSSName.NT_ANONYMOUS);
    }

    public byte[] export() throws GSSException {
        byte[] byArray = null;
        try {
            byArray = this.krb5PrincipalName.getName().getBytes(CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        return this.gssNameStr;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Should be mdu: " + Krb5NameElement.getInstance("mdu", GSSName.NT_USER_NAME));
            System.out.println("Should be nfs@vishwas.eng.sun.com: " + Krb5NameElement.getInstance("nfs@vishwas.eng.sun.com", GSSName.NT_HOSTBASED_SERVICE));
            Krb5NameElement krb5NameElement = Krb5NameElement.getInstance("nfs@vishwas.eng.sun.com", GSSName.NT_HOSTBASED_SERVICE);
            System.out.println("Should be 1.3.6.1.5.6.2: " + krb5NameElement.getStringNameType());
            System.out.println("Should be nfs/vishwas.eng.sun.com@<REALM>: " + krb5NameElement.toString());
            Krb5NameElement krb5NameElement2 = Krb5NameElement.getInstance("mdu", GSSName.NT_USER_NAME);
            Krb5NameElement krb5NameElement3 = Krb5NameElement.getInstance("mdu", GSSName.NT_USER_NAME);
            System.out.println("Should be true: " + krb5NameElement2.equals(krb5NameElement3));
            System.out.println("Should be mdu@<REALM>: " + krb5NameElement2.toString());
            System.out.println(Krb5Token.getHexBytes(krb5NameElement2.export()));
            Krb5NameElement krb5NameElement4 = Krb5NameElement.getInstance(krb5NameElement.toString(), Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
            System.out.println(krb5NameElement4.getGSSNameType() + " " + krb5NameElement4.toString());
            Krb5NameElement krb5NameElement5 = Krb5NameElement.getInstance(krb5NameElement2.toString(), Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
            System.out.println(krb5NameElement5.getGSSNameType() + " " + krb5NameElement5.toString());
            System.out.println("Should be true: " + krb5NameElement4.equals(krb5NameElement));
            System.out.println("Should be true: " + krb5NameElement5.equals(krb5NameElement2));
        }
        catch (GSSException gSSException) {
            System.out.println(gSSException);
        }
    }

    public Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    public Oid getGSSNameType() {
        return this.gssNameType;
    }

    public Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    public Oid getStringNameType() {
        return this.gssNameType;
    }

    public boolean equals(GSSNameSpi gSSNameSpi) throws GSSException {
        if (gSSNameSpi == this) {
            return true;
        }
        if (gSSNameSpi instanceof Krb5NameElement) {
            Krb5NameElement krb5NameElement = (Krb5NameElement)gSSNameSpi;
            return this.krb5PrincipalName.getName().equals(krb5NameElement.krb5PrincipalName.getName());
        }
        return false;
    }

    public final PrincipalName getKrb5PrincipalName() {
        return this.krb5PrincipalName;
    }

    private static String[] getComponents(String string) throws GSSException {
        String[] stringArray;
        int n2 = string.lastIndexOf(64, string.length());
        if (n2 > 0 && string.charAt(n2 - 1) == '\\' && (n2 - 2 < 0 || string.charAt(n2 - 2) != '\\')) {
            n2 = -1;
        }
        if (n2 > 0) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            stringArray = new String[]{string2, string3};
        } else {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    static Krb5NameElement getInstance(PrincipalName principalName) {
        return new Krb5NameElement(principalName, principalName.getName(), Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
    }

    private static String getHostBasedInstance(String string, String string2) throws GSSException {
        StringBuffer stringBuffer = new StringBuffer(string);
        try {
            if (string2 == null) {
                string2 = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        string2 = string2.toLowerCase();
        stringBuffer = stringBuffer.append('/').append(string2);
        return stringBuffer.toString();
    }

    private Krb5NameElement(PrincipalName principalName, String string, Oid oid) {
        this.krb5PrincipalName = principalName;
        this.gssNameStr = string;
        this.gssNameType = oid;
    }

    static Krb5NameElement getInstance(String string, Oid oid) throws GSSException {
        PrincipalName principalName;
        if (oid == null) {
            oid = Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL;
        } else if (!(oid.equals(GSSName.NT_USER_NAME) || oid.equals(GSSName.NT_HOSTBASED_SERVICE) || oid.equals(Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL) || oid.equals(GSSName.NT_EXPORT_NAME))) {
            throw new GSSException(4, -1, oid.toString() + " is an unsupported nametype");
        }
        try {
            if (oid.equals(GSSName.NT_EXPORT_NAME) || oid.equals(Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL)) {
                principalName = new PrincipalName(string, 1);
            } else {
                String[] stringArray = Krb5NameElement.getComponents(string);
                if (oid.equals(GSSName.NT_USER_NAME)) {
                    principalName = new PrincipalName(string, 1);
                } else {
                    String string2 = null;
                    String string3 = stringArray[0];
                    if (stringArray.length >= 2) {
                        string2 = stringArray[1];
                    }
                    String string4 = Krb5NameElement.getHostBasedInstance(string3, string2);
                    principalName = new ServiceName(string4, 3);
                }
            }
        }
        catch (KrbException krbException) {
            throw new GSSException(3, -1, krbException.getMessage());
        }
        return new Krb5NameElement(principalName, string, oid);
    }
}

