
drop table if exists STUDENT;

drop table if exists SCORE;

drop table if exists SALES;

drop table if exists CLASSINFO;

drop table if exists BLVLSALE;

/*==============================================================*/
/* Table: BLVLSALE                                              */
/*==============================================================*/
create table if not exists BLVLSALE
(
   SALEWEEK                       datetime                       not null,
   DATATYPE                       varchar(40)                    not null,
   VALUE                          decimal(5,2),
   primary key (SALEWEEK, DATATYPE)
);

/*==============================================================*/
/* Table: CLASSINFO                                             */
/*==============================================================*/
create table if not exists CLASSINFO
(
   CLASSID                        varchar(10)                    not null,
   CLASSNAME                      varchar(100)                   not null,
   TEACHER                        varchar(20)                    not null,
   CLASSROOM                      varchar(100),
   REMARK                         varchar(255),
   primary key (CLASSID)
);

/*==============================================================*/
/* Table: SALES                                                 */
/*==============================================================*/
create table if not exists SALES
(
   sale_no                        decimal(4)                     not null,
   sale_region                    decimal(4)                     not null,
   sale_company                   decimal(4)                     not null,
   sale_goods                     decimal(4)                     not null,
   sale_date                      datetime                       not null,
   sale_amount                    decimal(18,2)                  not null,
   sale_sale                      decimal(18,2)                  not null,
   primary key (sale_no)
);

/*==============================================================*/
/* Table: SCORE                                                 */
/*==============================================================*/
create table if not exists SCORE
(
   CLASSID                        varchar(10)                    not null,
   STUDENTID                      decimal(4)                     not null,
   SUBJECT                        decimal(4)                     not null,
   SCORE                          decimal(3,1)                   not null,
   primary key (CLASSID, STUDENTID, SUBJECT)
);

/*==============================================================*/
/* Table: STUDENT                                               */
/*==============================================================*/
create table if not exists STUDENT
(
   CLASSID                        varchar(10)                    not null,
   STUDENTID                      decimal(4)                     not null,
   NAME                           varchar(20)                    not null,
   SEX                            decimal(4)                     not null,
   AGE                            decimal(4)                     not null,
   DRESS                          varchar(100),
   TEL                            varchar(10),
   POST                           decimal(4),
   PHOTO                          longblob,
   REMARK                         varchar(100),
   primary key (CLASSID, STUDENTID)
);

