
drop table STUDENT cascade constraints
/


drop table SCORE cascade constraints
/


drop table SALES cascade constraints
/


drop table CLASSINFO cascade constraints
/


drop table BLVLSALE cascade constraints
/


/*==============================================================*/
/* Table: BLVLSALE                                              */
/*==============================================================*/


create table BLVLSALE  (
   SALEWEEK             DATE                             not null,
   DATATYPE             VARCHAR2(40)                     not null,
   VALUE                NUMBER(5,2),
   constraint PK_BLVLSALE primary key (SALEWEEK, DATATYPE)
)
/


/*==============================================================*/
/* Table: CLASSINFO                                             */
/*==============================================================*/


create table CLASSINFO  (
   CLASSID              VARCHAR2(10)                     not null,
   CLASSNAME            VARCHAR2(100)                    not null,
   TEACHER              VARCHAR2(20)                     not null,
   CLASSROOM            VARCHAR2(100),
   REMARK               VARCHAR2(255),
   constraint PK_CLASSINFO primary key (CLASSID)
)
/


/*==============================================================*/
/* Table: SALES                                                 */
/*==============================================================*/


create table SALES  (
   sale_no              NUMBER(4)                        not null,
   sale_region          NUMBER(4)                        not null,
   sale_company         NUMBER(4)                        not null,
   sale_goods           NUMBER(4)                        not null,
   sale_date            DATE                             not null,
   sale_amount          NUMBER(18,2)                     not null,
   sale_sale            NUMBER(18,2)                     not null,
   constraint PK_SALES primary key (sale_no)
)
/


/*==============================================================*/
/* Table: SCORE                                                 */
/*==============================================================*/


create table SCORE  (
   CLASSID              VARCHAR2(10)                     not null,
   STUDENTID            NUMBER(4)                        not null,
   SUBJECT              NUMBER(4)                        not null,
   SCORE                NUMBER(3,1)                      not null,
   constraint PK_SCORE primary key (CLASSID, STUDENTID, SUBJECT)
)
/


/*==============================================================*/
/* Table: STUDENT                                               */
/*==============================================================*/


create table STUDENT  (
   CLASSID              VARCHAR2(10)                     not null,
   STUDENTID            NUMBER(4)                        not null,
   NAME                 VARCHAR2(20)                     not null,
   SEX                  NUMBER(4)                        not null,
   AGE                  NUMBER(4)                        not null,
   DRESS                VARCHAR2(100),
   TEL                  VARCHAR2(10),
   POST                 NUMBER(4),
   PHOTO                BLOB,
   REMARK               VARCHAR2(100),
   constraint PK_STUDENT primary key (CLASSID, STUDENTID)
)
/
