Attribute VB_Name = "GetUsers"
Option Explicit


Private Const ERROR_SUCCESS As Long = 0&
Private Const MAX_COMPUTERNAME As Long = 15
'Private Const MAX_USERNAME As Long = 256
Private Const FILTER_NORMAL_ACCOUNT  As Long = &H2


   
Private Declare Function NetUserEnum Lib "Netapi32" _
  (servername As Byte, _
   ByVal level As Long, _
   ByVal filter As Long, _
   buff As Long, _
   ByVal buffsize As Long, _
   entriesread As Long, _
   totalentries As Long, _
   resumehandle As Long) As Long
   
Private Declare Function NetApiBufferFree Lib "Netapi32" _
  (ByVal Buffer As Long) As Long

'Private Declare Function GetUserName Lib "advapi32" _
   Alias "GetUserNameA" _
  (ByVal lpBuffer As String, _
   nSize As Long) As Long
   
Private Declare Function GetComputerName Lib "Kernel32" _
   Alias "GetComputerNameA" _
  (ByVal lpBuffer As String, _
   nSize As Long) As Long

Private Declare Sub CopyMemory Lib "Kernel32" _
   Alias "RtlMoveMemory" _
  (xDest As Any, _
   xSource As Any, _
   ByVal nBytes As Long)

Private Declare Function lstrlenW Lib "Kernel32" _
  (ByVal lpString As Long) As Long

Private Declare Function StrLen Lib "Kernel32" _
   Alias "lstrlenW" _
  (ByVal lpString As Long) As Long





Public Function GetUserEnumInfo() As String()
  
   Dim users() As Long
   Dim buff As Long
   Dim buffsize As Long
   Dim entriesread As Long
   Dim totalentries As Long
   Dim cnt As Integer
   Dim u() As String
   Dim tmp As String
   Dim bServername() As Byte
   
   tmp = GetComputersName()
   If Len(tmp) Then
      If InStr(tmp, "\\") Then
         bServername = tmp & Chr$(0)
      Else
         bServername = "\\" & tmp & Chr$(0)
      End If
   End If
   
   
   buffsize = 255
   
   If NetUserEnum(bServername(0), 0, _
                   FILTER_NORMAL_ACCOUNT, _
                   buff, buffsize, _
                   entriesread, _
                   totalentries, 0&) = ERROR_SUCCESS Then
   
      ReDim users(0 To entriesread - 1) As Long
      ReDim u(0 To entriesread - 1) As String
      CopyMemory users(0), ByVal buff, entriesread * 4
      
      For cnt = 0 To entriesread - 1
         u(cnt) = GetPointerToByteStringW(users(cnt))
      Next cnt
      
      GetUserEnumInfo = u
      
      NetApiBufferFree buff
   
   End If

End Function


Public Function GetComputersName() As String

  'returns the name of the computer
   Dim tmp As String
   
   tmp = Space$(MAX_COMPUTERNAME + 1)
    
   If GetComputerName(tmp, Len(tmp)) <> 0 Then
      GetComputersName = TrimNull(tmp)
   End If
   
End Function


Private Function TrimNull(item As String)

   Dim pos As Integer
   
   pos = InStr(item, Chr$(0))
   
   If pos Then
      TrimNull = Left$(item, pos - 1)
   Else
      TrimNull = item
   End If
   
End Function





Private Function GetPointerToByteStringW(lpString As Long) As String
  
   Dim buff() As Byte
   Dim nSize As Long
   
   If lpString Then
   
     'its Unicode, so mult. by 2
      nSize = lstrlenW(lpString) * 2
      
      If nSize Then
         ReDim buff(0 To (nSize - 1)) As Byte
         CopyMemory buff(0), ByVal lpString, nSize
         GetPointerToByteStringW = buff
     End If
     
   End If
   
End Function







