local assets =
{
    Asset("ANIM", "anim/aiersa.zip"),
    Asset("ANIM", "anim/swap_aiersa.zip"),
}

local prefabs =
{
    "nightstickfire",
    "sparks",
}
--拿起
local function onequip_aiersa(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_aiersa", "aiersa")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    owner.components.combat.min_attack_period = .5
end
--放下
local function onunequip(inst, owner)
    owner.components.combat.min_attack_period = TUNING.WILSON_ATTACK_PERIOD
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
--拿起
local function onequip_war(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_aiersa", "aiersa")
    owner.components.combat.min_attack_period = 1
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
--放下
local function onunequip_war(inst, owner)
    owner.components.combat.min_attack_period = TUNING.WILSON_ATTACK_PERIOD
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function onequip_bluekwaithoth(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_aiersa", "aiersa")
    owner.components.combat.min_attack_period = 1
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
--放下
local function onunequip_bluekwaithoth(inst, owner)
    owner.components.combat.min_attack_period = TUNING.WILSON_ATTACK_PERIOD
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function onequip_eternal(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_aiersa", "aiersa")
    owner.components.combat.min_attack_period = 1
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

    if inst.fire == nil then
        inst.fire = SpawnPrefab("nightstickfire")
        inst.fire.entity:AddFollower()
        inst.fire.Follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 0)
    end
end
--放下
local function onunequip_eternal(inst, owner)
    owner.components.combat.min_attack_period = TUNING.WILSON_ATTACK_PERIOD
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")

    if inst.fire ~= nil then
        inst.fire:Remove()
        inst.fire = nil
    end
end

local function onattack_bluekwaithoth(weapon, attacker, target)
    --if target ~= nil and target.components.burnable ~= nil then
     --   target.components.burnable:Ignite(nil, attacker) --点燃
    --end
    
    local Penalty = math.random(100)
    --print("概率   "..Penalty)
    if Penalty < 20 then
        if target ~= nil and target.components ~= nil and target.components.health ~= nil and target.components.health.currenthealth > 0 then
            local x, y, z = target.Transform:GetWorldPosition()
            SpawnPrefab("sparks").Transform:SetPosition(x, y - .5, z)
            local dam = math.clamp(target.components.health.currenthealth / target.components.health.maxhealth * target.components.health.currenthealth , 5 , 200)
            --print("目标当前生命值"..target.components.health.currenthealth.."       ----额外伤害",dam)
            target.components.health:DoDelta(-dam)
            --print(target.components.health.currenthealth)
        end
    end
    --attacker.components.health:StartRegen(-1,3)
end

local function fn_aiersa()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("aiersa")
    inst.AnimState:SetBuild("aiersa")
    inst.AnimState:PlayAnimation("idle")
	--标签
    inst:AddTag("sharp")
    inst:AddTag("pointy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then	--不是主机
        return inst
    end

    inst:AddComponent("weapon")	--武器
	inst.components.weapon:SetDamage(180)
    --inst.components.weapon.attackrange = 3 --默认 3
    --inst.components.weapon.hitrange = 3 --默认 3
    -------

 --   inst:AddComponent("finiteuses")	--有限使用组件
 --   inst.components.finiteuses:SetMaxUses(TUNING.SPEAR_USES)	--最大使用
 --   inst.components.finiteuses:SetUses(TUNING.SPEAR_USES)	--使用

 --   inst.components.finiteuses:SetOnFinished(inst.Remove)	--消耗完(移除)

    inst:AddComponent("inspectable")	--检查组件

    inst:AddComponent("inventoryitem")	--仓库组件
    inst.components.inventoryitem.imagename = "aiersa"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aiersa.xml"

    inst:AddComponent("equippable")	--装备组件
    inst.components.equippable:SetOnEquip(onequip_aiersa)	--拿起
    inst.components.equippable:SetOnUnequip(onunequip)	--放下
    inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT 
    inst.components.equippable.dapperness = -1 / 60 --TUNING.CRAZINESS_MED  -- -100/(day_time), 每秒

    MakeHauntableLaunch(inst)

    return inst
end

local function fn_war()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.Light:SetFalloff(.5)
    inst.Light:SetIntensity(.8)
    inst.Light:SetRadius(5)--FADE_RADIUS
    inst.Light:SetColour(200/255, 100/255, 170/255)
    inst.Light:Enable(false)
    inst.Light:EnableClientModulation(true)

    inst.AnimState:SetBank("aiersa")
    inst.AnimState:SetBuild("aiersa")
    inst.AnimState:PlayAnimation("idle")
    --标签
    inst:AddTag("sharp")
    inst:AddTag("pointy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then    --不是主机
        return inst
    end

    inst:AddComponent("weapon") --武器
    inst.components.weapon:SetDamage(250)
    inst.components.weapon.attackrange = 3 --默认 3
    inst.components.weapon.hitrange = 3 --默认 3

    --inst:AddComponent("sanityaura")
    --inst.components.sanityaura.aura = -20
    -------

    inst:AddComponent("finiteuses")   --有限使用组件
    inst.components.finiteuses:SetMaxUses(3000)  --最大使用
    inst.components.finiteuses:SetUses(3000) --使用
    inst.components.finiteuses:SetOnFinished(inst.Remove) --消耗完(移除)

    inst:AddComponent("inspectable")    --检查组件

    inst:AddComponent("inventoryitem")  --仓库组件
    inst.components.inventoryitem.imagename = "aiersa"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aiersa.xml"

    inst:AddComponent("equippable") --装备组件
    inst.components.equippable:SetOnEquip(onequip_war)  --拿起
    inst.components.equippable:SetOnUnequip(onunequip_war)  --放下
    inst.components.equippable.dapperness = -1 / 6

    MakeHauntableLaunch(inst)

    return inst
end

local function fn_bluekwaithoth()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("aiersa")
    inst.AnimState:SetBuild("aiersa")
    inst.AnimState:PlayAnimation("idle")
    --标签
    inst:AddTag("sharp")
    inst:AddTag("pointy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then    --不是主机
        return inst
    end

    inst:AddComponent("weapon") --武器
    inst.components.weapon:SetDamage(160)
    inst.components.weapon.attackrange = 3 --默认 3
    inst.components.weapon.hitrange = 3 --默认 3
    inst.components.weapon:SetOnAttack(onattack_bluekwaithoth)

    inst:AddComponent("finiteuses")   --有限使用组件
    inst.components.finiteuses:SetMaxUses(2000)  --最大使用
    inst.components.finiteuses:SetUses(2000) --使用
    inst.components.finiteuses:SetOnFinished(inst.Remove) --消耗完(移除)

    inst:AddComponent("inspectable")    --检查组件

    inst:AddComponent("inventoryitem")  --仓库组件
    inst.components.inventoryitem.imagename = "aiersa"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aiersa.xml"

    inst:AddComponent("equippable") --装备组件
    inst.components.equippable:SetOnEquip(onequip_bluekwaithoth)  --拿起
    inst.components.equippable:SetOnUnequip(onunequip_bluekwaithoth)  --放下
    inst.components.equippable.dapperness = 1 / 30

    MakeHauntableLaunch(inst)

    return inst
end

local function fn_eternal()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("aiersa")
    inst.AnimState:SetBuild("aiersa")
    inst.AnimState:PlayAnimation("idle")
    --标签
    inst:AddTag("sharp")
    inst:AddTag("pointy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then    --不是主机
        return inst
    end

    inst:AddComponent("weapon") --武器
    inst.components.weapon:SetDamage(190)
    inst.components.weapon.attackrange = 2 --默认 3
    inst.components.weapon.hitrange = 2 --默认 3
    inst.components.weapon:SetOnAttack(onattack_bluekwaithoth)
    inst.components.weapon:SetElectric()

--   inst:AddComponent("finiteuses")	--有限使用组件
 --   inst.components.finiteuses:SetMaxUses(TUNING.SPEAR_USES)	--最大使用
 --   inst.components.finiteuses:SetUses(TUNING.SPEAR_USES)	--使用

 --   inst.components.finiteuses:SetOnFinished(inst.Remove)	--消耗完(移除)

    inst:AddComponent("inspectable")    --检查组件

    inst:AddComponent("inventoryitem")  --仓库组件
    inst.components.inventoryitem.imagename = "aiersa"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aiersa.xml"

    inst:AddComponent("equippable") --装备组件
    inst.components.equippable:SetOnEquip(onequip_eternal)  --拿起
    inst.components.equippable:SetOnUnequip(onunequip_eternal)  --放下
    --inst.components.equippable.dapperness = 1 / 30

    MakeHauntableLaunch(inst)

    return inst
end

return  Prefab("aiersa", fn_aiersa, assets),
        Prefab("war", fn_war, assets),
        Prefab("bluekwaithoth", fn_bluekwaithoth, assets),
        Prefab("eternal", fn_eternal, assets)