local assets =
{
    Asset("ANIM", "anim/sword.zip"),
    Asset("ANIM", "anim/swap_sword.zip"),

    Asset("ATLAS", "images/inventoryimages/sword.xml"),
}

local function onequip(inst, owner)     
    owner.AnimState:OverrideSymbol("swap_object", "swap_sword", "aab")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("sword")
	inst.AnimState:SetBuild("sword")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")    
    inst:AddTag("pointy") 

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(50)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sword.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("common/inventory/sword",fn, assets)