local assets =
{
    Asset("ANIM", "anim/sword.zip"),
    Asset("ANIM", "anim/swap_sword.zip"),

    Asset("IMAGE", "images/inventoryimages/sword.tex"),
    Asset("ATLAS", "images/inventoryimages/sword.xml"),
}

local function onHPBuff( inst )
    if inst ~= nil then 
        if inst.components.health ~= nil then
            inst.components.health:StartRegen(2, 1)
        end
    end
end

local function unHPBuff( inst )
    if inst ~= nil then
        if inst.components.health ~= nil then
            inst.components.health:StopRegen()
        end
    end
end

local function onequip(inst, owner)     
    owner.AnimState:OverrideSymbol("swap_object", "swap_sword", "aab")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    onHPBuff(GetPlayer())
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
    unHPBuff(GetPlayer())
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("sword")
	inst.AnimState:SetBuild("sword")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")    
    inst:AddTag("pointy") 

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(52)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "sword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sword.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("common/inventory/swordleve3",fn, assets)