require "behaviours/follow"
require "behaviours/wander"
require "behaviours/faceentity"
require "behaviours/panic"
require "behaviours/chaseandattack"

local TARGET_FOLLOW_DIST = 4
local MAX_FOLLOW_DIST = 4.5

local COMBAT_TOO_CLOSE_DIST = 5                 -- distance for find enitities check
local COMBAT_TOO_CLOSE_DIST_SQ = COMBAT_TOO_CLOSE_DIST * COMBAT_TOO_CLOSE_DIST
local COMBAT_SAFE_TO_WATCH_FROM_DIST = 8        -- will run to this distance and watch if was too close
local COMBAT_SAFE_TO_WATCH_FROM_MAX_DIST = 12   -- combat is quite far away now, better catch up
local COMBAT_SAFE_TO_WATCH_FROM_MAX_DIST_SQ = COMBAT_SAFE_TO_WATCH_FROM_MAX_DIST * COMBAT_SAFE_TO_WATCH_FROM_MAX_DIST
local COMBAT_TIMEOUT = 6

local MAX_PLAYFUL_FIND_DIST = 4
local MAX_PLAYFUL_KEEP_DIST_FROM_OWNER = 6
local MAX_DOMINANTTRAIT_PLAYFUL_FIND_DIST = 6
local MAX_DOMINANTTRAIT_PLAYFUL_KEEP_DIST_FROM_OWNER = 9
local PLAYFUL_OFFSET = 2

local SEE_ITEM_DIST = 10
local SEE_FOOD_DIST = 10
local FIND_FOOD_HUNGER_PERCENT = 0.2
local FIND_FOOD_HUNGER_PERCENT2 = 0.2
local KEEP_WORKING_DIST = 15
local SEE_WORK_DIST = 20

local function GetOwner(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end

local function OwnerIsClose(inst)
    local owner = GetOwner(inst)
    return owner ~= nil and owner:IsNear(inst, MAX_FOLLOW_DIST)
end

local function LoveOwner(inst)
    if inst.sg:HasStateTag("busy") then
        return nil
    end

    local owner = GetOwner(inst)
    return owner ~= nil
        and not owner:HasTag("playerghost")
        and (GetTime() - (inst.sg.mem.prevnuzzletime or 0) > TUNING.CRITTER_NUZZLE_DELAY) 
        and math.random() < 0.05
        and BufferedAction(inst, owner, ACTIONS.NUZZLE)
        or nil
end

local function HasStateTags(inst, tags)
    for k,v in pairs(tags) do
        if inst.sg:HasStateTag(v) then
            return true
        end
    end
end

local function KeepWorkingAction(inst, actiontags)
    return inst.components.follower.leader and inst.components.follower.leader:GetDistanceSqToInst(inst) <= KEEP_WORKING_DIST*KEEP_WORKING_DIST and 
    HasStateTags(inst.components.follower.leader, actiontags)
end

local function StartWorkingCondition(inst, actiontags)
    return inst.components.follower.leader and not inst.pick1 and not inst.working_food and HasStateTags(inst.components.follower.leader, actiontags) and not HasStateTags(inst, actiontags)
end

local function FindObjectToWorkAction(inst, action)
    if inst.sg:HasStateTag("working") then
        return 
    end
    local target = FindEntity(inst.components.follower.leader, SEE_WORK_DIST, function(item) return item.components.workable and item.components.workable.action == action end)
    if target then
        --print(GetTime(), target)
        return BufferedAction(inst, target, action)
    end
end
-------------------------------------------------------------------------------
--  Play With Other Critters

local function PlayWithPlaymate(self)
    self.inst:PushEvent("critterplayful", {target=self.playfultarget})
end

local function FindPlaymate(self)
    local owner = GetOwner(self.inst)

    local is_playful = self.inst.components.crittertraits:IsDominantTrait("playful")
    local max_dist_from_owner = is_playful and MAX_DOMINANTTRAIT_PLAYFUL_KEEP_DIST_FROM_OWNER or MAX_PLAYFUL_KEEP_DIST_FROM_OWNER

    local can_play = self.inst:IsPlayful() and self.inst:IsNear(owner, max_dist_from_owner)

    -- Try to keep the current playmate
    if self.playfultarget ~= nil and self.playfultarget:IsValid() and can_play then
        return true
    end

    local find_dist = is_playful and MAX_DOMINANTTRAIT_PLAYFUL_FIND_DIST or MAX_PLAYFUL_FIND_DIST

    -- Find a new playmate
    self.playfultarget = can_play and
        not owner.components.locomotor:WantsToMoveForward() and
        FindEntity(self.inst, find_dist, 
            function(v)
                return (v.IsPlayful == nil or v:IsPlayful()) and v:IsNear(owner, max_dist_from_owner)
            end, nil, nil, self.inst.playmatetags)
        or nil

    return self.playfultarget ~= nil
end

-------------------------------------------------------------------------------
--  Combat Avoidance

local function _avoidtargetfn(self, target)
    if target == nil or not target:IsValid() then
        return false
    end

    local owner = self.inst.components.follower.leader
    local owner_combat = owner ~= nil and owner.components.combat or nil
    local target_combat = target.components.combat
    if owner_combat == nil or target_combat == nil then
        return false
    elseif target_combat:TargetIs(owner)
        or (target.components.grouptargeter ~= nil and target.components.grouptargeter:IsTargeting(owner)) then
        return true
    end

    local distsq = owner:GetDistanceSqToInst(target)
    if distsq >= COMBAT_SAFE_TO_WATCH_FROM_MAX_DIST_SQ then
        -- Too far
        return false
    elseif distsq < COMBAT_TOO_CLOSE_DIST_SQ and target_combat:HasTarget() then
        -- Too close to any combat
        return true
    end

    -- Is owner in combat with target?
    -- Are owner and target both in any combat?
    local t = GetTime()
    return  (   (owner_combat:IsRecentTarget(target) or target_combat:HasTarget()) and
                math.max(owner_combat.laststartattacktime, owner_combat.lastdoattacktime or 0) + COMBAT_TIMEOUT > t
            ) or
            (   owner_combat.lastattacker == target and
                owner_combat:GetLastAttackedTime() + COMBAT_TIMEOUT > t
            )
end

local function CombatAvoidanceFindEntityCheck(self)
    return function(ent)
            if _avoidtargetfn(self, ent) then
                self.inst:PushEvent("critter_avoidcombat", {avoid=true})
                self.runawayfrom = ent
                return true
            end
            return false
        end
end

local function ValidateCombatAvoidance(self)
    if self.runawayfrom == nil then
        return false
    end

    if not self.runawayfrom:IsValid() then
        self.inst:PushEvent("critter_avoidcombat", {avoid=false})
        self.runawayfrom = nil
        return false
    end

    if not self.inst:IsNear(self.runawayfrom, COMBAT_SAFE_TO_WATCH_FROM_MAX_DIST) then
        return false
    end

    if not _avoidtargetfn(self, self.runawayfrom) then
        self.inst:PushEvent("critter_avoidcombat", {avoid=false})
        self.runawayfrom = nil
        return false
    end

    return true
end

------------
local function IsHungry(inst)
    return inst.components.perishable and inst.components.perishable:GetPercent() < FIND_FOOD_HUNGER_PERCENT
end
local function IsHungry2(inst)
    return inst.components.perishable and inst.components.perishable:GetPercent() < FIND_FOOD_HUNGER_PERCENT2
end
local function Badfeeling(inst)
	return inst.components.perishable and inst.components.perishable:GetPercent() < 0.8
	and inst.feeling and inst.feeling < 20
end
local function Working_yamche(inst)
    return inst.working_food and not inst.item_max_full
end
local function Pick1(inst)
    return inst.pick1 
end

local function CanSeeFood(inst)
    local target = FindEntity(inst, SEE_FOOD_DIST, function(item) return inst.components.eater:CanEat(item) and (not item:HasTag("no_edible")) and (not inst:HasTag("fire")) end)
 
    if target then
        --print("CanSeeFood", inst.name, target.name)
    end
    return target
end
local function FindFoodAction(inst)
    local target = CanSeeFood(inst)
    if target then
        return BufferedAction(inst, target, ACTIONS.EAT)
    end
    end
	
local ValidFoodsToPick_f = { "green_fruit", "berries", "cave_banana", "carrot", "red_cap", "blue_cap", "green_cap",
 ------- 
"corn", "pumpkin", "eggplant", "durian", "pomegranate", "dragonfruit", "cactus_meat", "watermelon", "smallmeat", "smallmeat_dried", "monstermeat", "monstermeat_dried", "humanmeat_dried", "meat", "meat_dried",
 ---cook 
 "dragonpie", "waffles", "ratatouille", "fruitmedley", "monsterlasagna", "frogglebunwich", "pumpkincookie", "pumpkincookie", "honeyham", "meatballs", "wetgoop", "stuffedeggplant", "taffy", "honeynuggets", "turkeydinner", "fishsticks", "jammypreserves", "fishtacos", "butterflymuffin", "perogies", "kabobs", "bonestew", "baconeggs", "mandrakesoup", 
 --"powcake",
  }
 
 local ValidFoodsToPick = { "green_fruit", "berries", "cave_banana", "carrot", "red_cap", "blue_cap", "green_cap", 
 ------- 
 "corn", "pumpkin", "eggplant", "durian", "pomegranate", "dragonfruit", "cactus_meat", "watermelon", "smallmeat", "smallmeat_dried", "monstermeat", "monstermeat_dried", "humanmeat", "humanmeat_dried", "meat", "meat_dried", "cutgrass", "twigs", "cutreeds", 
 
 "coffe_beans_raw", "coffe_beans", "cutwheat", "tee", "tee_g", "tee_m", "tee_s", "tee_r", "tee_r2",
 ---cook 
 "dragonpie", "waffles", "ratatouille", "fruitmedley", "monsterlasagna", "frogglebunwich", "pumpkincookie", "pumpkincookie", "honeyham", "meatballs", "wetgoop", "stuffedeggplant", "taffy", "honeynuggets", "turkeydinner", "fishsticks", "jammypreserves", "fishtacos", "butterflymuffin", "perogies", "kabobs", "bonestew", "baconeggs", "mandrakesoup", 
  --"powcake",
  }

local ValidItems = {
	"arrowm", "arrowm_broken", 
 "goldnugget", "rocks", "cutstone", "nitre", "flint", "thulecite", "thulecite_pieces", "marble", "redgem", "purplegem", "bluegem", "yellowgem", "greengem", "orangegem",    "log", "boards", "cutgrass","dug_berrybush","dug_berrybush2",  "dug_grass", "rope", "twigs", "dug_sapling", "gears", "spidergland", "healingsalve", "mosquitosack", "silk", "spidereggsack", "ash", "poop", "guano", "charcoal", "beefalowool", "cutreeds", "houndstooth", "ice", "stinger", "livinglog", "lightbulb", "slurper_pelt", "honeycomb", "berry_bush",
 "turf_road", "turf_rocky", "turf_forest", "turf_marsh", "turf_grass", "turf_savanna", "turf_dirt", "turf_woodfloor", "turf_carpetfloor", "turf_checkerfloor", "turf_cave", "turf_fungus", "turf_fungus_red", "turf_fungus_green", "turf_sinkhole", "turf_underrock", "turf_mud", 
  "walrus_tusk", "houndstooth", "wormlight_lesser", "wormlight", "nightmarefuel", "manrabbit_tail", "beardhair", "trinket_1", "trinket_2", "trinket_3", "trinket_4", "trinket_5", "trinket_6", "trinket_7",  "trinket_8", "trinket_9", "trinket_10", "trinket_11", "trinket_12",  "coontail", "tentaclespots", "beefalowool", "horn", "feather_robin", "feather_robin_winter", "feather_crow", "feather_canary", "boneshard", "transistor",   "boomerang", "goose_feather", "drumstick", 
  "bearger_fur", "dragon_scales", "furtuft",
  "acorn", "pinecone", "pigskin", "marblebean","steelwool","phlegm","mandrake",
  
  "coffe_beans_raw", "coffe_beans", "cutwheat", "tee", "tee_g", "tee_m", "tee_s", "tee_r", "tee_r2",
  --[["dug_coffebush",]] "dug_tee_tree", "dug_wheat",  
  
 
}
	
local function ItemIsInList(item, list)
    for k,v in pairs(list) do
        if v == item or k == item then
            return true
        end
    end
end

	
local function Item_1(inst)
    local target = FindEntity(inst, SEE_ITEM_DIST, function(item) return (ItemIsInList( item.prefab , ValidItems)) and (not item:HasTag("no_edible")) and (not inst:HasTag("fire")) end)
    if target and not inst.item_max_full then end
    return target
end	
local function Item_2(inst)
    local target = FindEntity(inst, SEE_ITEM_DIST, function(item) return inst.components.eater:CanEat(item) and (not item:HasTag("no_edible")) and (not inst:HasTag("fire")) end)
    if target and not inst.item_max_full then end
    return target
end	

local function Find_Item_1(inst)
    local target = Item_1(inst)
	if target and not inst.item_max_full then
        return BufferedAction(inst,target,ACTIONS.PICKUP)
		end	  end
local function Find_Item_2(inst)
    local target = Item_2(inst)
	if target and not inst.item_max_full then
        return BufferedAction(inst,target,ACTIONS.PICKUP)
		end	  end

		
local function EatFoodAction(inst)

    local target = nil

    --[[if inst.sg:HasStateTag("busy") or 
    (inst.components.inventory and inst.components.inventory:IsFull()) or
    math.random() < 0.75 then
        return
    end]]

    if inst.components.container and inst.components.eater then
		
        target = inst.components.container:FindItem(function(item) return inst.components.eater:CanEat(item) end)
	
		if inst.components.container and inst.components.container:IsFull() then
			--inst.components.container:DropEverything()  
		end
	
        if target then return BufferedAction(inst,target,ACTIONS.EAT) end
    end

    local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, SEE_FOOD_DIST)  

    if not target then
        for k,item in pairs(ents) do
            if item.components.pickable and item.components.pickable.caninteractwith and item.components.pickable:CanBePicked()
            and (ItemIsInList(item.components.pickable.product, ValidFoodsToPick_f) or item.prefab == "worm") and (not item:HasTag("no_edible")) and (not inst:HasTag("fire")) then
                target = item
                break
            end
        end
    end

    if target then
        return BufferedAction(inst, target, ACTIONS.PICK)
    end

      if not target then
        for k,item in pairs(ents) do
            if item.components.crop and item.components.crop:IsReadyForHarvest() then
                target = item
                break
            end
        end
    end

    if target then
        return BufferedAction(inst, target, ACTIONS.HARVEST)
    end

    --[[if inst.components.combat.target then
        return
    end]]
    end

	
local function Working_food(inst)

     local target = nil
    if target and inst.working_food then
        return BufferedAction(inst, target, ACTIONS.PICKUP)
    end
    	
      local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, SEE_FOOD_DIST)  

      if not target then
        for k,item in pairs(ents) do
            if item.components.pickable and item.components.pickable.caninteractwith and item.components.pickable:CanBePicked()
            and (ItemIsInList(item.components.pickable.product, ValidFoodsToPick) or item.prefab == "worm") and (not item:HasTag("no_edible")) and (not inst:HasTag("fire")) then
                target = item
                break
            end  end  end

    if target then
        return BufferedAction(inst, target, ACTIONS.PICK)
    end
    
    if not target then
        for k,item in pairs(ents) do
            if item.components.crop and item.components.crop:IsReadyForHarvest() and (not item:HasTag("no_edible")) and (not inst:HasTag("fire")) then
                target = item
                break
			elseif item.components.dryer and item.components.dryer:IsDone() and (not inst:HasTag("fire")) then
                target = item
				break
			elseif item.components.stewer and item.components.stewer:IsDone() and (not item:HasTag("no_edible")) and (not inst:HasTag("fire")) then
                target = item
				break
				
            end
        end
    end

    if target then
        return BufferedAction(inst, target, ACTIONS.HARVEST)
    end
	
    --[[if inst.components.combat.target then
        return
    end]]
end	
-------------------------------------------------------------------------------
--  Brain

local CritterBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function CritterBrain:OnStart()
    local root =
    PriorityNode({
        WhileNode( function() return self.inst.components.follower.leader end, "Has Owner",
            PriorityNode{
                -- Combat Avoidance
											
				WhileNode( function() return self.inst.components.health.currenthealth >=50 and (self.inst.components.combat and self.inst.components.combat.target and self.inst.components.combat:InCooldown()) end, "Dodge",	RunAway(self.inst, function() return self.inst.components.combat.target end, 3,6) ),	
				WhileNode( function() return self.inst.components.health.currenthealth >=50 and ((self.inst.prefab == "critter_puppy" or self.inst.prefab == "critter_kitten") or self.inst.components.follower.leader.components.health:GetPercent() <= 0.5) end, "AttackMomentarily", ChaseAndAttack(self.inst, 9,12) ),	
					
                PriorityNode{
                    RunAway(self.inst, {tags={"_combat", "_health"}, notags={"wall", "INLIMBO"}, fn=CombatAvoidanceFindEntityCheck(self)}, COMBAT_TOO_CLOSE_DIST, COMBAT_SAFE_TO_WATCH_FROM_DIST),
                    WhileNode( function() return ValidateCombatAvoidance(self) end, "Is Near Combat",
                        FaceEntity(self.inst, GetOwner, KeepFaceTargetFn)),
			                },
				
                WhileNode(function() return FindPlaymate(self) end, "Playful",
                    SequenceNode{
                        WaitNode(6),
                        PriorityNode{
                            Leash(self.inst, function() return self.playfultarget:GetPosition() and nil end, PLAYFUL_OFFSET, PLAYFUL_OFFSET),
                            ActionNode(function() PlayWithPlaymate(self) end),
                            StandStill(self.inst),
                        },
                    }),
		
		WhileNode(function() return StartWorkingCondition(self.inst, {"chopping", "prechop"}) and 
        KeepWorkingAction(self.inst, {"chopping", "prechop"}) end, "keep chopping",
            DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.CHOP) end)),

        WhileNode(function() return StartWorkingCondition(self.inst, {"mining", "premine"}) and 
        KeepWorkingAction(self.inst, {"mining", "premine"}) end, "keep mining",                   
            DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.MINE) end)),  
		
		SequenceNode{
            ConditionNode(function() return IsHungry(self.inst) and CanSeeFood(self.inst) end, "SeesFoodToEat"),
           
            DoAction(self.inst, function() return FindFoodAction(self.inst) end),},
			
		WhileNode(function() return IsHungry2(self.inst) end, "Should Eat",
            DoAction(self.inst, EatFoodAction)),
			
		WhileNode(function() return Badfeeling(self.inst) end, "Should Eat",
            DoAction(self.inst, EatFoodAction)),
			
				SequenceNode{
		ConditionNode(function() return Pick1(self.inst) and Item_2(self.inst) end, "collect item"),
        ParallelNodeAny { WaitNode(0.25),DoAction(self.inst, function(item) return Find_Item_2(self.inst) end),},},			
		SequenceNode{
		ConditionNode(function() return Pick1(self.inst) and Item_1(self.inst) end, "collect item"),
        ParallelNodeAny { WaitNode(0.25),DoAction(self.inst, function(item) return Find_Item_1(self.inst) end),},},
		
		SequenceNode{
		ConditionNode(function() return Working_yamche(self.inst) end, "collect item"),
        ParallelNodeAny { WaitNode(1 + math.random()*2),DoAction(self.inst, function() return Working_food(self.inst) end),},},
					
                Follow(self.inst, function() return self.inst.components.follower.leader end, 0, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
                FailIfRunningDecorator(FaceEntity(self.inst, GetOwner, KeepFaceTargetFn)),
                WhileNode(function() return OwnerIsClose(self.inst) and self.inst:IsAffectionate() end, "Affection",
                    SequenceNode{
                        WaitNode(4),
                        DoAction(self.inst, LoveOwner),
                    }),
                StandStill(self.inst),
            }),

        StandStill(self.inst),
    }, .25)
    self.bt = BT(self.inst, root)
end

return CritterBrain
