require("stategraphs/commonstates")
require("stategraphs/SGcritter_common")

local actionhandlers = 
{
	ActionHandler(ACTIONS.PICKUP, "fastwork"),
    ActionHandler(ACTIONS.PICK, "action"),
    ActionHandler(ACTIONS.HARVEST, "action"),
	ActionHandler(ACTIONS.EAT, "action2"),
	ActionHandler(ACTIONS.CHOP, "chop"),
	ActionHandler(ACTIONS.MINE, "mine"),
}

local events =
{
	SGCritterEvents.OnEat(),
    SGCritterEvents.OnAvoidCombat(),
	SGCritterEvents.OnTraitChanged(),

    CommonHandlers.OnSleepEx(),
    CommonHandlers.OnWakeEx(),
    CommonHandlers.OnLocomote(false,true),
	--EventHandler("attacked", function(inst) if not inst.components.health:IsDead() then inst.sg:GoToState("hit") end end),
	EventHandler("doattack", function(inst) 
	local random_ani = math.random(1, 3)
		if random_ani == 1 then
		inst.sg:GoToState("attack2")
		inst.critical = true
		else
		inst.sg:GoToState("attack")
		end	
	end),
	EventHandler("doaction", 
        function(inst, data) 
            if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
                if data.action == ACTIONS.CHOP then
                    inst.sg:GoToState("chop", data.target)
                end
            end
        end),
	EventHandler("doaction", 
        function(inst, data) 
            if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
                if data.action == ACTIONS.MINE then
                    inst.sg:GoToState("mine", data.target)
                end
            end
        end),
	EventHandler("attacked", function(inst,data)
        if not inst.components.health:IsDead() then
            inst.sg:GoToState("attack2")
        end
    end),
	
}

local states =
{
State{
        name = "attack",
        tags = { "attack" },
        
        onenter = function(inst)
           inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/hiss")
            inst.components.combat:StartAttack()
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("emote_combat_pre")
        end,

        timeline =
        {
            TimeEvent(10 * FRAMES, function(inst)
			inst.AnimState:PlayAnimation("emote_combat_pst")
                inst.components.combat:DoAttack()
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                inst.sg:GoToState("idle")
            end),
        },
    },
State{
        name = "attack2",
        tags = { "attack" },
        
        onenter = function(inst)
           inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/hiss")
            inst.components.combat:StartAttack()
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("emote_combat_loop")
        end,

        timeline =
        {
            TimeEvent(16 * FRAMES, function(inst)
                inst.components.combat:DoAttack()
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                inst.sg:GoToState("idle")
            end),
        },
    },
State{
        name = "fastwork",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
			if inst.components.locomotor ~= nil then
                inst.components.locomotor:StopMoving()
            end
            inst.AnimState:PlayAnimation("emote_combat_pre")
			
			end,
			 timeline=
			{
            TimeEvent(12*FRAMES, function(inst) 
			inst:PerformBufferedAction() 
			inst.AnimState:PlayAnimation("emote_combat_pst")
			inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/scratch_ground")
			end ),
			},
        events=
        {
            EventHandler("animover", function (inst)
                inst.sg:GoToState("idle")
            end),
        }
    },

State{
        name = "action",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
			if inst.components.locomotor ~= nil then
                inst.components.locomotor:StopMoving()
            end
            inst.AnimState:PlayAnimation("interact_passive")
			inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote_nuzzle")
        end,
        onexit = function(inst)
            inst:PerformBufferedAction()
            inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/scratch_ground")
        end,
        events=
        {
            EventHandler("animover", function (inst)
                inst.sg:GoToState("idle")
            end),
        }
    },
State{
        name = "action2",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
            if inst.components.locomotor ~= nil then
                inst.components.locomotor:StopMoving()
            end
		
		
            inst.AnimState:PlayAnimation("eat_pre")
			--inst.AnimState:PlayAnimation("interact_passive")
            inst.AnimState:PushAnimation("eat_loop", false)
            inst.AnimState:PushAnimation("eat_pst", false)
  
        end,
        onexit = function(inst)
            inst:PerformBufferedAction()
        end,
        events=
        {
            EventHandler("animover", function (inst)
                inst.sg:GoToState("idle")
            end),
        }
    },
-------------------------------------------------------------------
   State{
        name = "chop",
        tags = {"chopping"},
        
        onenter = function(inst)
            inst.Physics:Stop()

			inst.AnimState:PlayAnimation("emote_combat_pre")
        end,
        
        timeline=
        {
	
            TimeEvent(12*FRAMES, function(inst) 
			inst:PerformBufferedAction() 
			inst.AnimState:PlayAnimation("emote_combat_pst")
			end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	State{
        name = "fishing",
        tags = {"fishing"},
        
        onenter = function(inst)
            inst.Physics:Stop()

			inst.AnimState:PlayAnimation("emote_combat_loop")
        end,
        
        timeline=
        {
	
            TimeEvent(16*FRAMES, function(inst) 
			--inst.AnimState:PlayAnimation("emote_combat_pst")
			end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	State{
        name = "fishing2",
        tags = {"fishing"},
        
        onenter = function(inst)
            inst.Physics:Stop()

			inst.AnimState:PlayAnimation("emote_combat_pre")
        end,
        
        timeline=
        {
	
            TimeEvent(12*FRAMES, function(inst) 
			inst.AnimState:PlayAnimation("emote_combat_pst")
			end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
-------------------------------------------------------------------
   State{
        name = "mine",
        tags = {"mining"},
        
        onenter = function(inst)
            inst.Physics:Stop()
			inst.AnimState:PlayAnimation("emote_combat_loop")
  
        end,
        
        timeline=
        {
  
            TimeEvent(16*FRAMES, function(inst) inst:PerformBufferedAction() inst.SoundEmitter:PlaySound("dontstarve/wilson/use_pick_rock") 
			end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },	

-------------------------------------------------------------------	
}

local emotes =
{
	{ anim="emote_stretch",
      timeline=
 		{
			TimeEvent(22*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/yawn") end),
		},
	},
	{ anim="emote_lick",
      timeline=
 		{
			TimeEvent(14*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote_lick") end),
			TimeEvent(36*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote_lick") end),
			TimeEvent(58*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote_lick") end),
		},
	},
}

SGCritterStates.AddIdle(states, #emotes)
SGCritterStates.AddRandomEmotes(states, emotes)
SGCritterStates.AddEmote(states, "cute", 
		{
			TimeEvent(7*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote") end),
			TimeEvent(26*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote") end),
		})
SGCritterStates.AddPetEmote(states, 
	{
		TimeEvent(9*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote_nuzzle") end),
	})
SGCritterStates.AddCombatEmote(states,
		{
			loop =
			{
				TimeEvent(19*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/hiss") end),
			},
		})
SGCritterStates.AddPlayWithOtherCritter(states, events,
	{
		active =
		{
			TimeEvent(9*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/pounce") end),
			TimeEvent(20*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/pounce") end),
			TimeEvent(28*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/pounce") end),
			TimeEvent(36*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/pounce") end),
			TimeEvent(48*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/pounce") end),
			TimeEvent(60*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/pounce") end),
		},
	})
SGCritterStates.AddEat(states,
        {
            TimeEvent(5*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/eat_pre") end),
            TimeEvent(21*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/eat") end),
        })
SGCritterStates.AddHungry(states,
        {
            TimeEvent(23*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/disstress") end),
            TimeEvent(43*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/disstress") end),
        })
SGCritterStates.AddNuzzle(states, actionhandlers,
        {
            TimeEvent(12*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/emote_nuzzle") end),
        })

SGCritterStates.AddWalkStates(states, nil, true)
CommonStates.AddSleepExStates(states,
		{
			starttimeline = 
			{
				TimeEvent(12*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/yawn") end),
			},
			sleeptimeline = 
			{
				TimeEvent(31*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/kittington/sleep") end),
			},
		})

return StateGraph("SGcritter_kitten", states, events, "idle", actionhandlers)
