require("stategraphs/commonstates")
require("stategraphs/SGcritter_common")

local actionhandlers = 
{
    ActionHandler(ACTIONS.PICKUP, "action"),
    ActionHandler(ACTIONS.PICK, "action"),
    ActionHandler(ACTIONS.HARVEST, "action"),
	ActionHandler(ACTIONS.EAT, "action2"),
	ActionHandler(ACTIONS.CHOP, "chop"),
	ActionHandler(ACTIONS.MINE, "mine"),
	
}

local events =
{
	SGCritterEvents.OnEat(),
    SGCritterEvents.OnAvoidCombat(),
	SGCritterEvents.OnTraitChanged(),

    CommonHandlers.OnSleepEx(),
    CommonHandlers.OnWakeEx(),
    CommonHandlers.OnLocomote(false,true),
	EventHandler("doattack", function(inst) inst.sg:GoToState("attack") end),
	EventHandler("doaction", 
        function(inst, data) 
            if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
                if data.action == ACTIONS.CHOP then
                    inst.sg:GoToState("chop", data.target)
                end
            end
        end),
	EventHandler("doaction", 
        function(inst, data) 
            if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
                if data.action == ACTIONS.MINE then
                    inst.sg:GoToState("mine", data.target)
                end
            end
        end),	
	EventHandler("attacked", function(inst,data)
        if not inst.components.health:IsDead() then
            inst.sg:GoToState("attack")
        end
    end),
}

local states =
{
State{
        name = "attack",
        tags = { "attack" },
        
        onenter = function(inst)
           inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/yell")
            inst.components.combat:StartAttack()
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("emote_combat_pre")
        end,

        timeline =
        {
            TimeEvent(12 * FRAMES, function(inst)
			inst.AnimState:PlayAnimation("emote_combat_pst")
                inst.components.combat:DoAttack()
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                inst.sg:GoToState("idle")
            end),
        },
    },
State{
        name = "fastwork",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
			if inst.components.locomotor ~= nil then
                inst.components.locomotor:StopMoving()
            end
            inst.AnimState:PlayAnimation("interact_active")
			
			end,
			 timeline=
			{
            TimeEvent(12*FRAMES, function(inst) 
			inst:PerformBufferedAction() 
	
			inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/scratch_ground")
			end ),
			},
        events=
        {
            EventHandler("animover", function (inst)
                inst.sg:GoToState("idle")
            end),
        }
    },
State{
        name = "action",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
			if inst.components.locomotor ~= nil then
                inst.components.locomotor:StopMoving()
            end
            inst.AnimState:PlayAnimation("interact_active")
			inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/curious")
        end,
        onexit = function(inst)
            inst:PerformBufferedAction()
            inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/scratch_ground")
        end,
        events=
        {
            EventHandler("animover", function (inst)
                inst.sg:GoToState("idle")
            end),
        }
    },
State{
        name = "action2",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
            if inst.components.locomotor ~= nil then
                inst.components.locomotor:StopMoving()
            end
		
		
            inst.AnimState:PlayAnimation("eat_pre", false)
			--inst.AnimState:PlayAnimation("interact_passive")
            inst.AnimState:PushAnimation("eat_loop", false)
            inst.AnimState:PushAnimation("eat_pst", false)
  
        end,
        onexit = function(inst)
            inst:PerformBufferedAction()
        end,
        events=
        {
            EventHandler("animover", function (inst)
                inst.sg:GoToState("idle")
            end),
        }
    }	,

-------------------------------------------------------------------
   State{
        name = "chop",
        tags = {"chopping"},
        
        onenter = function(inst)
            inst.Physics:Stop()
			local random_ani = math.random(1, 2)
			if random_ani == 1 then
			inst.AnimState:PlayAnimation("interact_active")
			else
			inst.AnimState:PlayAnimation("emote_stallion")
			end
  
        end,
        
        timeline=
        {
            TimeEvent(18*FRAMES, function(inst) inst:PerformBufferedAction() end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
-------------------------------------------------------------------
   State{
        name = "mine",
        tags = {"mining"},
        
        onenter = function(inst)
            inst.Physics:Stop()
			local random_ani = math.random(1, 2)
			if random_ani == 1 then
			inst.AnimState:PlayAnimation("interact_active")
			else
			inst.AnimState:PlayAnimation("emote_stallion")
			end
  
        end,
        
        timeline=
        {
            TimeEvent(18*FRAMES, function(inst) inst:PerformBufferedAction() inst.SoundEmitter:PlaySound("dontstarve/wilson/use_pick_rock") end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },	

-------------------------------------------------------------------
}

local emotes =
{
	{ anim="emote_shuffle",
      timeline=
		{
			TimeEvent(10*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/walk") end),
			TimeEvent(19*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/walk") end),
			TimeEvent(25*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/walk") end),
			TimeEvent(30*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/walk") end),
		},
    },
	{ anim="emote_stallion",
      timeline=
 		{
            TimeEvent(24*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/stallion") end),
			TimeEvent(24*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/grunt") end),
            TimeEvent(28*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/stallion") end),
            TimeEvent(40*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/stallion") end),
			TimeEvent(40*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/grunt") end),
            TimeEvent(45*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/stallion") end),
		},
	},
}

SGCritterStates.AddIdle(states, #emotes)
SGCritterStates.AddRandomEmotes(states, emotes)
SGCritterStates.AddEmote(states, "cute",
        {
            TimeEvent(28*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/yell") end),
        })
SGCritterStates.AddPetEmote(states,
        {
            TimeEvent(10*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/yell") end),
        })
SGCritterStates.AddCombatEmote(states, nil)
SGCritterStates.AddPlayWithOtherCritter(states, events, nil)
SGCritterStates.AddEat(states,
        {
            TimeEvent(6*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/curious") end),

            TimeEvent((22+16)*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/chew") end),
        })
SGCritterStates.AddHungry(states,
        {
            TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/angry") end),
        })
SGCritterStates.AddNuzzle(states, actionhandlers,
        {
            TimeEvent(19*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/grunt") end),
        })

SGCritterStates.AddWalkStates(states, 
	{
		walktimeline =
		{
			TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/walk") end),
		},
		endtimeline =
		{
			TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/walk") end),
		},
	}, true)
CommonStates.AddSleepExStates(states,
		{
			starttimeline = 
			{
				TimeEvent(22*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/bodyfall") end),
			},
			sleeptimeline = 
			{
				TimeEvent(22*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/sleep") end),
				TimeEvent(57*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/together/sheepington/sleep") end),
			},
		})

return StateGraph("SGcritter_lamb", states, events, "idle", actionhandlers)
