USE [master]
GO
/****** :  Database [chuancrm]    ű: 03/30/2012 10:37:53 ******/
CREATE DATABASE [chuancrm] ON  PRIMARY 
( NAME = N'chuancrm', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Data\chuancrm.mdf' , SIZE = 3072KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'chuancrm_log', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Data\chuancrm_log.ldf' , SIZE = 1024KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
 COLLATE Chinese_PRC_CI_AS
GO
EXEC dbo.sp_dbcmptlevel @dbname=N'chuancrm', @new_cmptlevel=90
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [chuancrm].[dbo].[sp_fulltext_database] @action = 'disable'
end
GO
ALTER DATABASE [chuancrm] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [chuancrm] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [chuancrm] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [chuancrm] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [chuancrm] SET ARITHABORT OFF 
GO
ALTER DATABASE [chuancrm] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [chuancrm] SET AUTO_CREATE_STATISTICS ON 
GO
ALTER DATABASE [chuancrm] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [chuancrm] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [chuancrm] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [chuancrm] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [chuancrm] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [chuancrm] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [chuancrm] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [chuancrm] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [chuancrm] SET  ENABLE_BROKER 
GO
ALTER DATABASE [chuancrm] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [chuancrm] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [chuancrm] SET TRUSTWORTHY OFF 
GO
ALTER DATABASE [chuancrm] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO
ALTER DATABASE [chuancrm] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [chuancrm] SET  READ_WRITE 
GO
ALTER DATABASE [chuancrm] SET RECOVERY FULL 
GO
ALTER DATABASE [chuancrm] SET  MULTI_USER 
GO
ALTER DATABASE [chuancrm] SET PAGE_VERIFY CHECKSUM  
GO
ALTER DATABASE [chuancrm] SET DB_CHAINING OFF 


USE [chuancrm]
GO
/****** :  Table [dbo].[enterprise]    ű: 03/30/2012 10:39:36 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[enterprise](
	[companyid] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](100) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[pinyin] [varchar](256) COLLATE Chinese_PRC_CI_AS NULL,
	[phone] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[address] [varchar](100) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[fax] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[contact] [varchar](20) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[salesid] [varchar](10) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[email] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[qqnum] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[contactclass] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[salestext] [varchar](1024) COLLATE Chinese_PRC_CI_AS NULL,
	[ispublic] [varchar](1) COLLATE Chinese_PRC_CI_AS NULL,
	[date] [datetime] NOT NULL,
	[newdate] [datetime] NOT NULL,
	[orderdate] [datetime] NULL,
	[otherinfo] [varchar](128) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_enterprise] PRIMARY KEY CLUSTERED 
(
	[companyid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF

USE [chuancrm]
GO
/****** :  Table [dbo].[problem]    ű: 03/30/2012 10:40:04 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[problem](
	[problemid] [int] IDENTITY(1,1) NOT NULL,
	[class] [varchar](100) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[text] [varchar](1024) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[salesid] [varchar](20) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[zhuguanid] [varchar](20) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[date] [datetime] NOT NULL,
 CONSTRAINT [PK_problem] PRIMARY KEY CLUSTERED 
(
	[problemid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF

USE [chuancrm]
GO
/****** :  Table [dbo].[salesproblem]    ű: 03/30/2012 10:40:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[salesproblem](
	[problemid] [int] IDENTITY(1,1) NOT NULL,
	[title] [varchar](100) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[text] [varchar](1024) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[salesid] [varchar](20) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[date] [datetime] NOT NULL,
	[otherinfo] [varchar](128) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_salesproblem] PRIMARY KEY CLUSTERED 
(
	[problemid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF

USE [chuancrm]
GO
/****** :  Table [dbo].[userinfo]    ű: 03/30/2012 10:40:38 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[userinfo](
	[userid] [int] IDENTITY(1,1) NOT NULL,
	[username] [varchar](20) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[chinese] [varchar](20) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[password] [varchar](40) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[telphone] [varchar](11) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[sex] [varchar](2) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[email] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[birthday] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[address] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[idcard] [varchar](18) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[grade] [varchar](20) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[islocked] [varchar](1) COLLATE Chinese_PRC_CI_AS NULL,
	[regdate] [datetime] NOT NULL,
	[regip] [varchar](16) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[otherinfo] [varchar](128) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_userinfo] PRIMARY KEY CLUSTERED 
(
	[userid] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF

INSERT INTO [chuancrm].[dbo].[userinfo](username,chinese,password,telphone,sex,email,birthday,address,idcard,grade,islocked,regdate,regip,otherinfo) VALUES ('admin','ɴ','ED919412E4656CFD288BCD080581688CBC26EE20','4006657780','','admin@fangchengchuan.com','19920928','ְҵѧԺ','342410199209281521','',null,'2012-3-29 19:35:54','192.168.1.1','ӭʹChuanCRMϵͳ')